/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.util.IAFMath;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class DragonAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    private final int targetChance;
    protected ItemEntity targetEntity;
    private boolean isIce = false;
    @Nonnull
    private List<ItemEntity> list = IAFMath.emptyItemEntityList;

    public DragonAITargetItems(EntityDragonBase creature, boolean checkSight) {
        this(creature, checkSight, false);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public DragonAITargetItems(EntityDragonBase creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby);
        this.isIce = creature instanceof EntityIceDragon;
    }

    public DragonAITargetItems(EntityDragonBase creature, int chance, boolean checkSight, boolean onlyNearby) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.isIce = creature instanceof EntityIceDragon;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            @Override
            public boolean test(ItemEntity item) {
                return item != null && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() != null && FoodUtils.getFoodPoints(item.func_92059_d(), true, DragonAITargetItems.this.isIce) > 0;
            }
        };
    }

    public boolean func_75250_a() {
        EntityDragonBase dragon = (EntityDragonBase)this.field_75299_d;
        if (dragon.getHunger() >= 100 || !dragon.canMove() || this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(10) != 0) {
            this.list = IAFMath.emptyItemEntityList;
            return false;
        }
        if (this.field_75299_d.field_70170_p.func_82737_E() % 4L == 0L) {
            this.list = this.field_75299_d.field_70170_p.func_225316_b(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        } else if (this.field_75299_d.func_70068_e((Entity)this.targetEntity) < (double)(this.field_75299_d.func_213311_cf() * 2.0f + this.field_75299_d.func_213302_cg() / 2.0f) || this.field_75299_d instanceof EntityDragonBase && ((EntityDragonBase)this.field_75299_d).getHeadPosition().func_72436_e(this.targetEntity.func_213303_ch()) < (double)this.field_75299_d.func_213302_cg()) {
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            int hunger = FoodUtils.getFoodPoints(this.targetEntity.func_92059_d(), true, this.isIce);
            EntityDragonBase dragon = (EntityDragonBase)this.field_75299_d;
            dragon.setHunger(Math.min(100, ((EntityDragonBase)this.field_75299_d).getHunger() + hunger));
            dragon.eatFoodBonus(this.targetEntity.func_92059_d());
            this.field_75299_d.func_70606_j(Math.min(this.field_75299_d.func_110138_aP(), (float)((int)(this.field_75299_d.func_110143_aJ() + (float)FoodUtils.getFoodPoints(this.targetEntity.func_92059_d(), true, this.isIce)))));
            if (EntityDragonBase.ANIMATION_EAT != null) {
                dragon.setAnimation(EntityDragonBase.ANIMATION_EAT);
            }
            for (int i = 0; i < 4; ++i) {
                dragon.spawnItemCrackParticles(this.targetEntity.func_92059_d().func_77973_b());
            }
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            double d1 = this.theEntity.func_70068_e(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

