/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class DragonAITarget<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private EntityDragonBase dragon;

    public DragonAITarget(EntityDragonBase entityIn, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super((MobEntity)entityIn, classTarget, 3, checkSight, false, targetSelector);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        this.dragon = entityIn;
    }

    public boolean func_75250_a() {
        if (this.dragon.getCommand() == 1 || this.dragon.getCommand() == 2 || this.dragon.func_70608_bn()) {
            return false;
        }
        if (!this.dragon.func_70909_n() && this.dragon.lookingForRoostAIFlag) {
            return false;
        }
        if (this.field_75309_a != null && !this.field_75309_a.getClass().equals(this.dragon.getClass())) {
            if (!super.func_75250_a()) {
                return false;
            }
            float dragonSize = Math.max(this.dragon.func_213311_cf(), this.dragon.func_213311_cf() * this.dragon.getRenderSize());
            if (dragonSize >= this.field_75309_a.func_213311_cf()) {
                if (this.field_75309_a instanceof PlayerEntity && !this.dragon.func_70909_n()) {
                    return true;
                }
                if (this.field_75309_a instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)this.field_75309_a;
                    if (dragon.func_70902_q() != null && this.dragon.func_70902_q() != null && this.dragon.func_152114_e(dragon.func_70902_q())) {
                        return false;
                    }
                    return !dragon.isModelDead();
                }
                if (this.field_75309_a instanceof PlayerEntity && this.dragon.func_70909_n()) {
                    return false;
                }
                if (!this.dragon.func_152114_e(this.field_75309_a) && FoodUtils.getFoodPoints((Entity)this.field_75309_a) > 0 && this.dragon.canMove() && (this.dragon.getHunger() < 90 || !this.dragon.func_70909_n() && this.field_75309_a instanceof PlayerEntity)) {
                    if (this.dragon.func_70909_n()) {
                        return DragonUtils.canTameDragonAttack(this.dragon, (Entity)this.field_75309_a);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected AxisAlignedBB func_188511_a(double targetDistance) {
        return this.dragon.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
    }

    protected double func_111175_f() {
        ModifiableAttributeInstance iattributeinstance = this.field_75299_d.func_110148_a(Attributes.field_233819_b_);
        return iattributeinstance == null ? 64.0 : iattributeinstance.func_111126_e();
    }
}

