/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityAmphithereArrow;
import com.github.alexthe666.iceandfire.entity.EntityChainTie;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCockatriceEgg;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityCyclopsEye;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityDeathWormEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonArrow;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceCharge;
import com.github.alexthe666.iceandfire.entity.EntityDragonLightningCharge;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.EntityDragonSkull;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadHorse;
import com.github.alexthe666.iceandfire.entity.EntityDreadKnight;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadLichSkull;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityGhostSword;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHippogryphEgg;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraArrow;
import com.github.alexthe666.iceandfire.entity.EntityHydraBreath;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.EntityMobSkull;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSwarmer;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.EntityPixieCharge;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentArrow;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentBubbles;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntitySlowPart;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianArrow;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianFeather;
import com.github.alexthe666.iceandfire.entity.EntityTideTrident;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IafEntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"iceandfire");
    public static final RegistryObject<EntityType<EntityDragonPart>> DRAGON_MULTIPART = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonPart::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_220320_c().setCustomClientFactory(EntityDragonPart::new), "dragon_multipart");
    public static final RegistryObject<EntityType<EntitySlowPart>> SLOW_MULTIPART = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySlowPart::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_220320_c().setCustomClientFactory(EntitySlowPart::new), "multipart");
    public static final RegistryObject<EntityType<EntityHydraHead>> HYDRA_MULTIPART = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHydraHead::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_220320_c().setCustomClientFactory(EntityHydraHead::new), "hydra_multipart");
    public static final RegistryObject<EntityType<EntityCyclopsEye>> CYCLOPS_MULTIPART = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityCyclopsEye::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_220320_c().setCustomClientFactory(EntityCyclopsEye::new), "cylcops_multipart");
    public static final RegistryObject<EntityType<EntityDragonEgg>> DRAGON_EGG = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonEgg::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.45f, 0.55f).func_220320_c(), "dragon_egg");
    public static final RegistryObject<EntityType<EntityDragonArrow>> DRAGON_ARROW = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityDragonArrow::new), "dragon_arrow");
    public static final RegistryObject<EntityType<EntityDragonSkull>> DRAGON_SKULL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonSkull::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.65f), "dragon_skull");
    public static final RegistryObject<EntityType<EntityFireDragon>> FIRE_DRAGON = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityFireDragon::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.78f, 1.2f).func_220320_c().setTrackingRange(256), "fire_dragon");
    public static final RegistryObject<EntityType<EntityIceDragon>> ICE_DRAGON = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityIceDragon::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.78f, 1.2f).setTrackingRange(256), "ice_dragon");
    public static final RegistryObject<EntityType<EntityLightningDragon>> LIGHTNING_DRAGON = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityLightningDragon::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.78f, 1.2f).setTrackingRange(256), "lightning_dragon");
    public static final RegistryObject<EntityType<EntityDragonFireCharge>> FIRE_DRAGON_CHARGE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonFireCharge::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setCustomClientFactory(EntityDragonFireCharge::new), "fire_dragon_charge");
    public static final RegistryObject<EntityType<EntityDragonIceCharge>> ICE_DRAGON_CHARGE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonIceCharge::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setCustomClientFactory(EntityDragonIceCharge::new), "ice_dragon_charge");
    public static final RegistryObject<EntityType<EntityDragonLightningCharge>> LIGHTNING_DRAGON_CHARGE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDragonLightningCharge::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setCustomClientFactory(EntityDragonLightningCharge::new), "lightning_dragon_charge");
    public static final RegistryObject<EntityType<EntityHippogryphEgg>> HIPPOGRYPH_EGG = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHippogryphEgg::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f), "hippogryph_egg");
    public static final RegistryObject<EntityType<EntityHippogryph>> HIPPOGRYPH = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHippogryph::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.7f, 1.6f).setTrackingRange(128), "hippogryph");
    public static final RegistryObject<EntityType<EntityStoneStatue>> STONE_STATUE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityStoneStatue::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.5f), "stone_statue");
    public static final RegistryObject<EntityType<EntityGorgon>> GORGON = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityGorgon::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 1.99f), "gorgon");
    public static final RegistryObject<EntityType<EntityPixie>> PIXIE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPixie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.8f), "pixie");
    public static final RegistryObject<EntityType<EntityCyclops>> CYCLOPS = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityCyclops::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.95f, 7.4f), "cyclops");
    public static final RegistryObject<EntityType<EntitySiren>> SIREN = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySiren::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.6f, 0.9f), "siren");
    public static final RegistryObject<EntityType<EntityHippocampus>> HIPPOCAMPUS = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHippocampus::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.95f, 0.95f), "hippocampus");
    public static final RegistryObject<EntityType<EntityDeathWorm>> DEATH_WORM = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDeathWorm::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 0.8f).setTrackingRange(128), "deathworm");
    public static final RegistryObject<EntityType<EntityDeathWormEgg>> DEATH_WORM_EGG = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDeathWormEgg::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f), "deathworm_egg");
    public static final RegistryObject<EntityType<EntityCockatrice>> COCKATRICE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityCockatrice::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.95f, 0.95f), "cockatrice");
    public static final RegistryObject<EntityType<EntityCockatriceEgg>> COCKATRICE_EGG = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityCockatriceEgg::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f), "cockatrice_egg");
    public static final RegistryObject<EntityType<EntityStymphalianBird>> STYMPHALIAN_BIRD = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityStymphalianBird::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3f, 1.2f).setTrackingRange(128), "stymphalian_bird");
    public static final RegistryObject<EntityType<EntityStymphalianFeather>> STYMPHALIAN_FEATHER = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityStymphalianFeather::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityStymphalianFeather::new), "stymphalian_feather");
    public static final RegistryObject<EntityType<EntityStymphalianArrow>> STYMPHALIAN_ARROW = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityStymphalianArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityStymphalianArrow::new), "stymphalian_arrow");
    public static final RegistryObject<EntityType<EntityTroll>> TROLL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityTroll::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 3.5f), "troll");
    public static final RegistryObject<EntityType<EntityMyrmexWorker>> MYRMEX_WORKER = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexWorker::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f), "myrmex_worker");
    public static final RegistryObject<EntityType<EntityMyrmexSoldier>> MYRMEX_SOLDIER = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexSoldier::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.2f, 0.95f), "myrmex_soldier");
    public static final RegistryObject<EntityType<EntityMyrmexSentinel>> MYRMEX_SENTINEL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexSentinel::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3f, 1.95f), "myrmex_sentinel");
    public static final RegistryObject<EntityType<EntityMyrmexRoyal>> MYRMEX_ROYAL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexRoyal::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.9f, 1.86f), "myrmex_royal");
    public static final RegistryObject<EntityType<EntityMyrmexQueen>> MYRMEX_QUEEN = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexQueen::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.9f, 1.86f), "myrmex_queen");
    public static final RegistryObject<EntityType<EntityMyrmexEgg>> MYRMEX_EGG = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexEgg::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.45f, 0.55f), "myrmex_egg");
    public static final RegistryObject<EntityType<EntityAmphithere>> AMPHITHERE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityAmphithere::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.5f, 1.25f).setTrackingRange(128), "amphithere");
    public static final RegistryObject<EntityType<EntityAmphithereArrow>> AMPHITHERE_ARROW = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityAmphithereArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityAmphithereArrow::new), "amphithere_arrow");
    public static final RegistryObject<EntityType<EntitySeaSerpent>> SEA_SERPENT = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySeaSerpent::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.5f).setTrackingRange(256), "sea_serpent");
    public static final RegistryObject<EntityType<EntitySeaSerpentBubbles>> SEA_SERPENT_BUBBLES = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySeaSerpentBubbles::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setCustomClientFactory(EntitySeaSerpentBubbles::new), "sea_serpent_bubbles");
    public static final RegistryObject<EntityType<EntitySeaSerpentArrow>> SEA_SERPENT_ARROW = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntitySeaSerpentArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntitySeaSerpentArrow::new), "sea_serpent_arrow");
    public static final RegistryObject<EntityType<EntityChainTie>> CHAIN_TIE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityChainTie::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.8f, 0.9f), "chain_tie");
    public static final RegistryObject<EntityType<EntityPixieCharge>> PIXIE_CHARGE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityPixieCharge::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityPixieCharge::new), "pixie_charge");
    public static final RegistryObject<EntityType<EntityMyrmexSwarmer>> MYRMEX_SWARMER = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMyrmexSwarmer::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.9f, 1.86f), "myrmex_swarmer");
    public static final RegistryObject<EntityType<EntityTideTrident>> TIDE_TRIDENT = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityTideTrident::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.85f, 0.5f).setCustomClientFactory(EntityTideTrident::new), "tide_trident");
    public static final RegistryObject<EntityType<EntityMobSkull>> MOB_SKULL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityMobSkull::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.85f, 0.85f), "mob_skull");
    public static final RegistryObject<EntityType<EntityDreadThrall>> DREAD_THRALL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadThrall::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.8f), "dread_thrall");
    public static final RegistryObject<EntityType<EntityDreadGhoul>> DREAD_GHOUL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadGhoul::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.8f), "dread_ghoul");
    public static final RegistryObject<EntityType<EntityDreadBeast>> DREAD_BEAST = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadBeast::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.2f, 0.9f), "dread_beast");
    public static final RegistryObject<EntityType<EntityDreadScuttler>> DREAD_SCUTTLER = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadScuttler::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.5f, 1.3f), "dread_scuttler");
    public static final RegistryObject<EntityType<EntityDreadLich>> DREAD_LICH = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadLich::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.8f), "dread_lich");
    public static final RegistryObject<EntityType<EntityDreadLichSkull>> DREAD_LICH_SKULL = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadLichSkull::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityDreadLichSkull::new), "dread_lich_skull");
    public static final RegistryObject<EntityType<EntityDreadKnight>> DREAD_KNIGHT = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadKnight::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.8f), "dread_knight");
    public static final RegistryObject<EntityType<EntityDreadHorse>> DREAD_HORSE = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityDreadHorse::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f), "dread_horse");
    public static final RegistryObject<EntityType<EntityHydra>> HYDRA = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHydra::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.8f, 1.39f), "hydra");
    public static final RegistryObject<EntityType<EntityHydraBreath>> HYDRA_BREATH = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHydraBreath::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setCustomClientFactory(EntityHydraBreath::new), "hydra_breath");
    public static final RegistryObject<EntityType<EntityHydraArrow>> HYDRA_ARROW = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityHydraArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityHydraArrow::new), "hydra_arrow");
    public static final RegistryObject<EntityType<EntityGhost>> GHOST = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityGhost::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 1.9f).func_220320_c(), "ghost");
    public static final RegistryObject<EntityType<EntityGhostSword>> GHOST_SWORD = IafEntityRegistry.registerEntity(EntityType.Builder.func_220322_a(EntityGhostSword::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(EntityGhostSword::new), "ghost_sword");
    public static HashMap<String, Boolean> LOADED_ENTITIES = new HashMap();

    private static final <T extends Entity> RegistryObject<EntityType<T>> registerEntity(EntityType.Builder<T> builder, String entityName) {
        return ENTITIES.register(entityName, () -> builder.func_206830_a(entityName));
    }

    public static void setup() {
    }

    @SubscribeEvent
    public static void bakeAttributes(EntityAttributeCreationEvent creationEvent) {
        creationEvent.put((EntityType)DRAGON_EGG.get(), EntityDragonEgg.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DRAGON_SKULL.get(), EntityDragonSkull.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)FIRE_DRAGON.get(), EntityFireDragon.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)ICE_DRAGON.get(), EntityIceDragon.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)LIGHTNING_DRAGON.get(), EntityLightningDragon.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)HIPPOGRYPH.get(), EntityHippogryph.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)GORGON.get(), EntityGorgon.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)STONE_STATUE.get(), EntityStoneStatue.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)PIXIE.get(), EntityPixie.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)CYCLOPS.get(), EntityCyclops.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)SIREN.get(), EntitySiren.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)HIPPOCAMPUS.get(), EntityHippocampus.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DEATH_WORM.get(), EntityDeathWorm.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)COCKATRICE.get(), EntityCockatrice.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)STYMPHALIAN_BIRD.get(), EntityStymphalianBird.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)TROLL.get(), EntityTroll.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_WORKER.get(), EntityMyrmexWorker.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_SOLDIER.get(), EntityMyrmexSoldier.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_SENTINEL.get(), EntityMyrmexSentinel.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_ROYAL.get(), EntityMyrmexRoyal.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_QUEEN.get(), EntityMyrmexQueen.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_EGG.get(), EntityMyrmexEgg.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MYRMEX_SWARMER.get(), EntityMyrmexSwarmer.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)AMPHITHERE.get(), EntityAmphithere.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)SEA_SERPENT.get(), EntitySeaSerpent.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)MOB_SKULL.get(), EntityMobSkull.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_THRALL.get(), EntityDreadThrall.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_LICH.get(), EntityDreadLich.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_BEAST.get(), EntityDreadBeast.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_HORSE.get(), EntityDreadHorse.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_GHOUL.get(), EntityDreadGhoul.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_KNIGHT.get(), EntityDreadKnight.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)DREAD_SCUTTLER.get(), EntityDreadScuttler.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)HYDRA.get(), EntityHydra.bakeAttributes().func_233813_a_());
        creationEvent.put((EntityType)GHOST.get(), EntityGhost.bakeAttributes().func_233813_a_());
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HIPPOGRYPH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)TROLL.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTroll::canTrollSpawnOn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)DREAD_LICH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityDreadLich::canLichSpawnOn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)COCKATRICE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)AMPHITHERE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, EntityAmphithere::canAmphithereSpawnOn);
    }

    public static void onBiomesLoad(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (IafConfig.spawnHippogryphs && BiomeConfig.test(BiomeConfig.hippogryphBiomes, biome)) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)HIPPOGRYPH.get(), IafConfig.hippogryphSpawnRate, 1, 1));
            LOADED_ENTITIES.put("HIPPOGRYPH", true);
        }
        if (IafConfig.spawnLiches && BiomeConfig.test(BiomeConfig.mausoleumBiomes, biome)) {
            event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)DREAD_LICH.get(), IafConfig.lichSpawnRate, 1, 1));
            LOADED_ENTITIES.put("DREAD_LICH", true);
        }
        if (IafConfig.spawnCockatrices && BiomeConfig.test(BiomeConfig.cockatriceBiomes, biome)) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)COCKATRICE.get(), IafConfig.cockatriceSpawnRate, 1, 2));
            LOADED_ENTITIES.put("COCKATRICE", true);
        }
        if (IafConfig.spawnAmphitheres && BiomeConfig.test(BiomeConfig.amphithereBiomes, biome)) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners((EntityType)AMPHITHERE.get(), IafConfig.amphithereSpawnRate, 1, 3));
            LOADED_ENTITIES.put("AMPHITHERE", true);
        }
        if (IafConfig.spawnTrolls && (BiomeConfig.test(BiomeConfig.forestTrollBiomes, biome) || BiomeConfig.test(BiomeConfig.snowyTrollBiomes, biome) || BiomeConfig.test(BiomeConfig.mountainTrollBiomes, biome))) {
            event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)TROLL.get(), IafConfig.trollSpawnRate, 1, 3));
            if (BiomeConfig.test(BiomeConfig.forestTrollBiomes, biome)) {
                LOADED_ENTITIES.put("TROLL_F", true);
            }
            if (BiomeConfig.test(BiomeConfig.snowyTrollBiomes, biome)) {
                LOADED_ENTITIES.put("TROLL_S", true);
            }
            if (BiomeConfig.test(BiomeConfig.mountainTrollBiomes, biome)) {
                LOADED_ENTITIES.put("TROLL_M", true);
            }
        }
    }

    static {
        LOADED_ENTITIES.put("HIPPOGRYPH", false);
        LOADED_ENTITIES.put("DREAD_LICH", false);
        LOADED_ENTITIES.put("COCKATRICE", false);
        LOADED_ENTITIES.put("AMPHITHERE", false);
        LOADED_ENTITIES.put("TROLL_F", false);
        LOADED_ENTITIES.put("TROLL_S", false);
        LOADED_ENTITIES.put("TROLL_M", false);
    }
}

