/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityDragonEgg
extends LivingEntity
implements IBlacklistedFromStatues,
IDeadMob {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDragonEgg.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> DRAGON_TYPE = EntityDataManager.func_187226_a(EntityDragonEgg.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRAGON_AGE = EntityDataManager.func_187226_a(EntityDragonEgg.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityDragonEgg(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.0);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("Color", (int)((byte)this.getEggType().ordinal()));
        tag.func_74768_a("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.func_74778_a("OwnerUUID", "");
            } else {
                tag.func_74778_a("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        String s;
        super.func_70037_a(tag);
        this.setEggType(EnumDragonEgg.values()[tag.func_74762_e("Color")]);
        this.setDragonAge(tag.func_74762_e("DragonAge"));
        if (tag.func_150297_b("OwnerUUID", 8)) {
            s = tag.func_74779_i("OwnerUUID");
        } else {
            String s1 = tag.func_74779_i("Owner");
            UUID converedUUID = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DRAGON_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(DRAGON_AGE, (Object)0);
        this.func_184212_Q().func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public EnumDragonEgg getEggType() {
        return EnumDragonEgg.values()[(Integer)this.func_184212_Q().func_187225_a(DRAGON_TYPE)];
    }

    public void setEggType(EnumDragonEgg newtype) {
        this.func_184212_Q().func_187227_b(DRAGON_TYPE, (Object)newtype.ordinal());
    }

    public boolean func_180431_b(DamageSource i) {
        return i.func_76346_g() != null && super.func_180431_b(i);
    }

    public int getDragonAge() {
        return (Integer)this.func_184212_Q().func_187225_a(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.func_184212_Q().func_187227_b(DRAGON_AGE, (Object)i);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            this.func_70050_g(200);
            this.getEggType().dragonType.updateEggCondition(this);
        }
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (!(this.field_70170_p.field_72995_K || var1.func_76357_e() || this.field_70128_L)) {
            this.func_199702_a((IItemProvider)this.getItem().func_77973_b(), 1);
        }
        this.func_70106_y();
        return true;
    }

    private ItemStack getItem() {
        switch (this.getEggType().ordinal()) {
            default: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_RED);
            }
            case 1: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_GREEN);
            }
            case 2: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BRONZE);
            }
            case 3: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_GRAY);
            }
            case 4: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BLUE);
            }
            case 5: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_WHITE);
            }
            case 6: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_SAPPHIRE);
            }
            case 7: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_SILVER);
            }
            case 8: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_ELECTRIC);
            }
            case 9: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_AMYTHEST);
            }
            case 10: {
                return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_COPPER);
            }
            case 11: 
        }
        return new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BLACK);
    }

    public boolean func_70104_M() {
        return false;
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(PlayerEntity player) {
        this.setOwnerId(player.func_110124_au());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }
}

