/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.client.model.ModelBipedBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerBipedArmor<T extends LivingEntity, M extends ModelBipedBase<T>, A extends ModelBipedBase<T>>
extends LayerRenderer<T, M> {
    private final A modelLeggings;
    private final A modelArmor;
    private final ResourceLocation defaultLegArmor;
    private final ResourceLocation defaultArmor;

    public LayerBipedArmor(IEntityRenderer<T, M> mobRenderer, A modelLeggings, A modelArmor, ResourceLocation defaultArmor, ResourceLocation defaultLegArmor) {
        super(mobRenderer);
        this.modelLeggings = modelLeggings;
        this.modelArmor = modelArmor;
        this.defaultLegArmor = defaultLegArmor;
        this.defaultArmor = defaultArmor;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.CHEST, packedLightIn, this.getSlotModel(EquipmentSlotType.CHEST));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.LEGS, packedLightIn, this.getSlotModel(EquipmentSlotType.LEGS));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.FEET, packedLightIn, this.getSlotModel(EquipmentSlotType.FEET));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.HEAD, packedLightIn, this.getSlotModel(EquipmentSlotType.HEAD));
    }

    private void renderEquipment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, T entityIn, EquipmentSlotType slotType, int packedLightIn, A modelIn) {
        ArmorItem armoritem;
        ItemStack itemstack = entityIn.func_184582_a(slotType);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == slotType) {
            ((ModelBipedBase)this.func_215332_c()).setModelAttributes(modelIn);
            this.setModelSlotVisible(modelIn, slotType);
            boolean flag1 = itemstack.func_77962_s();
            this.renderArmorItem(matrixStackIn, bufferIn, packedLightIn, flag1, modelIn, 1.0f, 1.0f, 1.0f, this.getArmorResource(entityIn, itemstack, slotType, null));
        }
    }

    protected void setModelSlotVisible(A modelIn, EquipmentSlotType slotIn) {
        ((ModelBipedBase)modelIn).setVisible(false);
        switch (slotIn) {
            case HEAD: {
                ((ModelBipedBase)modelIn).head.invisible = false;
                ((ModelBipedBase)modelIn).headware.invisible = false;
                break;
            }
            case CHEST: {
                ((ModelBipedBase)modelIn).body.invisible = false;
                ((ModelBipedBase)modelIn).armRight.invisible = false;
                ((ModelBipedBase)modelIn).armLeft.invisible = false;
                break;
            }
            case LEGS: {
                ((ModelBipedBase)modelIn).body.invisible = false;
                ((ModelBipedBase)modelIn).legRight.invisible = false;
                ((ModelBipedBase)modelIn).legLeft.invisible = false;
                break;
            }
            case FEET: {
                ((ModelBipedBase)modelIn).legRight.invisible = false;
                ((ModelBipedBase)modelIn).legLeft.invisible = false;
            }
        }
    }

    private void renderArmorItem(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean p_241738_5_, A modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_239263_a_((ResourceLocation)armorResource), (boolean)false, (boolean)p_241738_5_);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    private A getSlotModel(EquipmentSlotType equipmentSlotType) {
        return this.isLegSlot(equipmentSlotType) ? this.modelLeggings : this.modelArmor;
    }

    protected boolean isLegSlot(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    public ResourceLocation getArmorResource(T entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        if (this.isLegSlot(slot)) {
            return this.defaultLegArmor;
        }
        return this.defaultArmor;
    }
}

