/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import com.github.alexthe666.iceandfire.client.model.ModelHydraBody;
import com.github.alexthe666.iceandfire.client.model.ModelStonePlayer;
import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderStoneStatue
extends EntityRenderer<EntityStoneStatue> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/block/destroy_stage_0.png"), new ResourceLocation("textures/block/destroy_stage_1.png"), new ResourceLocation("textures/block/destroy_stage_2.png"), new ResourceLocation("textures/block/destroy_stage_3.png"), new ResourceLocation("textures/block/destroy_stage_4.png"), new ResourceLocation("textures/block/destroy_stage_5.png"), new ResourceLocation("textures/block/destroy_stage_6.png"), new ResourceLocation("textures/block/destroy_stage_7.png"), new ResourceLocation("textures/block/destroy_stage_8.png"), new ResourceLocation("textures/block/destroy_stage_9.png")};
    private final Map<String, EntityModel> modelMap = new HashMap<String, EntityModel>();
    private final Map<String, Entity> hollowEntityMap = new HashMap<String, Entity>();

    public RenderStoneStatue(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getEntityTexture(EntityStoneStatue entity) {
        return AtlasTexture.field_110575_b;
    }

    protected void preRenderCallback(EntityStoneStatue entity, MatrixStack matrixStackIn, float partialTickTime) {
        float scale = entity.func_213355_cm() < 0.01f ? 1.0f : entity.func_213355_cm();
        matrixStackIn.func_227862_a_(scale, scale, scale);
    }

    public void render(EntityStoneStatue entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Object model = new PigModel();
        if (this.modelMap.get(entityIn.getTrappedEntityTypeString()) != null) {
            model = this.modelMap.get(entityIn.getTrappedEntityTypeString());
        } else {
            EntityRenderer renderer = (EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(entityIn.getTrappedEntityType());
            if (renderer instanceof IEntityRenderer) {
                model = ((IEntityRenderer)renderer).func_217764_d();
            } else if (entityIn.getTrappedEntityType() == EntityType.field_200729_aH) {
                model = new ModelStonePlayer(0.0f);
            }
            this.modelMap.put(entityIn.getTrappedEntityTypeString(), (EntityModel)model);
        }
        if (model != null) {
            Entity fakeEntity = null;
            if (this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString()) == null) {
                Entity build = entityIn.getTrappedEntityType().func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
                if (build != null) {
                    try {
                        build.func_70020_e(entityIn.getTrappedTag());
                    }
                    catch (Exception e) {
                        IceAndFire.LOGGER.warn("Mob " + entityIn.getTrappedEntityTypeString() + " could not build statue NBT");
                    }
                    fakeEntity = this.hollowEntityMap.putIfAbsent(entityIn.getTrappedEntityTypeString(), build);
                }
            } else {
                fakeEntity = this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString());
            }
            float x = (float)Math.max(model.field_78090_t, 1) / 16.0f;
            float y = (float)Math.max(model.field_78089_u, 1) / 16.0f;
            RenderType tex = IafRenderType.getStoneMobRenderType(x, y);
            if (fakeEntity instanceof EntityTroll) {
                tex = RenderType.func_228638_b_((ResourceLocation)((EntityTroll)fakeEntity).getTrollType().TEXTURE_STONE);
            }
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(tex);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227860_a_();
            float yaw = entityIn.field_70126_B + (entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks;
            boolean shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
            model.field_217114_e = entityIn.func_70631_g_();
            model.field_217113_d = shouldSit;
            model.field_217112_c = entityIn.func_70678_g(partialTicks);
            if (model instanceof AdvancedEntityModel) {
                ((AdvancedEntityModel)model).resetToDefaultPose();
            } else if (fakeEntity != null) {
                model.func_225597_a_(fakeEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            }
            this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
            matrixStackIn.func_227861_a_(0.0, 1.5, 0.0);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw, true));
            if (model instanceof ICustomStatueModel && fakeEntity != null) {
                ((ICustomStatueModel)model).renderStatue(matrixStackIn, ivertexbuilder, packedLightIn, fakeEntity);
                if (model instanceof ModelHydraBody && fakeEntity instanceof EntityHydra) {
                    LayerHydraHead.renderHydraHeads((ModelHydraBody)model, true, matrixStackIn, bufferIn, packedLightIn, (EntityHydra)fakeEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
                }
            } else {
                model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
            if (entityIn.getCrackAmount() >= 1) {
                int i = MathHelper.func_76125_a((int)(entityIn.getCrackAmount() - 1), (int)0, (int)(DESTROY_STAGES.length - 1));
                RenderType crackTex = IafRenderType.getStoneCrackRenderType(DESTROY_STAGES[i], x, y);
                IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(crackTex);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227860_a_();
                this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
                matrixStackIn.func_227861_a_(0.0, 1.5, 0.0);
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw, true));
                if (model instanceof ICustomStatueModel) {
                    ((ICustomStatueModel)model).renderStatue(matrixStackIn, ivertexbuilder2, packedLightIn, fakeEntity);
                } else {
                    model.func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227865_b_();
            }
        }
    }
}

