/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelCockatrice;
import com.github.alexthe666.iceandfire.client.model.ModelCockatriceChick;
import com.github.alexthe666.iceandfire.client.particle.CockatriceBeamRender;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class RenderCockatrice
extends MobRenderer<EntityCockatrice, SegmentedModel<EntityCockatrice>> {
    public static final ResourceLocation TEXTURE_ROOSTER = new ResourceLocation("iceandfire:textures/models/cockatrice/cockatrice_0.png");
    public static final ResourceLocation TEXTURE_HEN = new ResourceLocation("iceandfire:textures/models/cockatrice/cockatrice_1.png");
    public static final ResourceLocation TEXTURE_ROOSTER_CHICK = new ResourceLocation("iceandfire:textures/models/cockatrice/cockatrice_0_chick.png");
    public static final ResourceLocation TEXTURE_HEN_CHICK = new ResourceLocation("iceandfire:textures/models/cockatrice/cockatrice_1_chick.png");
    public static final ModelCockatrice ADULT_MODEL = new ModelCockatrice();
    public static final ModelCockatriceChick BABY_MODEL = new ModelCockatriceChick();

    public RenderCockatrice(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new ModelCockatrice(), 0.6f);
    }

    private Vector3d getPosition(LivingEntity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.field_70142_S + (LivingEntityIn.func_226277_ct_() - LivingEntityIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.field_70137_T + (LivingEntityIn.func_226278_cu_() - LivingEntityIn.field_70137_T) * (double)p_177110_4_;
        double d2 = LivingEntityIn.field_70136_U + (LivingEntityIn.func_226281_cx_() - LivingEntityIn.field_70136_U) * (double)p_177110_4_;
        return new Vector3d(d0, d1, d2);
    }

    public boolean shouldRender(EntityCockatrice livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasTargetedEntity() && (livingentity = livingEntityIn.getTargetedEntity()) != null) {
            Vector3d Vector3d2 = this.getPosition(livingentity, (double)livingentity.func_213302_cg() * 0.5, 1.0f);
            Vector3d Vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.func_70047_e(), 1.0f);
            return camera.func_228957_a_(new AxisAlignedBB(Vector3d1.field_72450_a, Vector3d1.field_72448_b, Vector3d1.field_72449_c, Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c));
        }
        return false;
    }

    public void render(EntityCockatrice entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean blindness;
        this.field_77045_g = entityIn.func_70631_g_() ? BABY_MODEL : ADULT_MODEL;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        LivingEntity livingentity = entityIn.getTargetedEntity();
        boolean bl = blindness = entityIn.func_70644_a(Effects.field_76440_q) || livingentity != null && livingentity.func_70644_a(Effects.field_76440_q);
        if (!blindness && livingentity != null && EntityGorgon.isEntityLookingAt((LivingEntity)entityIn, livingentity, 0.6f) && EntityGorgon.isEntityLookingAt(livingentity, (LivingEntity)entityIn, 0.6f) && livingentity != null) {
            CockatriceBeamRender.render((Entity)entityIn, (Entity)livingentity, matrixStackIn, bufferIn, partialTicks);
        }
    }

    protected void preRenderCallback(EntityCockatrice entity, MatrixStack matrixStackIn, float partialTickTime) {
        if (entity.func_70631_g_()) {
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getEntityTexture(EntityCockatrice cockatrice) {
        if (cockatrice.func_70631_g_()) {
            return cockatrice.isHen() ? TEXTURE_HEN_CHICK : TEXTURE_ROOSTER_CHICK;
        }
        return cockatrice.isHen() ? TEXTURE_HEN : TEXTURE_ROOSTER;
    }
}

