/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderChain {
    private static ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/misc/chain_link.png");

    public static void render(LivingEntity entityLivingIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int lightIn) {
        List<Entity> chainTargets = ChainProperties.getChainedTo(entityLivingIn);
        for (Entity chainTarget : chainTargets) {
            if (chainTarget == null) {
                IceAndFire.LOGGER.warn("Found null value in list of target entities");
                continue;
            }
            try {
                RenderChain.renderLink(entityLivingIn, partialTicks, matrixStackIn, bufferIn, lightIn, chainTarget);
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Could not render chain link for {} connected to {}", (Object)entityLivingIn.toString(), (Object)chainTarget.toString());
            }
        }
    }

    public static <E extends Entity> void renderLink(LivingEntity entityLivingIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int lightIn, E chainTarget) {
        float f3 = entityLivingIn.func_70047_e();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
        Vector3d vector3d = RenderChain.getPosition(chainTarget, (double)chainTarget.func_213302_cg() * 0.5, partialTicks);
        Vector3d vector3d1 = RenderChain.getPosition((Entity)entityLivingIn, f3, partialTicks);
        Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
        float f4 = (float)(vector3d2.func_72433_c() + 0.0);
        vector3d2 = vector3d2.func_72432_b();
        float f5 = (float)Math.acos(vector3d2.field_72448_b);
        float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
        float f7 = -1.0f;
        int j = 255;
        int k = 255;
        int l = 255;
        float f19 = 0.0f;
        float f20 = 0.2f;
        float f21 = 0.0f;
        float f22 = -0.2f;
        float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = 0.0f;
        float f30 = f4 + f29;
        float f32 = 0.75f;
        float f31 = f4 + f32;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)RenderChain.getTexture()));
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        matrixStackIn.func_227860_a_();
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f31, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f32, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f32, lightIn);
        RenderChain.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f31, lightIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    private static void func_229108_a_(IVertexBuilder p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_, int packedLight) {
        p_229108_0_.func_227888_a_(p_229108_1_, p_229108_3_, p_229108_4_, p_229108_5_).func_225586_a_(p_229108_6_, p_229108_7_, p_229108_8_, 255).func_225583_a_(p_229108_9_, p_229108_10_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(p_229108_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static Vector3d getPosition(Entity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.field_70142_S + (LivingEntityIn.func_226277_ct_() - LivingEntityIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.field_70137_T + (LivingEntityIn.func_226278_cu_() - LivingEntityIn.field_70137_T) * (double)p_177110_4_;
        double d2 = LivingEntityIn.field_70136_U + (LivingEntityIn.func_226281_cx_() - LivingEntityIn.field_70136_U) * (double)p_177110_4_;
        return new Vector3d(d0, d1, d2);
    }

    public static ResourceLocation getTexture() {
        return TEXTURE;
    }
}

