/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import org.apache.commons.lang3.tuple.Pair;

public class LightningBoltData {
    private final Random random = new Random();
    private final BoltRenderInfo renderInfo;
    private final Vector3d start;
    private final Vector3d end;
    private final int segments;
    private int count = 1;
    private float size = 0.1f;
    private int lifespan = 30;
    private SpawnFunction spawnFunction = SpawnFunction.delay(60.0f);
    private FadeFunction fadeFunction = FadeFunction.fade(0.5f);

    public LightningBoltData(Vector3d start, Vector3d end) {
        this(BoltRenderInfo.DEFAULT, start, end, (int)Math.sqrt(start.func_72438_d(end) * 100.0));
    }

    public LightningBoltData(BoltRenderInfo info, Vector3d start, Vector3d end, int segments) {
        this.renderInfo = info;
        this.start = start;
        this.end = end;
        this.segments = segments;
    }

    public LightningBoltData count(int count) {
        this.count = count;
        return this;
    }

    public LightningBoltData size(float size) {
        this.size = size;
        return this;
    }

    public LightningBoltData spawn(SpawnFunction spawnFunction) {
        this.spawnFunction = spawnFunction;
        return this;
    }

    public LightningBoltData fade(FadeFunction fadeFunction) {
        this.fadeFunction = fadeFunction;
        return this;
    }

    public LightningBoltData lifespan(int lifespan) {
        this.lifespan = lifespan;
        return this;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public SpawnFunction getSpawnFunction() {
        return this.spawnFunction;
    }

    public FadeFunction getFadeFunction() {
        return this.fadeFunction;
    }

    public Vector4f getColor() {
        return this.renderInfo.color;
    }

    public List<BoltQuads> generate() {
        ArrayList<BoltQuads> quads = new ArrayList<BoltQuads>();
        Vector3d diff = this.end.func_178788_d(this.start);
        float totalDistance = (float)diff.func_72433_c();
        block0: for (int i = 0; i < this.count; ++i) {
            LinkedList<BoltInstructions> drawQueue = new LinkedList<BoltInstructions>();
            drawQueue.add(new BoltInstructions(this.start, 0.0f, new Vector3d(0.0, 0.0, 0.0), null, false));
            while (!drawQueue.isEmpty()) {
                Vector3d segmentEnd;
                BoltInstructions data = (BoltInstructions)drawQueue.poll();
                Vector3d perpendicularDist = data.perpendicularDist;
                float progress = data.progress + 1.0f / (float)this.segments * (1.0f - this.renderInfo.parallelNoise + this.random.nextFloat() * this.renderInfo.parallelNoise * 2.0f);
                if (progress >= 1.0f) {
                    segmentEnd = this.end;
                } else {
                    float segmentDiffScale = this.renderInfo.spreadFunction.getMaxSpread(progress);
                    float maxDiff = this.renderInfo.spreadFactor * segmentDiffScale * totalDistance * this.renderInfo.randomFunction.getRandom(this.random);
                    Vector3d randVec = LightningBoltData.findRandomOrthogonalVector(diff, this.random);
                    perpendicularDist = this.renderInfo.segmentSpreader.getSegmentAdd(perpendicularDist, randVec, maxDiff, segmentDiffScale, progress);
                    segmentEnd = this.start.func_178787_e(diff.func_186678_a((double)progress)).func_178787_e(perpendicularDist);
                }
                float boltSize = this.size * (0.5f + (1.0f - progress) * 0.5f);
                Pair<BoltQuads, QuadCache> quadData = this.createQuads(data.cache, data.start, segmentEnd, boltSize);
                quads.add((BoltQuads)quadData.getLeft());
                if (segmentEnd == this.end) continue block0;
                if (!data.isBranch) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), false));
                } else if (this.random.nextFloat() < this.renderInfo.branchContinuationFactor) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
                while (this.random.nextFloat() < this.renderInfo.branchInitiationFactor * (1.0f - progress)) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
            }
        }
        return quads;
    }

    private static Vector3d findRandomOrthogonalVector(Vector3d vec, Random rand) {
        Vector3d newVec = new Vector3d(-0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
        return vec.func_72431_c(newVec).func_72432_b();
    }

    private Pair<BoltQuads, QuadCache> createQuads(QuadCache cache, Vector3d startPos, Vector3d end, float size) {
        Vector3d diff = end.func_178788_d(startPos);
        Vector3d rightAdd = diff.func_72431_c(new Vector3d(0.5, 0.5, 0.5)).func_72432_b().func_186678_a((double)size);
        Vector3d backAdd = diff.func_72431_c(rightAdd).func_72432_b().func_186678_a((double)size);
        Vector3d rightAddSplit = rightAdd.func_186678_a(0.5);
        Vector3d start = cache != null ? cache.prevEnd : startPos;
        Vector3d startRight = cache != null ? cache.prevEndRight : start.func_178787_e(rightAdd);
        Vector3d startBack = cache != null ? cache.prevEndBack : start.func_178787_e(rightAddSplit).func_178787_e(backAdd);
        Vector3d endRight = end.func_178787_e(rightAdd);
        Vector3d endBack = end.func_178787_e(rightAddSplit).func_178787_e(backAdd);
        BoltQuads quads = new BoltQuads();
        quads.addQuad(start, end, endRight, startRight);
        quads.addQuad(startRight, endRight, end, start);
        quads.addQuad(startRight, endRight, endBack, startBack);
        quads.addQuad(startBack, endBack, endRight, startRight);
        return Pair.of((Object)quads, (Object)new QuadCache(end, endRight, endBack));
    }

    public static class BoltRenderInfo {
        public static final BoltRenderInfo DEFAULT = new BoltRenderInfo();
        public static final BoltRenderInfo ELECTRICITY = BoltRenderInfo.electricity();
        private float parallelNoise = 0.1f;
        private float spreadFactor = 0.1f;
        private float branchInitiationFactor = 0.0f;
        private float branchContinuationFactor = 0.0f;
        private Vector4f color = new Vector4f(0.45f, 0.45f, 0.5f, 0.8f);
        private RandomFunction randomFunction = RandomFunction.GAUSSIAN;
        private SpreadFunction spreadFunction = SpreadFunction.SINE;
        private SegmentSpreader segmentSpreader = SegmentSpreader.NO_MEMORY;

        public static BoltRenderInfo electricity() {
            return new BoltRenderInfo(0.5f, 0.25f, 0.25f, 0.15f, new Vector4f(0.7f, 0.45f, 0.89f, 0.8f), 0.8f);
        }

        public BoltRenderInfo() {
        }

        public BoltRenderInfo(float parallelNoise, float spreadFactor, float branchInitiationFactor, float branchContinuationFactor, Vector4f color, float closeness) {
            this.parallelNoise = parallelNoise;
            this.spreadFactor = spreadFactor;
            this.branchInitiationFactor = branchInitiationFactor;
            this.branchContinuationFactor = branchContinuationFactor;
            this.color = color;
            this.segmentSpreader = SegmentSpreader.memory(closeness);
        }
    }

    public static interface FadeFunction {
        public static final FadeFunction NONE = (totalBolts, lifeScale) -> Pair.of((Object)0, (Object)totalBolts);

        public static FadeFunction fade(float fade) {
            return (totalBolts, lifeScale) -> {
                int start = lifeScale > 1.0f - fade ? (int)((float)totalBolts * (lifeScale - (1.0f - fade)) / fade) : 0;
                int end = lifeScale < fade ? (int)((float)totalBolts * (lifeScale / fade)) : totalBolts;
                return Pair.of((Object)start, (Object)end);
            };
        }

        public Pair<Integer, Integer> getRenderBounds(int var1, float var2);
    }

    public static interface SpawnFunction {
        public static final SpawnFunction NO_DELAY = rand -> Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        public static final SpawnFunction CONSECUTIVE = new SpawnFunction(){

            @Override
            public Pair<Float, Float> getSpawnDelayBounds(Random rand) {
                return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }

            @Override
            public boolean isConsecutive() {
                return true;
            }
        };

        public static SpawnFunction delay(float delay) {
            return rand -> Pair.of((Object)Float.valueOf(delay), (Object)Float.valueOf(delay));
        }

        public static SpawnFunction noise(float delay, float noise) {
            return rand -> Pair.of((Object)Float.valueOf(delay - noise), (Object)Float.valueOf(delay + noise));
        }

        public Pair<Float, Float> getSpawnDelayBounds(Random var1);

        default public float getSpawnDelay(Random rand) {
            Pair<Float, Float> bounds = this.getSpawnDelayBounds(rand);
            return ((Float)bounds.getLeft()).floatValue() + (((Float)bounds.getRight()).floatValue() - ((Float)bounds.getLeft()).floatValue()) * rand.nextFloat();
        }

        default public boolean isConsecutive() {
            return false;
        }
    }

    public static interface SegmentSpreader {
        public static final SegmentSpreader NO_MEMORY = (perpendicularDist, randVec, maxDiff, scale, progress) -> randVec.func_186678_a((double)maxDiff);

        public static SegmentSpreader memory(float memoryFactor) {
            return (perpendicularDist, randVec, maxDiff, spreadScale, progress) -> {
                float nextDiff = maxDiff * (1.0f - memoryFactor);
                Vector3d cur = randVec.func_186678_a((double)nextDiff);
                if (progress > 0.5f) {
                    cur = cur.func_178787_e(perpendicularDist.func_186678_a((double)(-1.0f * (1.0f - spreadScale))));
                }
                return perpendicularDist.func_178787_e(cur);
            };
        }

        public Vector3d getSegmentAdd(Vector3d var1, Vector3d var2, float var3, float var4, float var5);
    }

    public static interface RandomFunction {
        public static final RandomFunction UNIFORM = Random::nextFloat;
        public static final RandomFunction GAUSSIAN = rand -> (float)rand.nextGaussian();

        public float getRandom(Random var1);
    }

    public static interface SpreadFunction {
        public static final SpreadFunction LINEAR_ASCENT = progress -> progress;
        public static final SpreadFunction LINEAR_ASCENT_DESCENT = progress -> (progress - Math.max(0.0f, 2.0f * progress - 1.0f)) / 0.5f;
        public static final SpreadFunction SINE = progress -> MathHelper.func_76126_a((float)((float)(Math.PI * (double)progress)));

        public float getMaxSpread(float var1);
    }

    public class BoltQuads {
        private final List<Vector3d> vecs = new ArrayList<Vector3d>();

        protected void addQuad(Vector3d ... quadVecs) {
            this.vecs.addAll(Arrays.asList(quadVecs));
        }

        public List<Vector3d> getVecs() {
            return this.vecs;
        }
    }

    protected static class BoltInstructions {
        private final Vector3d start;
        private final Vector3d perpendicularDist;
        private final QuadCache cache;
        private final float progress;
        private final boolean isBranch;

        private BoltInstructions(Vector3d start, float progress, Vector3d perpendicularDist, QuadCache cache, boolean isBranch) {
            this.start = start;
            this.perpendicularDist = perpendicularDist;
            this.progress = progress;
            this.cache = cache;
            this.isBranch = isBranch;
        }
    }

    private static class QuadCache {
        private final Vector3d prevEnd;
        private final Vector3d prevEndRight;
        private final Vector3d prevEndBack;

        private QuadCache(Vector3d prevEnd, Vector3d prevEndRight, Vector3d prevEndBack) {
            this.prevEnd = prevEnd;
            this.prevEndRight = prevEndRight;
            this.prevEndBack = prevEndBack;
        }
    }
}

