/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import com.github.alexthe666.iceandfire.client.model.util.EntityModelPartBuilder;
import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public abstract class ModelBipedBase<T extends LivingEntity>
extends AdvancedEntityModel<T>
implements ICustomStatueModel,
IHasHead,
IHasArm {
    private final List<AdvancedModelBox> advancedPartList = new ArrayList<AdvancedModelBox>();
    public HideableModelRenderer head;
    public HideableModelRenderer headware;
    public HideableModelRenderer body;
    public HideableModelRenderer armRight;
    public HideableModelRenderer armLeft;
    public HideableModelRenderer legRight;
    public HideableModelRenderer legLeft;
    public BipedModel.ArmPose leftArmPose;
    public BipedModel.ArmPose rightArmPose;
    public boolean isSneak;
    protected ModelAnimator animator;

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.getArmForSide(sideIn).func_228307_a_(matrixStackIn);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.armLeft : this.armRight;
    }

    protected HandSide getMainHand(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entityIn;
            HandSide Handside = LivingEntity2.func_184591_cq();
            return LivingEntity2.field_184622_au == Hand.MAIN_HAND ? Handside : Handside.func_188468_a();
        }
        return HandSide.RIGHT;
    }

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void rotateMinus(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    public void progressRotationInterp(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ, float max) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / max;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / max;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / max;
    }

    public void progresPositionInterp(AdvancedModelBox model, float progress, float x, float y, float z, float max) {
        model.field_78800_c += progress * x / max;
        model.field_78797_d += progress * y / max;
        model.field_78798_e += progress * z / max;
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    public void progressRotationPrev(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * rotX / 20.0f;
        model.field_78796_g += progress * rotY / 20.0f;
        model.field_78808_h += progress * rotZ / 20.0f;
    }

    public void progressPosition(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.field_78800_c += progress * (x - model.defaultPositionX) / 20.0f;
        model.field_78797_d += progress * (y - model.defaultPositionY) / 20.0f;
        model.field_78798_e += progress * (z - model.defaultPositionZ) / 20.0f;
    }

    public void progressPositionPrev(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.field_78800_c += progress * x / 20.0f;
        model.field_78797_d += progress * y / 20.0f;
        model.field_78798_e += progress * z / 20.0f;
    }

    public void setRotateAngle(AdvancedModelBox modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void accept(ModelRenderer p_accept_1_) {
        if (p_accept_1_ instanceof AdvancedModelBox) {
            this.advancedPartList.add((AdvancedModelBox)p_accept_1_);
        }
    }

    public void updateDefaultPose() {
        this.advancedPartList.forEach(modelRenderer -> modelRenderer.updateDefaultPose());
    }

    public void resetToDefaultPose() {
        this.advancedPartList.forEach(modelRenderer -> modelRenderer.resetToDefaultPose());
    }

    public void setModelAttributes(ModelBipedBase<T> modelIn) {
        super.func_217111_a(modelIn);
        modelIn.animator = this.animator;
        modelIn.leftArmPose = this.leftArmPose;
        modelIn.rightArmPose = this.rightArmPose;
        modelIn.isSneak = this.isSneak;
        modelIn.head.func_217177_a((ModelRenderer)this.head);
        modelIn.headware.func_217177_a((ModelRenderer)this.headware);
        modelIn.body.func_217177_a((ModelRenderer)this.body);
        modelIn.armRight.func_217177_a((ModelRenderer)this.armRight);
        modelIn.armLeft.func_217177_a((ModelRenderer)this.armLeft);
        modelIn.legRight.func_217177_a((ModelRenderer)this.legRight);
        modelIn.legLeft.func_217177_a((ModelRenderer)this.legLeft);
    }

    public void setModelAttributes(BipedModel<T> modelIn) {
        super.func_217111_a(modelIn);
        modelIn.field_187075_l = this.leftArmPose;
        modelIn.field_187076_m = this.rightArmPose;
        modelIn.field_228270_o_ = this.isSneak;
        modelIn.field_78116_c.func_217177_a((ModelRenderer)this.head);
        modelIn.field_178720_f.func_217177_a((ModelRenderer)this.headware);
        modelIn.field_78115_e.func_217177_a((ModelRenderer)this.body);
        modelIn.field_178723_h.func_217177_a((ModelRenderer)this.armRight);
        modelIn.field_178724_i.func_217177_a((ModelRenderer)this.armLeft);
        modelIn.field_178721_j.func_217177_a((ModelRenderer)this.legRight);
        modelIn.field_178722_k.func_217177_a((ModelRenderer)this.legLeft);
    }

    public void setVisible(boolean visible) {
        this.head.invisible = !visible;
        this.headware.invisible = !visible;
        this.body.invisible = !visible;
        this.armRight.invisible = !visible;
        this.armLeft.invisible = !visible;
        this.legRight.invisible = !visible;
        this.legLeft.invisible = !visible;
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        float f = 1.0f;
        this.armRight.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.armLeft.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.legRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.legLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.legRight.field_78796_g = 0.0f;
        this.legLeft.field_78796_g = 0.0f;
        this.legRight.field_78808_h = 0.0f;
        this.legLeft.field_78808_h = 0.0f;
        if (entityIn.func_184218_aH()) {
            this.armRight.field_78795_f += -0.62831855f;
            this.armLeft.field_78795_f += -0.62831855f;
            this.legRight.field_78795_f = -1.4137167f;
            this.legRight.field_78796_g = 0.31415927f;
            this.legRight.field_78808_h = 0.07853982f;
            this.legLeft.field_78795_f = -1.4137167f;
            this.legLeft.field_78796_g = -0.31415927f;
            this.legLeft.field_78808_h = -0.07853982f;
        }
        if (this.field_217112_c > 0.0f) {
            HandSide handSide = this.getMainHand((Entity)entityIn);
            ModelRenderer modelrenderer = this.getArmForSide(handSide);
            float f1 = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handSide == HandSide.LEFT) {
                this.body.field_78796_g *= -1.0f;
            }
            this.armRight.field_78798_e = MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.armRight.field_78800_c = -MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.armLeft.field_78798_e = -MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.armLeft.field_78800_c = MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.armRight.field_78796_g += this.body.field_78796_g;
            this.armLeft.field_78796_g += this.body.field_78796_g;
            this.armLeft.field_78795_f += this.body.field_78795_f;
            f1 = 1.0f - this.field_217112_c;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
            modelrenderer.field_78796_g += this.body.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.body.field_78795_f = 0.5f;
            this.armRight.field_78795_f += 0.4f;
            this.armLeft.field_78795_f += 0.4f;
            this.legRight.field_78798_e = 4.0f;
            this.legLeft.field_78798_e = 4.0f;
            this.legRight.field_78797_d = 9.0f;
            this.legLeft.field_78797_d = 9.0f;
            this.head.field_78797_d = 1.0f;
        } else {
            this.body.field_78795_f = 0.0f;
            this.legRight.field_78798_e = 0.1f;
            this.legLeft.field_78798_e = 0.1f;
            this.legRight.field_78797_d = 12.0f;
            this.legLeft.field_78797_d = 12.0f;
            this.head.field_78797_d = 0.0f;
        }
        this.armRight.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armRight.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.armLeft.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)((Object)this.body));
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return EntityModelPartBuilder.getAllPartsFromClass(this.getClass(), this.getClass().getName());
    }

    @Override
    public void renderStatue(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, Entity living) {
        this.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    abstract void animate(T var1, float var2, float var3, float var4, float var5, float var6, float var7);
}

