/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.selection;

import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.Color;
import com.github.franckyi.guapi.api.mvc.Model;
import java.util.function.Consumer;

public class ColorSelectionScreenModel
implements Model {
    private final Target target;
    private final Consumer<String> action;
    private final StringProperty hexValueProperty = StringProperty.create();
    private final DoubleProperty redValueProperty = DoubleProperty.create();
    private final DoubleProperty greenValueProperty = DoubleProperty.create();
    private final DoubleProperty blueValueProperty = DoubleProperty.create();

    public ColorSelectionScreenModel(Target target, Consumer<String> action, int color) {
        if (color == Integer.MIN_VALUE) {
            color = Color.fromRGB(1.0, 1.0, 1.0);
        }
        this.target = target;
        this.action = action;
        this.setRedValue(Color.getRed(color));
        this.setGreenValue(Color.getGreen(color));
        this.setBlueValue(Color.getBlue(color));
    }

    public void apply() {
        this.action.accept(this.getHexValue());
    }

    public String getHexValue() {
        return (String)this.hexValueProperty().getValue();
    }

    public StringProperty hexValueProperty() {
        return this.hexValueProperty;
    }

    public void setHexValue(String value) {
        this.hexValueProperty().setValue(value);
    }

    public double getRedValue() {
        return this.redValueProperty().getValue();
    }

    public DoubleProperty redValueProperty() {
        return this.redValueProperty;
    }

    public void setRedValue(double value) {
        this.redValueProperty().setValue(value);
    }

    public double getGreenValue() {
        return this.greenValueProperty().getValue();
    }

    public DoubleProperty greenValueProperty() {
        return this.greenValueProperty;
    }

    public void setGreenValue(double value) {
        this.greenValueProperty().setValue(value);
    }

    public double getBlueValue() {
        return this.blueValueProperty().getValue();
    }

    public DoubleProperty blueValueProperty() {
        return this.blueValueProperty;
    }

    public void setBlueValue(double value) {
        this.blueValueProperty().setValue(value);
    }

    public Target getTarget() {
        return this.target;
    }

    public static enum Target {
        TEXT,
        POTION,
        LEATHER_ARMOR;

    }
}

