/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.ibeeditor.client.ClientCache;
import com.github.franckyi.ibeeditor.client.screen.model.category.CategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.SelectionEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_5250;

public class PotionSelectionEntryModel
extends SelectionEntryModel {
    private int defaultCustomColor;
    private final IntegerProperty customColorProperty;
    private final Consumer<Integer> customColorAction;

    public PotionSelectionEntryModel(CategoryModel category, class_5250 label, String potionName, int customColor, Consumer<String> action, Consumer<Integer> customColorAction) {
        super(category, label, potionName, action);
        this.defaultCustomColor = customColor;
        this.customColorProperty = IntegerProperty.create(customColor);
        this.customColorAction = customColorAction;
    }

    @Override
    public void apply() {
        super.apply();
        this.customColorAction.accept(this.getCustomColor());
        this.defaultCustomColor = this.getCustomColor();
    }

    public int getCustomColor() {
        return this.customColorProperty().getValue();
    }

    public IntegerProperty customColorProperty() {
        return this.customColorProperty;
    }

    public void setCustomColor(int value) {
        this.customColorProperty().setValue(value);
    }

    public void resetCustomColor() {
        this.setCustomColor(this.defaultCustomColor);
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.SELECTION_POTION;
    }

    @Override
    public List<String> getSuggestions() {
        return ClientCache.getPotionSuggestions();
    }

    @Override
    public class_5250 getSelectionScreenTitle() {
        return ModTexts.POTION;
    }

    @Override
    public List<? extends ListSelectionElementModel> getSelectionItems() {
        return ClientCache.getPotionSelectionItems();
    }
}

