/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.PlatformUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Vault {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CURRENT_VERSION = 0;
    private static final Path VAULT_FILE_OLD = PlatformUtil.getConfigDir().resolve("ibeeditor-clipboard.dat");
    private static final Path VAULT_FILE = PlatformUtil.getConfigDir().resolve("ibeeditor-vault.dat");
    private static final class_2540 buffer = new class_2540(Unpooled.buffer());
    private static Vault INSTANCE;
    private int version = 0;
    private List<class_2487> items = new ArrayList<class_2487>();
    private List<class_2487> entities = new ArrayList<class_2487>();

    private Vault() {
    }

    public List<class_2487> getItems() {
        return this.items;
    }

    public List<class_2487> getEntities() {
        return this.entities;
    }

    public boolean saveItem(class_2487 tag) {
        if (this.items.contains(tag)) {
            return false;
        }
        this.items.add(tag);
        Vault.save();
        return true;
    }

    public boolean saveEntity(class_2487 tag) {
        if (this.entities.contains(tag)) {
            return false;
        }
        this.entities.add(tag);
        Vault.save();
        return true;
    }

    public void clear() {
        this.items.clear();
        this.entities.clear();
    }

    public static void load() {
        if (Files.exists(VAULT_FILE, new LinkOption[0])) {
            Vault.loadFromFile(VAULT_FILE);
        } else if (Files.exists(VAULT_FILE_OLD, new LinkOption[0])) {
            LOGGER.info("Detected old clipboard file, converting it to vault file");
            Vault.loadFromFile(VAULT_FILE_OLD);
            try {
                Files.delete(VAULT_FILE_OLD);
            }
            catch (IOException e) {
                LOGGER.error("Error while deleting the old clipboard file", (Throwable)e);
            }
            Vault.INSTANCE.version = 0;
            Vault.save();
        } else {
            LOGGER.info("Generating empty vault");
            INSTANCE = new Vault();
            Vault.save();
        }
    }

    private static void loadFromFile(Path path) {
        INSTANCE = new Vault();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            buffer.writeBytes(is, is.available());
            Vault.INSTANCE.version = buffer.readInt();
            IntStream.range(0, buffer.readInt()).forEach(i -> Vault.INSTANCE.items.add(Vault.safeReadNbt()));
            IntStream.range(0, buffer.readInt()).forEach(i -> Vault.INSTANCE.entities.add(Vault.safeReadNbt()));
            LOGGER.info("Vault loaded");
        }
        catch (IOException e) {
            LOGGER.error("Error while loading vault", (Throwable)e);
        }
    }

    private static class_2487 safeReadNbt() {
        int i = buffer.readerIndex();
        try {
            class_2487 result = buffer.method_10798();
            if (result == null || result.method_33133()) {
                throw new RuntimeException("Tag is empty, this must be an error");
            }
            return result;
        }
        catch (Exception e) {
            buffer.readerIndex(i);
            byte b0 = buffer.readByte();
            if (b0 != 10) {
                throw e;
            }
            buffer.readerIndex(i);
            try {
                return class_2507.method_10627((DataInput)new ByteBufInputStream((ByteBuf)buffer));
            }
            catch (IOException e0) {
                throw new RuntimeException(e0);
            }
        }
    }

    public static void save() {
        try (OutputStream os = Files.newOutputStream(VAULT_FILE, new OpenOption[0]);){
            buffer.writeInt(Vault.INSTANCE.version);
            buffer.writeInt(Vault.INSTANCE.items.size());
            Vault.INSTANCE.items.forEach(arg_0 -> ((class_2540)buffer).method_10794(arg_0));
            buffer.writeInt(Vault.INSTANCE.entities.size());
            Vault.INSTANCE.entities.forEach(arg_0 -> ((class_2540)buffer).method_10794(arg_0));
            buffer.readBytes(os, buffer.readableBytes());
            LOGGER.info("Vault saved");
        }
        catch (IOException e) {
            LOGGER.error("Error while saving vault", (Throwable)e);
        }
    }

    public static Vault getInstance() {
        return INSTANCE;
    }
}

