/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.guapi.api.util.DebugMode;
import com.github.franckyi.ibeeditor.PlatformUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CLIENT_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("ibeeditor-client.json");
    public static ClientConfiguration INSTANCE;
    private static boolean changed;
    private final int version;
    private int editorScale = -1;
    private String guapiTheme = "vanilla";
    private DebugMode guapiDebugMode = DebugMode.OFF;
    private int selectionScreenMaxItems = 100;

    private ClientConfiguration() {
        this.version = 0;
    }

    public int getEditorScale() {
        return this.editorScale;
    }

    public void setEditorScale(int editorScale) {
        if (this.editorScale != editorScale) {
            this.editorScale = editorScale;
            changed = true;
        }
    }

    public String getGuapiTheme() {
        return this.guapiTheme;
    }

    public void setGuapiTheme(String guapiTheme) {
        if (!this.guapiTheme.equals(guapiTheme)) {
            this.guapiTheme = guapiTheme;
            changed = true;
        }
    }

    public DebugMode getGuapiDebugMode() {
        return this.guapiDebugMode;
    }

    public void setGuapiDebugMode(DebugMode guapiDebugMode) {
        if (this.guapiDebugMode != guapiDebugMode) {
            this.guapiDebugMode = guapiDebugMode;
            changed = true;
        }
    }

    public int getSelectionScreenMaxItems() {
        return this.selectionScreenMaxItems;
    }

    public void setSelectionScreenMaxItems(int selectionScreenMaxItems) {
        if (this.selectionScreenMaxItems != selectionScreenMaxItems) {
            this.selectionScreenMaxItems = selectionScreenMaxItems;
            changed = true;
        }
    }

    public static void load() {
        if (Files.exists(CLIENT_CONFIG_FILE, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(CLIENT_CONFIG_FILE);){
                INSTANCE = (ClientConfiguration)GSON.fromJson((Reader)r, ClientConfiguration.class);
                LOGGER.info("Client configuration loaded");
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Error while loading client configuration", e);
                INSTANCE = new ClientConfiguration();
            }
        } else {
            LOGGER.info("Generating default client configuration");
            INSTANCE = new ClientConfiguration();
            changed = true;
            ClientConfiguration.save();
        }
    }

    public static void save() {
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(CLIENT_CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
                changed = false;
                LOGGER.info("Client configuration saved");
            }
            catch (IOException e) {
                LOGGER.error("Error while saving client configuration", (Throwable)e);
            }
        }
    }
}

