/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.node.ListNode;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.node.AbstractNode;

public abstract class AbstractListNode<E>
extends AbstractNode
implements ListNode<E> {
    private final BooleanProperty childrenFocusableProperty = BooleanProperty.create(false);
    private final ObjectProperty<E> focusedElementProperty = ObjectProperty.create();
    private final ObjectProperty<E> scrollToProperty = ObjectProperty.create();
    private final IntegerProperty itemHeightProperty = IntegerProperty.create();
    private final IntegerProperty fullWidthProperty = IntegerProperty.create();
    private final IntegerProperty fullHeightProperty = IntegerProperty.create();
    private final IntegerProperty baseXProperty = IntegerProperty.create();
    private final IntegerProperty baseYProperty = IntegerProperty.create();
    private final ObjectProperty<ListNode.Renderer<E>> rendererProperty = ObjectProperty.create();

    protected AbstractListNode(int itemHeight) {
        this.setItemHeight(itemHeight);
        this.itemHeightProperty().addListener(this::resetSkin);
        this.widthProperty().addListener(this::shouldComputeSize);
        this.heightProperty().addListener(this::shouldComputeSize);
        this.baseXProperty().bind(this.xProperty());
        this.baseYProperty().bind(this.yProperty());
        this.fullWidthProperty().bind(this.sceneProperty().mapToObservable(Scene::widthProperty, this.getWidth()));
        this.fullHeightProperty().bind(this.sceneProperty().mapToObservable(Scene::heightProperty, this.getHeight()));
    }

    public <E2 extends MouseEvent> void handleMouseEvent(ScreenEventType<E2> type, E2 event) {
        if (this.inBounds(event.getMouseX(), event.getMouseY())) {
            this.notifyEvent(type, event);
            if (event.getTarget() == null) {
                event.setTarget(this);
            }
        }
    }

    @Override
    public BooleanProperty childrenFocusableProperty() {
        return this.childrenFocusableProperty;
    }

    @Override
    public ObjectProperty<E> focusedElementProperty() {
        return this.focusedElementProperty;
    }

    @Override
    public ObjectProperty<E> scrollToProperty() {
        return this.scrollToProperty;
    }

    @Override
    public IntegerProperty itemHeightProperty() {
        return this.itemHeightProperty;
    }

    @Override
    public IntegerProperty fullWidthProperty() {
        return this.fullWidthProperty;
    }

    @Override
    public IntegerProperty fullHeightProperty() {
        return this.fullHeightProperty;
    }

    @Override
    public IntegerProperty baseXProperty() {
        return this.baseXProperty;
    }

    @Override
    public IntegerProperty baseYProperty() {
        return this.baseYProperty;
    }

    @Override
    public ObjectProperty<ListNode.Renderer<E>> rendererProperty() {
        return this.rendererProperty;
    }

    @Override
    public void shouldUpdateChildren() {
    }

    @Override
    public int getMaxChildrenWidth() {
        return this.getWidth() - this.getPadding().getHorizontal();
    }

    @Override
    public int getMaxChildrenHeight() {
        return this.getHeight() - this.getPadding().getVertical();
    }
}

