/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.util.Align;
import com.github.franckyi.guapi.base.node.AbstractBox;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractHBox
extends AbstractBox
implements HBox {
    private final BooleanProperty fillHeightProperty = BooleanProperty.create();

    protected AbstractHBox() {
        this(0);
    }

    protected AbstractHBox(int spacing) {
        this(spacing, Collections.emptyList());
    }

    protected AbstractHBox(Node ... children) {
        this(Arrays.asList(children));
    }

    protected AbstractHBox(Collection<? extends Node> children) {
        this(0, children);
    }

    protected AbstractHBox(int spacing, Node ... children) {
        this(spacing, Arrays.asList(children));
    }

    protected AbstractHBox(int spacing, Collection<? extends Node> children) {
        super(spacing, children);
        this.fillHeightProperty().addListener(this::shouldUpdateChildren);
    }

    @Override
    public BooleanProperty fillHeightProperty() {
        return this.fillHeightProperty;
    }

    @Override
    protected void updateChildren() {
        this.updateChildrenSize();
        int childWidth = this.getChildren().stream().mapToInt(Node::getWidth).sum() + this.getSpacing() * (this.getChildren().size() - 1);
        int x = Align.getAlignedX(this.getAlignment().getHorizontalAlign(), this, childWidth);
        for (Node child : this.getChildren()) {
            int y = Align.getAlignedY(this.getAlignment().getVerticalAlign(), this, child.getHeight());
            child.setX(x);
            child.setY(y);
            x += child.getWidth() + this.getSpacing();
        }
    }

    protected void updateChildrenSize() {
        int totalWeight = this.getChildren().stream().mapToInt(this::getWeight).sum();
        int childrenWidthWithoutWeight = this.getChildren().stream().filter(node -> this.getWeight((Node)node) == 0).mapToInt(Node::getWidth).sum();
        int remainingWidth = this.getWidth() - this.getPadding().getHorizontal() - this.getSpacing() * (this.getChildren().size() - 1) - childrenWidthWithoutWeight;
        int weightedWidth = totalWeight > 0 ? remainingWidth / totalWeight : 0;
        this.getChildren().forEach(node -> {
            if (this.getWeight((Node)node) > 0) {
                node.setParentPrefWidth(weightedWidth * this.getWeight((Node)node));
            } else {
                node.setParentPrefHeight(-1);
            }
            if (this.isFillHeight()) {
                node.setParentPrefHeight(this.getMaxChildrenHeight());
            } else {
                node.setParentPrefHeight(-1);
            }
        });
    }
}

