/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.util;

import java.util.function.Consumer;
import java.util.function.Predicate;

public final class Predicates {
    public static final Predicate<String> IS_BYTE = Predicates.tryPredicate(Byte::parseByte);
    public static final Predicate<String> IS_SHORT = Predicates.tryPredicate(Short::parseShort);
    public static final Predicate<String> IS_INT = Predicates.tryPredicate(Integer::parseInt);
    public static final Predicate<String> IS_LONG = Predicates.tryPredicate(Long::parseLong);
    public static final Predicate<String> IS_FLOAT = Predicates.tryPredicate(Float::parseFloat);
    public static final Predicate<String> IS_DOUBLE = Predicates.tryPredicate(Double::parseDouble);

    public static Predicate<String> range(int min, int max) {
        return s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= min && i < max;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    public static Predicate<String> tryPredicate(Consumer<String> action) {
        return s -> {
            try {
                action.accept((String)s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
    }
}

