/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.node;

import com.github.franckyi.guapi.api.event.KeyEvent;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.event.MouseDragEvent;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.event.MouseScrollEvent;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.event.ScreenEventListener;
import com.github.franckyi.guapi.api.event.TypeEvent;
import com.github.franckyi.guapi.api.util.ScreenEventType;

public interface ScreenEventHandler {
    public <E extends ScreenEvent> void handleEvent(ScreenEventType<E> var1, E var2);

    public <E extends ScreenEvent> void addListener(ScreenEventType<E> var1, ScreenEventListener<E> var2);

    public <E extends ScreenEvent> void removeListener(ScreenEventType<E> var1, ScreenEventListener<E> var2);

    default public <E extends ScreenEvent> ScreenEventListener<E> addListener(ScreenEventType<E> type, Runnable listener) {
        ScreenEventListener<ScreenEvent> realListener = e -> listener.run();
        this.addListener(type, realListener);
        return realListener;
    }

    default public void onMouseClick(ScreenEventListener<MouseButtonEvent> listener) {
        this.addListener(ScreenEventType.MOUSE_CLICKED, listener);
    }

    default public void onMouseRelease(ScreenEventListener<MouseButtonEvent> listener) {
        this.addListener(ScreenEventType.MOUSE_RELEASED, listener);
    }

    default public void onMouseDrag(ScreenEventListener<MouseDragEvent> listener) {
        this.addListener(ScreenEventType.MOUSE_DRAGGED, listener);
    }

    default public void onMouseScroll(ScreenEventListener<MouseScrollEvent> listener) {
        this.addListener(ScreenEventType.MOUSE_SCOLLED, listener);
    }

    default public void onKeyPress(ScreenEventListener<KeyEvent> listener) {
        this.addListener(ScreenEventType.KEY_PRESSED, listener);
    }

    default public void onKeyRelease(ScreenEventListener<KeyEvent> listener) {
        this.addListener(ScreenEventType.KEY_RELEASED, listener);
    }

    default public void onCharType(ScreenEventListener<TypeEvent> listener) {
        this.addListener(ScreenEventType.CHAR_TYPED, listener);
    }

    default public void onMouseMove(ScreenEventListener<MouseEvent> listener) {
        this.addListener(ScreenEventType.MOUSE_MOVED, listener);
    }

    default public void onAction(ScreenEventListener<MouseButtonEvent> listener) {
        this.addListener(ScreenEventType.ACTION, listener);
    }

    default public void onMouseClick(Runnable listener) {
        this.addListener(ScreenEventType.MOUSE_CLICKED, listener);
    }

    default public void onMouseRelease(Runnable listener) {
        this.addListener(ScreenEventType.MOUSE_RELEASED, listener);
    }

    default public void onMouseDrag(Runnable listener) {
        this.addListener(ScreenEventType.MOUSE_DRAGGED, listener);
    }

    default public void onMouseScroll(Runnable listener) {
        this.addListener(ScreenEventType.MOUSE_SCOLLED, listener);
    }

    default public void onKeyPress(Runnable listener) {
        this.addListener(ScreenEventType.KEY_PRESSED, listener);
    }

    default public void onKeyRelease(Runnable listener) {
        this.addListener(ScreenEventType.KEY_RELEASED, listener);
    }

    default public void onCharType(Runnable listener) {
        this.addListener(ScreenEventType.CHAR_TYPED, listener);
    }

    default public void onMouseMove(Runnable listener) {
        this.addListener(ScreenEventType.MOUSE_MOVED, listener);
    }

    default public void onAction(Runnable listener) {
        this.addListener(ScreenEventType.ACTION, listener);
    }
}

