/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.Property;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractProperty<T>
implements Property<T> {
    protected final List<ObservableValueChangeListener<? super T>> listeners = new CopyOnWriteArrayList<ObservableValueChangeListener<? super T>>();
    protected T value;
    protected final ObservableValueChangeListener<T> valueListener = (oldVal, newVal) -> this.doSet(newVal);
    protected ObservableValue<? extends T> boundValue;

    protected AbstractProperty() {
        this(null);
    }

    protected AbstractProperty(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        Property property;
        ObservableValue<? extends T> observableValue;
        if (!(!this.isBound() || (observableValue = this.boundValue) instanceof Property && (property = (Property)observableValue).isBound())) {
            throw new IllegalStateException("Property is bound to a value and cannot be set");
        }
        this.doSet(value);
    }

    private void doSet(T value) {
        if (!Objects.equals(this.value, value)) {
            Object old = this.value;
            this.value = value;
            this.listeners.forEach(listener -> listener.onValueChange(old, value));
        }
    }

    @Override
    public void addListener(ObservableValueChangeListener<? super T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableValueChangeListener<? super T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isBound() {
        return this.boundValue != null;
    }

    @Override
    public ObservableValue<? extends T> getBoundValue() {
        return this.boundValue;
    }

    @Override
    public void bind(ObservableValue<? extends T> value) {
        this.unbind();
        this.set(value.get());
        value.addListener(this.valueListener);
        this.boundValue = value;
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            this.boundValue.removeListener(this.valueListener);
            this.boundValue = null;
        }
    }

    @Override
    public void bindBidirectional(Property<T> other) {
        this.bind(other);
        other.bind(this);
    }

    @Override
    public void unbindBidirectional() {
        this.unbind();
        ObservableValue<? extends T> observableValue = this.boundValue;
        if (observableValue instanceof Property) {
            Property property = (Property)observableValue;
            property.unbind();
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static class SimpleDoubleProperty
    extends AbstractProperty<Double>
    implements DoubleProperty {
        public SimpleDoubleProperty() {
            this(0.0);
        }

        public SimpleDoubleProperty(double value) {
            super(value);
        }
    }

    public static class SimpleIntegerProperty
    extends AbstractProperty<Integer>
    implements IntegerProperty {
        public SimpleIntegerProperty() {
            this(0);
        }

        public SimpleIntegerProperty(int value) {
            super(value);
        }
    }

    public static class SimpleBooleanProperty
    extends AbstractProperty<Boolean>
    implements BooleanProperty {
        public SimpleBooleanProperty() {
            this(false);
        }

        public SimpleBooleanProperty(boolean value) {
            super(value);
        }
    }

    public static class SimpleStringProperty
    extends AbstractProperty<String>
    implements StringProperty {
        public SimpleStringProperty() {
        }

        public SimpleStringProperty(String value) {
            super(value);
        }
    }

    public static class SimpleObjectProperty<T>
    extends AbstractProperty<T>
    implements ObjectProperty<T> {
        public SimpleObjectProperty() {
        }

        public SimpleObjectProperty(T value) {
            super(value);
        }
    }
}

