/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableDoubleValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableStringValue;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;

public interface ObservableList<E>
extends List<E> {
    public static <E> ObservableList<E> create() {
        return DataBindings.getObservableListFactory().createObservableArrayList();
    }

    public static <E> ObservableList<E> create(Collection<? extends E> c) {
        return DataBindings.getObservableListFactory().createObservableArrayList(c);
    }

    public void addListener(ObservableListChangeListener<? super E> var1);

    public void removeListener(ObservableListChangeListener<? super E> var1);

    default public ObservableListChangeListener<? super E> addListener(Runnable listener) {
        ObservableListChangeListener realListener = event -> listener.run();
        this.addListener(realListener);
        return realListener;
    }

    default public boolean addAll(E ... elements) {
        return this.addAll(Arrays.asList(elements));
    }

    default public boolean addAll(int index, E ... elements) {
        return this.addAll(index, Arrays.asList(elements));
    }

    default public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    default public void setAll(E ... elements) {
        this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    default public void setAll(Collection<? extends E> c) {
        this.clear();
        this.addAll(c);
    }

    default public ObservableBooleanValue allMatch(Predicate<E> predicate, Function<E, ObservableValue<?>> triggerFunction) {
        return this.mapToBoolean(list -> list.stream().allMatch(predicate), triggerFunction);
    }

    default public ObservableBooleanValue anyMatch(Predicate<E> predicate, Function<E, ObservableValue<?>> triggerFunction) {
        return this.mapToBoolean(list -> list.stream().anyMatch(predicate), triggerFunction);
    }

    default public ObservableBooleanValue noneMatch(Predicate<E> predicate, Function<E, ObservableValue<?>> triggerFunction) {
        return this.mapToBoolean(list -> list.stream().noneMatch(predicate), triggerFunction);
    }

    default public ObservableIntegerValue sizeProperty() {
        return this.mapToInt(List::size, null);
    }

    default public <X> ObservableValue<X> map(Function<ObservableList<E>, X> mapper, Function<E, ObservableValue<?>> triggerFunction) {
        return DataBindings.getMappingFactory().createListMapping(this, mapper, triggerFunction);
    }

    default public ObservableStringValue mapToString(Function<ObservableList<E>, String> mapper, Function<E, ObservableValue<?>> triggerFunction) {
        return DataBindings.getMappingFactory().createListStringMapping(this, mapper, triggerFunction);
    }

    default public ObservableBooleanValue mapToBoolean(Predicate<ObservableList<E>> mapper, Function<E, ObservableValue<?>> triggerFunction) {
        return DataBindings.getMappingFactory().createListBooleanMapping(this, mapper, triggerFunction);
    }

    default public ObservableIntegerValue mapToInt(ToIntFunction<ObservableList<E>> mapper, Function<E, ObservableValue<?>> triggerFunction) {
        return DataBindings.getMappingFactory().createListIntegerMapping(this, mapper, triggerFunction);
    }

    default public ObservableDoubleValue mapToDouble(ToDoubleFunction<ObservableList<E>> mapper, Function<E, ObservableValue<?>> triggerFunction) {
        return DataBindings.getMappingFactory().createListDoubleMapping(this, mapper, triggerFunction);
    }
}

