/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;

public class TickableText {
    protected int ticks = 0;
    protected final String message;
    protected final int color;
    protected final boolean newline;
    protected final float tickRate;

    public TickableText(String message, int color, boolean newline, float tickRate) {
        this.message = message;
        this.color = color;
        this.newline = newline;
        this.tickRate = tickRate;
    }

    public TickableText(String message, int color) {
        this(message, color, true, 1.0f);
    }

    public void tick() {
        ++this.ticks;
    }

    public TickableText setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public void render(FontRenderer font, MatrixStack stack, int x, int y) {
        font.func_238421_b_(stack, this.message.substring(0, MathHelper.func_76123_f((float)Math.min((float)this.ticks * this.tickRate, (float)this.message.length()))), (float)x, (float)y, this.color);
    }

    public int getMaxUsefulTicks() {
        return MathHelper.func_76141_d((float)((float)this.message.length() / this.tickRate));
    }

    public void reset() {
        this.ticks = 0;
    }

    public boolean isDone() {
        return (float)this.ticks * this.tickRate >= (float)this.message.length();
    }

    public boolean causesNewLine() {
        return this.newline;
    }

    public int getWidth(FontRenderer font) {
        return font.func_78256_a(this.message);
    }

    public static void tickList(List<TickableText> texts) {
        for (int i = 0; i < texts.size(); ++i) {
            TickableText txt = texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
    }
}

