/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.jei.TickingDataModelWrapper;

public class SimChamberCategory
implements IRecipeCategory<TickingDataModelWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("hostilenetworks", "sim_chamber");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int ticks = 0;
    private long lastTickTime = 0L;
    static List<TickingDataModelWrapper> recipes;
    private ModelTier currentTier = ModelTier.BASIC;

    public SimChamberCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("hostilenetworks", "textures/jei/sim_chamber.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 116, 43);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Hostile.Blocks.SIM_CHAMBER));
        this.localizedName = Translator.translateToLocal((String)Hostile.Blocks.SIM_CHAMBER.func_149739_a());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<TickingDataModelWrapper> getRecipeClass() {
        return TickingDataModelWrapper.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(TickingDataModelWrapper recipe, IIngredients ing) {
        ing.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.model, recipe.input));
        ing.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.baseDrop, recipe.prediction));
    }

    public void setRecipe(IRecipeLayout layout, TickingDataModelWrapper recipe, IIngredients ing) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 3, 3);
        stacks.init(1, true, 27, 3);
        stacks.init(2, false, 95, 3);
        stacks.init(3, false, 65, 25);
        stacks.set(ing);
    }

    public void draw(TickingDataModelWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        long time = mc.field_71441_e.func_82737_E();
        int width = MathHelper.func_76123_f((float)(35.0f * ((float)(this.ticks % 40) + mc.func_193989_ak()) / 40.0f));
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)52, (int)9, (float)0.0f, (float)43.0f, (int)width, (int)6, (int)256, (int)256);
        if (time != this.lastTickTime) {
            if (++this.ticks % 30 == 0) {
                ModelTier next = this.currentTier.next();
                if (next == this.currentTier) {
                    next = ModelTier.BASIC;
                }
                for (TickingDataModelWrapper t : recipes) {
                    t.setTier(next);
                }
                this.currentTier = next;
            }
            this.lastTickTime = time;
        }
        ITextComponent comp = recipe.currentTier.getComponent();
        width = font.func_238414_a_((ITextProperties)comp);
        font.func_243248_b(matrixStack, recipe.currentTier.getComponent(), (float)(33 - width / 2), 30.0f, recipe.currentTier.color.func_211163_e().intValue());
        DecimalFormat fmt = new DecimalFormat("##.##%");
        String msg = fmt.format(recipe.currentTier.accuracy);
        width = font.func_78256_a(msg);
        font.func_238405_a_(matrixStack, msg, (float)(114 - width), 30.0f, 0xFFFFFF);
    }
}

