/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.util.Color;
import shadows.placebo.util.ClientUtil;

public class DeepLearnerItem
extends Item {
    public DeepLearnerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (!ctx.func_195991_k().field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)ctx.func_195999_j()), (INamedContainerProvider)new Provider(ctx.func_221531_n()), buf -> buf.writeBoolean(ctx.func_221531_n() == Hand.MAIN_HAND));
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World pLevel, PlayerEntity pPlayer, Hand pHand) {
        if (!pPlayer.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)pPlayer), (INamedContainerProvider)new Provider(pHand), buf -> buf.writeBoolean(pHand == Hand.MAIN_HAND));
        }
        return ActionResult.func_226249_b_((Object)pPlayer.func_184586_b(pHand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack pStack, World pLevel, List<ITextComponent> list, ITooltipFlag pFlag) {
        list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.deep_learner", new Object[]{Color.withColor("hostilenetworks.color_text.hud", 0xFFFFFF)}).func_240699_a_(TextFormatting.GRAY));
        if (ClientUtil.isHoldingShift()) {
            int i;
            ItemStackHandler inv = DeepLearnerItem.getItemHandler(pStack);
            boolean empty = true;
            for (i = 0; i < 4; ++i) {
                if (inv.getStackInSlot(i).func_190926_b()) continue;
                empty = false;
            }
            if (empty) {
                return;
            }
            list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.dl_contains").func_240699_a_(TextFormatting.GRAY));
            for (i = 0; i < 4; ++i) {
                CachedModel model;
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b() || (model = new CachedModel(stack, 0)).getModel() == null) continue;
                list.add((ITextComponent)new TranslationTextComponent("- %s %s", new Object[]{model.getTier().getComponent(), stack.func_77973_b().func_200295_i(stack)}).func_240699_a_(TextFormatting.GRAY));
            }
        } else {
            ItemStackHandler inv = DeepLearnerItem.getItemHandler(pStack);
            boolean empty = true;
            for (int i = 0; i < 4; ++i) {
                if (inv.getStackInSlot(i).func_190926_b()) continue;
                empty = false;
            }
            if (empty) {
                return;
            }
            list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.hold_shift", new Object[]{Color.withColor("hostilenetworks.color_text.shift", 0xFFFFFF)}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public static ItemStackHandler getItemHandler(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return new ItemStackHandler(4);
        }
        ItemStackHandler handler = new ItemStackHandler(4);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("learner_inv")) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l("learner_inv"));
        }
        return handler;
    }

    public static void saveItems(ItemStack stack, ItemStackHandler handler) {
        stack.func_196082_o().func_218657_a("learner_inv", (INBT)handler.serializeNBT());
    }

    protected class Provider
    implements INamedContainerProvider {
        private final Hand hand;

        protected Provider(Hand hand) {
            this.hand = hand;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
            return new DeepLearnerContainer(id, inv, this.hand);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("hostilenetworks.title.deep_learner");
        }
    }
}

