/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.gui.SimChamberContainer;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.tile.SimChamberTileEntity;
import shadows.hostilenetworks.util.TickableText;

public class SimChamberScreen
extends ContainerScreen<SimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 230;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/sim_chamber.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private List<TickableText> body = new ArrayList<TickableText>(7);
    private SimChamberTileEntity.FailureState lastFailState = SimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final ITextComponent ERROR = new StringTextComponent("ERROR").func_240699_a_(TextFormatting.OBFUSCATED);

    public SimChamberScreen(SimChamberContainer pMenu, PlayerInventory pPlayerInventory, ITextComponent pTitle) {
        super((Container)pMenu, pPlayerInventory, pTitle);
        this.field_146999_f = 232;
        this.field_147000_g = 230;
    }

    public void func_230430_a_(MatrixStack stack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, pMouseX, pMouseY, pPartialTicks);
        this.func_230459_a_(stack, pMouseX, pMouseY);
    }

    protected void func_230459_a_(MatrixStack pPoseStack, int pX, int pY) {
        if (this.func_195359_a(211, 48, 7, 87, pX, pY)) {
            ArrayList<TranslationTextComponent> txt = new ArrayList<TranslationTextComponent>(2);
            txt.add(new TranslationTextComponent("hostilenetworks.gui.energy", new Object[]{((SimChamberContainer)this.field_147002_h).getEnergyStored(), HostileConfig.simPowerCap}));
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c(), 0);
            if (cModel.getModel() != null) {
                txt.add(new TranslationTextComponent("hostilenetworks.gui.cost", new Object[]{cModel.getModel().getSimCost()}));
            }
            this.renderWrappedToolTip(pPoseStack, txt, pX, pY, this.field_230712_o_);
        } else if (this.func_195359_a(14, 48, 7, 87, pX, pY)) {
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c(), 0);
            if (cModel.getModel() != null) {
                ArrayList<Object> txt = new ArrayList<Object>(1);
                if (cModel.getTier() != cModel.getTier().next()) {
                    txt.add(new TranslationTextComponent("hostilenetworks.gui.data", new Object[]{cModel.getData() - cModel.getTier().data, cModel.getTier().next().data - cModel.getTier().data}));
                } else {
                    txt.add(new TranslationTextComponent("hostilenetworks.gui.max_data").func_240699_a_(TextFormatting.RED));
                }
                this.renderWrappedToolTip(pPoseStack, txt, pX, pY, this.field_230712_o_);
            }
        } else {
            super.func_230459_a_(pPoseStack, pX, pY);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int pX, int pY) {
        CachedModel cModel;
        int runtime = ((SimChamberContainer)this.field_147002_h).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, MathHelper.func_76123_f((float)(100.0f * (float)(300 - runtime) / 300.0f)));
            this.field_230712_o_.func_238405_a_(stack, rTime + "%", 184.0f, 123.0f, 6478079);
        }
        if ((cModel = new CachedModel(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c(), 0)).getModel() != null) {
            int xOff = 18;
            String msg = I18n.func_135052_a((String)"hostilenetworks.gui.target", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(stack, msg, (float)xOff, 9.0f, 0xFFFFFF);
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)cModel.getModel().getName(), (float)(xOff += this.field_230712_o_.func_78256_a(msg)), 9.0f, 65472);
            xOff = 18;
            msg = I18n.func_135052_a((String)"hostilenetworks.gui.tier", (Object[])new Object[0]);
            float f = xOff;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(stack, msg, f, (float)(9 + 9 + 3), 0xFFFFFF);
            xOff += this.field_230712_o_.func_78256_a(msg);
            msg = I18n.func_135052_a((String)("hostilenetworks.tier." + cModel.getTier().name), (Object[])new Object[0]);
            float f2 = xOff;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(stack, msg, f2, (float)(9 + 9 + 3), cModel.getTier().color.func_211163_e().intValue());
            xOff = 18;
            msg = I18n.func_135052_a((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]);
            float f3 = xOff;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(stack, msg, f3, (float)(9 + (9 + 3) * 2), 0xFFFFFF);
            xOff += this.field_230712_o_.func_78256_a(msg);
            DecimalFormat fmt = new DecimalFormat("##.##%");
            msg = fmt.format(cModel.getAccuracy());
            float f4 = xOff;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(stack, msg, f4, (float)(9 + (9 + 3) * 2), cModel.getTier().color.func_211163_e().intValue());
        }
        int left = 29;
        int top = 51;
        this.field_230712_o_.getClass();
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.field_230712_o_, stack, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 29;
                continue;
            }
            left += t.getWidth(this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack stack, float pPartialTicks, int pX, int pY) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 8), (int)top, (float)0.0f, (float)0.0f, (int)216, (int)141, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left - 14), (int)top, (float)0.0f, (float)141.0f, (int)18, (int)18, (int)256, (int)256);
        int energyHeight = 87 - MathHelper.func_76123_f((float)(87.0f * (float)((SimChamberContainer)this.field_147002_h).getEnergyStored() / (float)HostileConfig.simPowerCap));
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 211), (int)(top + 48), (float)18.0f, (float)141.0f, (int)7, (int)energyHeight, (int)256, (int)256);
        int dataHeight = 87;
        CachedModel cModel = new CachedModel(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c(), 0);
        if (cModel.getModel() != null) {
            ModelTier next;
            int data = cModel.getData();
            ModelTier tier = cModel.getTier();
            dataHeight = tier == (next = tier.next()) ? 0 : 87 - MathHelper.func_76123_f((float)(87.0f * (float)(data - tier.data) / (float)(next.data - tier.data)));
        }
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 14), (int)(top + 48), (float)18.0f, (float)141.0f, (int)7, (int)dataHeight, (int)256, (int)256);
        mc.func_110434_K().func_110577_a(PLAYER);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 28), (int)(top + 145), (float)0.0f, (float)0.0f, (int)176, (int)90, (int)256, (int)256);
    }

    public void func_231023_e_() {
        if (((SimChamberContainer)this.field_147002_h).getFailState() != SimChamberTileEntity.FailureState.NONE) {
            SimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((SimChamberContainer)this.field_147002_h).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                String[] msg = I18n.func_135052_a((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                if (this.lastFailState == SimChamberTileEntity.FailureState.INPUT) {
                    CachedModel cModel = new CachedModel(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c(), 0);
                    ITextComponent name = ERROR;
                    if (cModel.getModel() != null) {
                        name = cModel.getModel().getInput().func_200301_q();
                    }
                    msg = I18n.func_135052_a((String)this.lastFailState.getKey(), (Object[])new Object[]{name.getString()}).split("\\n");
                }
                for (String s : msg) {
                    this.body.add(new TickableText(s, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = 300 - ((SimChamberContainer)this.field_147002_h).getRuntime();
            float speed = 0.65f;
            this.body.clear();
            int iters = DataModelItem.getIters(((SimChamberContainer)this.field_147002_h).func_75139_a(0).func_75211_c());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.func_135052_a((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v1.0.5", TextFormatting.GOLD.func_211163_e(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String key = "hostilenetworks.color_text." + (((SimChamberContainer)this.field_147002_h).didPredictionSucceed() ? "success" : "failed");
                txt = new TickableText(I18n.func_135052_a((String)key, (Object[])new Object[0]), (((SimChamberContainer)this.field_147002_h).didPredictionSucceed() ? TextFormatting.GOLD : TextFormatting.RED).func_211163_e(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((SimChamberContainer)this.field_147002_h).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

