/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.gui.LootFabContainer;
import shadows.hostilenetworks.item.MobPredictionItem;

public class LootFabScreen
extends ContainerScreen<LootFabContainer> {
    private static final int WIDTH = 176;
    private static final int HEIGHT = 178;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/loot_fabricator.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private DataModel model = null;
    private int currentPage = 0;

    public LootFabScreen(LootFabContainer pMenu, PlayerInventory pPlayerInventory, ITextComponent pTitle) {
        super((Container)pMenu, pPlayerInventory, pTitle);
        this.field_147000_g = 178;
        this.field_146999_f = 176;
    }

    public void func_230430_a_(MatrixStack stack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.model = MobPredictionItem.getStoredModel(((LootFabContainer)this.field_147002_h).func_75139_a(0).func_75211_c());
        if (this.model != null) {
            ((Widget)this.field_230710_m_.get((int)0)).field_230694_p_ = this.currentPage > 0;
            ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = this.currentPage < this.model.getFabDrops().size() / 9;
        } else {
            ((Widget)this.field_230710_m_.get((int)0)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = false;
        }
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, pMouseX, pMouseY, pPartialTicks);
        this.func_230459_a_(stack, pMouseX, pMouseY);
    }

    public void func_231158_b_(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.func_231158_b_(pMinecraft, pWidth, pHeight);
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + 13, this.getGuiTop() + 68, 29, 12, 49, 83, 12, BASE, btn -> {
            if (this.model != null && this.currentPage > 0) {
                --this.currentPage;
            }
        }));
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + 46, this.getGuiTop() + 68, 29, 12, 78, 83, 12, BASE, btn -> {
            if (this.model != null && this.currentPage < this.model.getFabDrops().size() / 9) {
                ++this.currentPage;
            }
        }));
    }

    protected void func_230451_b_(MatrixStack pMatrixStack, int pX, int pY) {
    }

    protected void func_230459_a_(MatrixStack pPoseStack, int pX, int pY) {
        int selection = ((LootFabContainer)this.field_147002_h).getSelectedDrop(this.model);
        if (selection != -1 && this.func_195359_a(79, 5, 16, 16, pX, pY)) {
            this.renderWrappedToolTip(pPoseStack, Arrays.asList(new TranslationTextComponent("hostilenetworks.gui.clear")), pX, pY, this.field_230712_o_);
        } else if (this.func_195359_a(6, 10, 7, 53, pX, pY)) {
            ArrayList<TranslationTextComponent> txt = new ArrayList<TranslationTextComponent>(2);
            txt.add(new TranslationTextComponent("hostilenetworks.gui.energy", new Object[]{((LootFabContainer)this.field_147002_h).getEnergyStored(), HostileConfig.fabPowerCap}));
            txt.add(new TranslationTextComponent("hostilenetworks.gui.fab_cost", new Object[]{HostileConfig.fabPowerCost}));
            this.renderWrappedToolTip(pPoseStack, txt, pX, pY, this.field_230712_o_);
        }
        super.func_230459_a_(pPoseStack, pX, pY);
    }

    public boolean func_231044_a_(double pX, double pY, int pButton) {
        if (this.model != null) {
            List<ItemStack> drops = this.model.getFabDrops();
            int selection = ((LootFabContainer)this.field_147002_h).getSelectedDrop(this.model);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= drops.size() || !this.func_195359_a(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY) || selection == y * 3 + x) continue;
                    Minecraft.func_71410_x().field_71442_b.func_78756_a(((LootFabContainer)this.field_147002_h).field_75152_c, this.currentPage * 9 + y * 3 + x);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
            }
            if (selection != -1 && this.func_195359_a(79, 5, 16, 16, pX, pY)) {
                Minecraft.func_71410_x().field_71442_b.func_78756_a(((LootFabContainer)this.field_147002_h).field_75152_c, -1);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }
        return super.func_231044_a_(pX, pY, pButton);
    }

    protected void func_230450_a_(MatrixStack stack, float pPartialTicks, int pX, int pY) {
        int selection;
        int x;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)176, (int)83, (int)256, (int)256);
        int energyHeight = 53 - MathHelper.func_76123_f((float)(53.0f * (float)((LootFabContainer)this.field_147002_h).getEnergyStored() / (float)HostileConfig.fabPowerCap));
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 6), (int)(top + 10), (float)0.0f, (float)83.0f, (int)7, (int)energyHeight, (int)256, (int)256);
        int progHeight = MathHelper.func_76141_d((float)(35.0f * ((float)((LootFabContainer)this.field_147002_h).getRuntime() - pPartialTicks) / 60.0f));
        if (((LootFabContainer)this.field_147002_h).getRuntime() == 0) {
            progHeight = 35;
        }
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 84), (int)(top + 23), (float)7.0f, (float)83.0f, (int)6, (int)progHeight, (int)256, (int)256);
        if (this.model != null) {
            List<ItemStack> drops = this.model.getFabDrops();
            for (int y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.func_195359_a(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 16 + 19 * x), (int)(top + 8 + 19 * y), (float)13.0f, (float)83.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }
        if ((selection = ((LootFabContainer)this.field_147002_h).getSelectedDrop(this.model)) != -1 && selection / 9 == this.currentPage) {
            int selIdx = selection - this.currentPage * 9;
            AbstractGui.func_238463_a_((MatrixStack)stack, (int)(left + 16 + 19 * (selIdx % 3)), (int)(top + 8 + 19 * (selIdx / 3)), (float)31.0f, (float)83.0f, (int)18, (int)18, (int)256, (int)256);
        }
        mc.func_110434_K().func_110577_a(PLAYER);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)left, (int)(top + 88), (float)0.0f, (float)0.0f, (int)176, (int)90, (int)256, (int)256);
        if (selection != -1) {
            List<ItemStack> drops = this.model.getFabDrops();
            mc.func_175599_af().func_180450_b(drops.get(selection), left + 79, top + 5);
            mc.func_175599_af().func_175030_a(this.field_230712_o_, drops.get(selection), left + 79 - 1, top + 5 - 1);
        }
        if (this.model != null) {
            left += 17;
            top += 9;
            List<ItemStack> drops = this.model.getFabDrops();
            x = 0;
            int y = 0;
            for (int i = 0; i < Math.min(drops.size() - this.currentPage * 9, 9); ++i) {
                mc.func_175599_af().func_180450_b(drops.get(i + this.currentPage * 9), left + x * 19, top + y * 19);
                mc.func_175599_af().func_175030_a(this.field_230712_o_, drops.get(i + this.currentPage * 9), left + x * 19 - 1, top + y * 19 - 1);
                if (++x != 3) continue;
                ++y;
                x = 0;
            }
        }
    }
}

