/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.item.MobPredictionItem;

public class DataModel {
    protected ResourceLocation id;
    protected final EntityType<?> type;
    protected final TranslationTextComponent name;
    protected final float guiScale;
    protected final float guiXOff;
    protected final float guiYOff;
    protected final float guiZOff;
    protected final int simCost;
    protected final ItemStack input;
    protected final ItemStack baseDrop;
    protected final String triviaKey;
    protected final List<ItemStack> fabDrops;

    public DataModel(EntityType<?> type, TranslationTextComponent name, float guiScale, float guiXOff, float guiYOff, float guiZOff, int simCost, ItemStack input, ItemStack baseDrop, String triviaKey, List<ItemStack> fabDrops) {
        this.type = type;
        this.name = name;
        this.guiScale = guiScale;
        this.guiYOff = guiYOff;
        this.guiXOff = guiXOff;
        this.guiZOff = guiZOff;
        this.simCost = simCost;
        this.input = input;
        this.baseDrop = baseDrop;
        this.triviaKey = triviaKey;
        this.fabDrops = fabDrops;
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new UnsupportedOperationException("Attempted to change the already set ID of a DataModel!");
        }
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public TranslationTextComponent getName() {
        return this.name;
    }

    public String getTriviaKey() {
        return this.triviaKey;
    }

    public float getScale() {
        return this.guiScale;
    }

    public float getYOffset() {
        return this.guiYOff;
    }

    public float getXOffset() {
        return this.guiXOff;
    }

    public float getZOffset() {
        return this.guiZOff;
    }

    public int getSimCost() {
        return this.simCost;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getBaseDrop() {
        return this.baseDrop;
    }

    public List<ItemStack> getFabDrops() {
        return this.fabDrops;
    }

    public ItemStack getPredictionDrop() {
        ItemStack stk = new ItemStack((IItemProvider)Hostile.Items.PREDICTION);
        MobPredictionItem.setStoredModel(stk, this);
        return stk;
    }

    public int getNameColor() {
        return this.name.func_150256_b().func_240711_a_().func_240742_a_();
    }

    public boolean equals(Object obj) {
        return obj instanceof DataModel && ((DataModel)obj).id.equals((Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("DataModel[%s]", this.id);
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.id.toString());
        buf.func_180714_a(this.type.getRegistryName().toString());
        buf.func_180714_a(this.name.func_150268_i());
        buf.func_180714_a(this.name.func_150256_b().func_240711_a_().func_240747_b_());
        buf.writeFloat(this.guiScale);
        buf.writeFloat(this.guiXOff);
        buf.writeFloat(this.guiYOff);
        buf.writeFloat(this.guiZOff);
        buf.writeInt(this.simCost);
        buf.func_150788_a(this.input);
        buf.func_150788_a(this.baseDrop);
        buf.func_180714_a(this.triviaKey);
        buf.func_150787_b(this.fabDrops.size());
        for (ItemStack i : this.fabDrops) {
            buf.func_150788_a(i);
        }
    }

    public static DataModel read(PacketBuffer buf) {
        ResourceLocation id = new ResourceLocation(buf.func_218666_n());
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(buf.func_218666_n()));
        TranslationTextComponent name = new TranslationTextComponent(buf.func_218666_n());
        name.func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)buf.func_218666_n())));
        float guiScale = buf.readFloat();
        float guiXOff = buf.readFloat();
        float guiYOff = buf.readFloat();
        float guiZOff = buf.readFloat();
        int simCost = buf.readInt();
        ItemStack input = buf.func_150791_c();
        ItemStack baseDrop = buf.func_150791_c();
        String triviaKey = buf.func_218666_n();
        int dropSize = buf.func_150792_a();
        ArrayList<ItemStack> fabDrops = new ArrayList<ItemStack>(dropSize);
        for (int i = 0; i < dropSize; ++i) {
            fabDrops.add(buf.func_150791_c());
        }
        DataModel model = new DataModel(type, name, guiScale, guiXOff, guiYOff, guiZOff, simCost, input, baseDrop, triviaKey, fabDrops);
        model.setId(id);
        return model;
    }

    public static class Adapter
    implements JsonDeserializer<DataModel>,
    JsonSerializer<DataModel> {
        public static final Adapter INSTANCE = new Adapter();

        public JsonElement serialize(DataModel src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", src.type.getRegistryName().toString());
            obj.addProperty("name", src.name.func_150268_i());
            obj.addProperty("name_color", (Number)src.getNameColor());
            obj.addProperty("gui_scale", (Number)Float.valueOf(src.guiScale));
            obj.addProperty("gui_x_offset", (Number)Float.valueOf(src.guiXOff));
            obj.addProperty("gui_y_offset", (Number)Float.valueOf(src.guiYOff));
            obj.addProperty("gui_z_offset", (Number)Float.valueOf(src.guiZOff));
            obj.addProperty("sim_cost", (Number)src.simCost);
            obj.add("input", context.serialize((Object)src.input));
            obj.add("base_drop", context.serialize((Object)src.baseDrop));
            obj.addProperty("trivia", src.triviaKey);
            obj.add("fabricator_drops", context.serialize(src.fabDrops));
            return obj;
        }

        public DataModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            EntityType t = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(obj.get("type").getAsString()));
            if (t == null) {
                throw new JsonParseException("DataModel has invalid entity type " + obj.get("type").getAsString());
            }
            TranslationTextComponent name = new TranslationTextComponent(obj.get("name").getAsString());
            if (obj.has("name_color")) {
                name.func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)Integer.decode(obj.get("name_color").getAsString()))));
            } else {
                name.func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE));
            }
            float guiScale = obj.get("gui_scale").getAsFloat();
            float guiXOff = obj.get("gui_x_offset").getAsFloat();
            float guiYOff = obj.get("gui_y_offset").getAsFloat();
            float guiZOff = obj.get("gui_z_offset").getAsFloat();
            int simCost = obj.get("sim_cost").getAsInt();
            ItemStack input = (ItemStack)context.deserialize(obj.get("input"), ItemStack.class);
            ItemStack baseDrop = (ItemStack)context.deserialize(obj.get("base_drop"), ItemStack.class);
            String triviaKey = obj.has("trivia") ? obj.get("trivia").getAsString() : "hostilenetworks.trivia.nothing";
            List fabDrops = (List)context.deserialize(obj.get("fabricator_drops"), new TypeToken<List<ItemStack>>(){}.getType());
            return new DataModel(t, name, guiScale, guiXOff, guiYOff, guiZOff, simCost, input, baseDrop, triviaKey, fabDrops);
        }
    }
}

