/*
 * Decompiled with CFR 0.152.
 */
package net.backupcup.mixin;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import net.backupcup.hexed.Hexed;
import net.backupcup.hexed.packets.HexNetworkingConstants;
import net.backupcup.hexed.register.RegisterEnchantments;
import net.backupcup.hexed.register.RegisterSounds;
import net.backupcup.hexed.util.AggravateData;
import net.backupcup.hexed.util.AggravateInterface;
import net.backupcup.hexed.util.HexHelper;
import net.backupcup.hexed.util.OverclockData;
import net.backupcup.hexed.util.OverclockInterface;
import net.backupcup.hexed.util.PhasedInterface;
import net.backupcup.hexed.util.PredicateInterface;
import net.backupcup.hexed.util.ProvisionData;
import net.backupcup.hexed.util.ProvisionInterface;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PredicateInterface,
ProvisionInterface,
AggravateInterface,
OverclockInterface,
PhasedInterface {
    @Unique
    private float pullPredicate = 0.0f;
    @Unique
    private ProvisionData provisionData = new ProvisionData(false, 0, 1, 0);
    @Unique
    private AggravateData aggravateData = new AggravateData(class_1268.field_5808, 0, 0L);
    @Unique
    private OverclockData overclockData = new OverclockData(0, 0);
    @Unique
    private int phasedCharge = 0;

    @Shadow
    protected abstract void method_5623(double var1, boolean var3, class_2680 var4, class_2338 var5);

    @Shadow
    public abstract void method_17356(class_3414 var1, class_3419 var2, float var3, float var4);

    @Shadow
    public abstract void method_43496(class_2561 var1);

    @Override
    public void setPredicate(float value) {
        this.pullPredicate = value;
    }

    @Override
    public float getPredicate() {
        return this.pullPredicate;
    }

    @Override
    public void setProvisionData(ProvisionData data) {
        this.provisionData = data;
    }

    @Override
    public ProvisionData getProvisionData() {
        return this.provisionData;
    }

    @Override
    public void setAggravateData(AggravateData data) {
        this.aggravateData = data;
    }

    @Override
    public AggravateData getAggravateData() {
        return this.aggravateData;
    }

    @Override
    public void setOverclockData(OverclockData value) {
        this.overclockData = value;
    }

    @Override
    public OverclockData getOverclockData() {
        return this.overclockData;
    }

    @Override
    public void setPhasedData(int value) {
        this.phasedCharge = value;
    }

    @Override
    public int getPhasedData() {
        return this.phasedCharge;
    }

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V")})
    private void hexed$readCustomData(class_2487 nbt, CallbackInfo ci) {
        this.overclockData.setCooldown(nbt.method_10550("OverclockCooldown"));
        this.overclockData.setOverheat(nbt.method_10550("OverclockOverheat"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V")})
    private void hexed$writeCustomData(class_2487 nbt, CallbackInfo ci) {
        class_2487 overclockNbt = new class_2487();
        overclockNbt.method_10569("OverclockCooldown", this.overclockData.getCooldown());
        overclockNbt.method_10569("OverclockOverheat", this.overclockData.getOverheat());
        nbt.method_10566("OverclockData", (class_2520)overclockNbt);
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;emitGameEvent(Lnet/minecraft/world/event/GameEvent;)V", shift=At.Shift.AFTER)})
    private void hexed$resetClientDataOnDeath(class_1282 source, CallbackInfo ci) {
        class_2540 hexed$overclockBuf = new class_2540(Unpooled.buffer());
        hexed$overclockBuf.writeInt(0);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getOVERCLOCK_UPDATE_PACKET(), (class_2540)hexed$overclockBuf);
        class_2540 hexed$provisionBuf = new class_2540(Unpooled.buffer());
        hexed$provisionBuf.writeBoolean(false);
        hexed$provisionBuf.writeInt(0);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getPROVISION_UPDATE_PACKET(), (class_2540)hexed$provisionBuf);
        class_2540 hexed$aggravateBuf = new class_2540(Unpooled.buffer());
        hexed$aggravateBuf.writeInt(0);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getAGGRAVATE_UPDATE_PACKET(), (class_2540)hexed$aggravateBuf);
        class_2540 hexed$phasedBuf = new class_2540(Unpooled.buffer());
        hexed$phasedBuf.writeInt(0);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getPHASED_UPDATE_PACKET(), (class_2540)hexed$phasedBuf);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void hexed$PlayerTick(CallbackInfo ci) {
        if (this.provisionData.isUIActive()) {
            int indicatorLimit = 78;
            if (this.provisionData.getIndicatorPos() >= indicatorLimit) {
                this.provisionData.setUIActive(false);
                if (!HexHelper.INSTANCE.hasFullRobes((class_1309)((class_3222)this))) {
                    this.method_7357().method_7906(class_1802.field_8399, Hexed.INSTANCE.getConfig() != null ? Hexed.INSTANCE.getConfig().getProvisionHex().getItemCooldown() : 80);
                }
            } else {
                this.provisionData.setIndicatorPos(this.provisionData.getIndicatorPos() + this.provisionData.getReloadSpeed());
            }
            if (this.provisionData.getIndicatorPos() >= 10 && this.provisionData.getIndicatorPos() <= 16 && this.provisionData.getReloadsPlayed() < 1) {
                ((class_3222)this).method_17356(RegisterSounds.INSTANCE.getPROVISION_IN_RANGE(), class_3419.field_15248, 0.5f, 1.0f);
                this.provisionData.setReloadsPlayed(1);
            }
            if (this.provisionData.getIndicatorPos() >= 36 && this.provisionData.getIndicatorPos() <= 43 && this.provisionData.getReloadsPlayed() < 2) {
                ((class_3222)this).method_17356(RegisterSounds.INSTANCE.getPROVISION_IN_RANGE(), class_3419.field_15248, 0.5f, 1.0f);
                this.provisionData.setReloadsPlayed(2);
            }
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBoolean(this.provisionData.getIndicatorPos() <= indicatorLimit && this.provisionData.isUIActive());
            buf.writeInt(this.provisionData.getIndicatorPos());
            ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getPROVISION_UPDATE_PACKET(), (class_2540)buf);
            if (this.provisionData.getIndicatorPos() > indicatorLimit) {
                this.provisionData.setUIActive(false);
                this.provisionData.setIndicatorPos(0);
                this.provisionData.setReloadSpeed(1);
                this.provisionData.setReloadsPlayed(0);
                ((class_3222)this).method_17356(RegisterSounds.INSTANCE.getPROVISION_FAIL(), class_3419.field_15248, 1.0f, 1.0f);
            }
        }
        if (this.overclockData.getCooldown() > 0) {
            this.overclockData.setCooldown(this.overclockData.getCooldown() - 1);
        } else if (this.method_5770().method_8510() % 10L == 0L && this.overclockData.getOverheat() > 0) {
            this.overclockData.setOverheat(this.overclockData.getOverheat() - 1);
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(this.overclockData.getOverheat());
            ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getOVERCLOCK_UPDATE_PACKET(), (class_2540)buf);
        }
        if (HexHelper.INSTANCE.stackHasEnchantment(this.method_5998(this.aggravateData.getBowHand()), (class_1887)RegisterEnchantments.INSTANCE.getAGGRAVATE_HEX()) && this.pullPredicate >= 1.0f) {
            if (this.aggravateData.getChargeAmount() < 7) {
                this.aggravateData.setChargedTicks(this.aggravateData.getChargedTicks() + 1L);
            }
            if (this.aggravateData.getChargedTicks() >= (long)(Hexed.INSTANCE.getConfig() != null ? Hexed.INSTANCE.getConfig().getAggravateHex().getChargeTicks() : 10) && this.aggravateData.getChargeAmount() < 6) {
                this.aggravateData.setChargedTicks(0L);
                this.aggravateData.setChargeAmount(this.aggravateData.getChargeAmount() + 1);
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.aggravateData.getChargeAmount());
                ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getAGGRAVATE_UPDATE_PACKET(), (class_2540)buf);
                ((class_3222)this).method_17356(RegisterSounds.INSTANCE.getAGGRAVATE_TIER(), class_3419.field_15248, 1.0f, 1.0f + (float)this.aggravateData.getChargeAmount() / 6.0f);
            } else if (this.aggravateData.getChargedTicks() >= (long)(Hexed.INSTANCE.getConfig() != null ? Hexed.INSTANCE.getConfig().getAggravateHex().getChargeTicks() : 10) * 10L && this.aggravateData.getChargeAmount() == 6) {
                this.aggravateData.setChargedTicks(0L);
                this.aggravateData.setChargeAmount(7);
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.aggravateData.getChargeAmount());
                ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getAGGRAVATE_UPDATE_PACKET(), (class_2540)buf);
                ((class_3222)this).method_17356(RegisterSounds.INSTANCE.getACCURSED_ALTAR_TAINT(), class_3419.field_15248, 0.5f, 2.0f);
            }
        }
        if (!HexHelper.INSTANCE.stackHasEnchantment(this.method_5998(this.aggravateData.getBowHand()), (class_1887)RegisterEnchantments.INSTANCE.getAGGRAVATE_HEX()) && this.aggravateData.getChargeAmount() > 0) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(0);
            ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)HexNetworkingConstants.INSTANCE.getAGGRAVATE_UPDATE_PACKET(), (class_2540)buf);
        }
    }
}

