/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.util.Objects;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;

public class ConfigEntryInt
implements IConfigEntry {
    final ConfigFile cfg;
    public int min = Integer.MIN_VALUE;
    public int max = Integer.MAX_VALUE;
    String description;
    String name;
    Integer value;
    Integer initialValue;

    public ConfigEntryInt(ConfigFile cfg, Integer initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryInt setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryInt setMinValue(int min) {
        this.min = min;
        if (this.value != null) {
            this.value = Math.max(min, Math.min(this.max, this.value));
        }
        return this;
    }

    public ConfigEntryInt setMaxValue(int max) {
        this.max = max;
        if (this.value != null) {
            this.value = Math.max(this.min, Math.min(max, this.value));
        }
        return this;
    }

    public ConfigEntryInt setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryInt setValue(Integer value) {
        if (value != null) {
            value = Math.max(this.min, Math.min(this.max, value));
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return ConfigFile.SERIALIZER_INT;
    }
}

