/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip;

import org.zeith.hammerlib.tiles.tooltip.eNumberFormat;

public class ProgressBar {
    protected long maxValue = 100L;
    protected long value = 0L;
    public eNumberFormat numberFormat;
    public String prefix;
    public String suffix;
    public int backgroundColor;
    public int borderColor;
    public int filledMainColor;
    public int filledAlternateColor;

    public ProgressBar(long maxValue) {
        if (maxValue < 1L) {
            throw new IndexOutOfBoundsException("maxValue");
        }
        this.maxValue = maxValue;
    }

    public float getProgress() {
        return this.value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public ProgressBar setMaxValue(long maxValue) {
        if (maxValue < 1L) {
            throw new IndexOutOfBoundsException("maxValue");
        }
        this.maxValue = maxValue;
        return this;
    }

    public int getProgressPercent() {
        return (int)Math.round((double)this.value / (double)this.maxValue * 100.0);
    }

    public ProgressBar setProgress(long value) {
        if (value < 0L) {
            value = 0L;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        return this;
    }
}

