/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyTextComponent
implements IProperty<ITextComponent> {
    final DirectStorage<ITextComponent> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyTextComponent(DirectStorage<ITextComponent> value) {
        this.value = value;
    }

    public PropertyTextComponent() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<ITextComponent> getType() {
        return ITextComponent.class;
    }

    @Override
    public ITextComponent set(ITextComponent value) {
        ITextComponent pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(PacketBuffer buf) {
        ITextComponent value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.func_179256_a(value);
        }
    }

    @Override
    public void read(PacketBuffer buf) {
        this.value.set(buf.readBoolean() ? buf.func_179258_d() : null);
    }

    @Override
    public ITextComponent get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

