/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.lft;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.network.PacketBuffer;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.PlainHLMessage;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.hammerlib.net.lft.NetTransport;

public class PacketWrapperAcceptor
implements ITransportAcceptor {
    PlainHLMessage decoded;
    byte[] data;

    @Override
    public void read(InputStream readable, int length) {
        try {
            ByteBuf buf = Unpooled.buffer((int)length);
            buf.writeBytes(readable, length);
            this.data = new byte[length];
            buf.markReaderIndex();
            this.decoded = new PlainHLMessage(new PacketBuffer(buf));
            buf.resetReaderIndex();
            buf.readBytes(this.data);
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Override
    public void onTransmissionComplete(PacketContext ctx) {
        if (!this.decoded.isValid()) {
            HammerLib.LOG.error("Received bad packet on packet transport (WHAT IS THIS?!): " + new String(this.data));
        } else {
            switch (ctx.getSide()) {
                case CLIENT: {
                    this.decoded.unwrap().clientExecute(ctx);
                    break;
                }
                case SERVER: {
                    this.decoded.unwrap().serverExecute(ctx);
                    break;
                }
                default: {
                    HammerLib.LOG.error("WTF is this side " + ctx.getSide() + " ?!");
                }
            }
        }
        this.data = null;
        IPacket pkt = ctx.getReply();
        if (pkt != null) {
            ctx.withReply(NetTransport.wrap(pkt).createPacket());
        }
    }

    @Override
    public boolean executeOnMainThread() {
        return ITransportAcceptor.super.executeOnMainThread() || this.decoded.isValid() && this.decoded.unwrap().executeOnMainThread();
    }
}

