/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.proxy.HLConstants;

public class OreDictionaryAdapter {
    private static final Map<String, List<ResourceLocation>> MAPPING = new HashMap<String, List<ResourceLocation>>();
    private static final Function<String, List<ResourceLocation>> MAP_GEN = s -> new ArrayList();
    private static boolean hasInit;

    private static void addMapping(String key, ResourceLocation value) {
        MAPPING.computeIfAbsent(key, MAP_GEN).add(value);
    }

    public static void register(String key, String value) {
        OreDictionaryAdapter.register(key, new ResourceLocation(value.contains(":") ? value : "forge:" + value));
    }

    public static void register(String key, ITag.INamedTag<Item> tag) {
        if (tag != null) {
            OreDictionaryAdapter.register(key, tag.func_230234_a_());
        }
    }

    public static void register(String key, ResourceLocation value) {
        OreDictionaryAdapter.addMapping(key, value);
    }

    @Nonnull
    public static List<ResourceLocation> get(String od) {
        if (!MAPPING.containsKey(od)) {
            if (od.startsWith("ingot")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "ingots/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("ore")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "ores/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("gem")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "gems/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("block")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "storage_blocks/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("dust")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "dusts/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("gear")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "gears/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("plate")) {
                OreDictionaryAdapter.addMapping(od, new ResourceLocation("forge", "plates/" + od.substring(5).toLowerCase()));
            }
            if (MAPPING.containsKey(od)) {
                HLConstants.LOG.debug("Generated mapping for " + od + ": " + MAPPING.get(od));
            }
        }
        return MAPPING.computeIfAbsent(od, MAP_GEN);
    }

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionaryAdapter.register("logWood", (ITag.INamedTag<Item>)ItemTags.field_200038_h);
            OreDictionaryAdapter.register("plankWood", (ITag.INamedTag<Item>)ItemTags.field_199905_b);
            OreDictionaryAdapter.register("slabWood", (ITag.INamedTag<Item>)ItemTags.field_202899_i);
            OreDictionaryAdapter.register("stairWood", (ITag.INamedTag<Item>)ItemTags.field_202898_h);
            OreDictionaryAdapter.register("fenceWood", (ITag.INamedTag<Item>)Tags.Items.FENCES_WOODEN);
            OreDictionaryAdapter.register("fenceGateWood", (ITag.INamedTag<Item>)Tags.Items.FENCE_GATES_WOODEN);
            OreDictionaryAdapter.register("doorWood", (ITag.INamedTag<Item>)ItemTags.field_200154_g);
            OreDictionaryAdapter.register("stickWood", (ITag.INamedTag<Item>)Tags.Items.RODS_WOODEN);
            OreDictionaryAdapter.register("treeSapling", (ITag.INamedTag<Item>)ItemTags.field_200037_g);
            OreDictionaryAdapter.register("treeLeaves", (ITag.INamedTag<Item>)ItemTags.field_206963_E);
            OreDictionaryAdapter.register("oreGold", (ITag.INamedTag<Item>)Tags.Items.ORES_GOLD);
            OreDictionaryAdapter.register("oreIron", (ITag.INamedTag<Item>)Tags.Items.ORES_IRON);
            OreDictionaryAdapter.register("oreLapis", (ITag.INamedTag<Item>)Tags.Items.ORES_LAPIS);
            OreDictionaryAdapter.register("oreDiamond", (ITag.INamedTag<Item>)Tags.Items.ORES_DIAMOND);
            OreDictionaryAdapter.register("oreRedstone", (ITag.INamedTag<Item>)Tags.Items.ORES_REDSTONE);
            OreDictionaryAdapter.register("oreEmerald", (ITag.INamedTag<Item>)Tags.Items.ORES_EMERALD);
            OreDictionaryAdapter.register("oreQuartz", (ITag.INamedTag<Item>)Tags.Items.ORES_QUARTZ);
            OreDictionaryAdapter.register("oreCoal", (ITag.INamedTag<Item>)Tags.Items.ORES_COAL);
            OreDictionaryAdapter.register("ingotIron", (ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON);
            OreDictionaryAdapter.register("ingotGold", (ITag.INamedTag<Item>)Tags.Items.INGOTS_GOLD);
            OreDictionaryAdapter.register("ingotBrick", (ITag.INamedTag<Item>)Tags.Items.INGOTS_BRICK);
            OreDictionaryAdapter.register("ingotBrickNether", (ITag.INamedTag<Item>)Tags.Items.INGOTS_NETHER_BRICK);
            OreDictionaryAdapter.register("nuggetIron", (ITag.INamedTag<Item>)Tags.Items.NUGGETS_IRON);
            OreDictionaryAdapter.register("nuggetIron", (ITag.INamedTag<Item>)Tags.Items.NUGGETS_GOLD);
            OreDictionaryAdapter.register("gemDiamond", (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND);
            OreDictionaryAdapter.register("gemEmerald", (ITag.INamedTag<Item>)Tags.Items.GEMS_EMERALD);
            OreDictionaryAdapter.register("gemQuartz", (ITag.INamedTag<Item>)Tags.Items.GEMS_QUARTZ);
            OreDictionaryAdapter.register("gemPrismarine", (ITag.INamedTag<Item>)Tags.Items.GEMS_PRISMARINE);
            OreDictionaryAdapter.register("gemLapis", (ITag.INamedTag<Item>)Tags.Items.GEMS_LAPIS);
            OreDictionaryAdapter.register("enderpearl", (ITag.INamedTag<Item>)Tags.Items.ENDER_PEARLS);
            OreDictionaryAdapter.register("dustPrismarine", (ITag.INamedTag<Item>)Tags.Items.DUSTS_PRISMARINE);
            OreDictionaryAdapter.register("dustRedstone", (ITag.INamedTag<Item>)Tags.Items.DUSTS_REDSTONE);
            OreDictionaryAdapter.register("dustGlowstone", (ITag.INamedTag<Item>)Tags.Items.DUSTS_GLOWSTONE);
            OreDictionaryAdapter.register("blockGold", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            OreDictionaryAdapter.register("blockIron", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            OreDictionaryAdapter.register("blockLapis", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            OreDictionaryAdapter.register("blockDiamond", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            OreDictionaryAdapter.register("blockRedstone", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            OreDictionaryAdapter.register("blockEmerald", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            OreDictionaryAdapter.register("blockQuartz", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ);
            OreDictionaryAdapter.register("blockCoal", (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_COAL);
            OreDictionaryAdapter.register("blockGlass", (ITag.INamedTag<Item>)Tags.Items.GLASS);
            OreDictionaryAdapter.register("dye", (ITag.INamedTag<Item>)Tags.Items.DYES);
            OreDictionaryAdapter.register("stone", (ITag.INamedTag<Item>)Tags.Items.STONE);
            OreDictionaryAdapter.register("obsidian", (ITag.INamedTag<Item>)Tags.Items.OBSIDIAN);
            OreDictionaryAdapter.register("sand", (ITag.INamedTag<Item>)ItemTags.field_203440_u);
            OreDictionaryAdapter.register("brickStone", (ITag.INamedTag<Item>)ItemTags.field_200033_c);
            OreDictionaryAdapter.register("chest", (ITag.INamedTag<Item>)Tags.Items.CHESTS);
            OreDictionaryAdapter.register("chestWood", (ITag.INamedTag<Item>)Tags.Items.CHESTS_WOODEN);
            OreDictionaryAdapter.register("chestTrapped", (ITag.INamedTag<Item>)Tags.Items.CHESTS_TRAPPED);
            OreDictionaryAdapter.register("chestEnder", (ITag.INamedTag<Item>)Tags.Items.CHESTS_ENDER);
            OreDictionaryAdapter.register("piston", TagsHL.Items.PISTONS);
        }
        hasInit = true;
    }

    static {
        OreDictionaryAdapter.initVanillaEntries();
    }
}

