/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.fabric.GTUtilImpl;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class GTUtil {
    @Nullable
    public static class_2350 determineWrenchingSide(class_2350 facing, float x, float y, float z) {
        class_2350 opposite = facing.method_10153();
        switch (facing) {
            case field_11033: 
            case field_11036: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11039;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11034;
                }
                if ((double)z < 0.25) {
                    return class_2350.field_11043;
                }
                if ((double)z > 0.75) {
                    return class_2350.field_11035;
                }
                return facing;
            }
            case field_11043: 
            case field_11035: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11039;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11034;
                }
                if ((double)y < 0.25) {
                    return class_2350.field_11033;
                }
                if ((double)y > 0.75) {
                    return class_2350.field_11036;
                }
                return facing;
            }
            case field_11039: 
            case field_11034: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11043;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return class_2350.field_11035;
                }
                if ((double)y < 0.25) {
                    return class_2350.field_11033;
                }
                if ((double)y > 0.75) {
                    return class_2350.field_11036;
                }
                return facing;
            }
        }
        return null;
    }

    public static float getExplosionPower(long voltage) {
        return GTUtil.getTierByVoltage(voltage) + 1;
    }

    public static int nearestLesserOrEqual(@Nonnull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] <= value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static int nearestLesser(@Nonnull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] < value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static byte getTierByVoltage(long voltage) {
        return (byte)Math.min(14, GTUtil.nearestLesser(GTValues.V, voltage) + 1);
    }

    public static byte getFloorTierByVoltage(long voltage) {
        return (byte)Math.max(0, GTUtil.nearestLesserOrEqual(GTValues.V, voltage));
    }

    public static class_1799 copy(class_1799 ... stacks) {
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            return stack.method_7972();
        }
        return class_1799.field_8037;
    }

    public static class_1799 copyAmount(int amount, class_1799 ... stacks) {
        class_1799 stack = GTUtil.copy(stacks);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.method_7939(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        FluidStack stack = fluidStack.copy();
        stack.setAmount((long)amount);
        return stack;
    }

    public static <M> M selectItemInList(int index, M replacement, List<M> list, Class<M> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (maybeResult != null) {
            return maybeResult;
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static <T> int getRandomItem(class_5819 random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.method_43048(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public static <T> int getRandomItem(List<? extends Map.Entry<Integer, T>> randomList, int size) {
        return GTUtil.getRandomItem(GTValues.RNG, randomList, size);
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static boolean isShiftDown() {
        if (LDLib.isClient()) {
            long id = class_310.method_1551().method_22683().method_4490();
            return class_3675.method_15987((long)id, (int)340) || class_3675.method_15987((long)id, (int)340);
        }
        return false;
    }

    public static boolean isCtrlDown() {
        if (LDLib.isClient()) {
            long id = class_310.method_1551().method_22683().method_4490();
            return class_3675.method_15987((long)id, (int)341) || class_3675.method_15987((long)id, (int)345);
        }
        return false;
    }

    public static boolean isAltDown() {
        if (LDLib.isClient()) {
            long id = class_310.method_1551().method_22683().method_4490();
            return class_3675.method_15987((long)id, (int)342) || class_3675.method_15987((long)id, (int)346);
        }
        return false;
    }

    public static boolean isFluidStackAmountDivisible(FluidStack fluidStack, int divisor) {
        return fluidStack.getAmount() % (long)divisor == 0L && fluidStack.getAmount() % (long)divisor != fluidStack.getAmount() && fluidStack.getAmount() / (long)divisor != 0L;
    }

    public static boolean isItemStackCountDivisible(class_1799 itemStack, int divisor) {
        return itemStack.method_7947() % divisor == 0 && itemStack.method_7947() % divisor != itemStack.method_7947() && itemStack.method_7947() / divisor != 0;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getItemBurnTime(class_1792 item) {
        return GTUtilImpl.getItemBurnTime(item);
    }

    public static class_1767 determineDyeColor(int rgbColor) {
        float[] c = GradientUtil.getRGB(rgbColor);
        HashMap<Double, class_1767> distances = new HashMap<Double, class_1767>();
        for (class_1767 dyeColor : class_1767.values()) {
            float[] c2 = GradientUtil.getRGB(dyeColor.method_16357());
            double distance = (c[0] - c2[0]) * (c[0] - c2[0]) + (c[1] - c2[1]) * (c[1] - c2[1]) + (c[2] - c2[2]) * (c[2] - c2[2]);
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (class_1767)distances.get(min);
    }

    public static int convertRGBtoARGB(int colorValue) {
        return GTUtil.convertRGBtoARGB(colorValue, 255);
    }

    public static int convertRGBtoARGB(int colorValue, int opacity) {
        if ((colorValue >> 24 & 0xFF) != 0) {
            return colorValue;
        }
        return opacity << 24 | colorValue;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static long getPumpBiomeModifier(class_6880<class_1959> biome) {
        return GTUtilImpl.getPumpBiomeModifier(biome);
    }

    @Nullable
    public static class_3611 getMoltenFluid(@Nonnull Material material) {
        if (material.hasProperty(PropertyKey.ALLOY_BLAST)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.MOLTEN);
        }
        if (!TagPrefix.ingotHot.doGenerateItem(material) && material.hasProperty(PropertyKey.FLUID)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.LIQUID);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidFromContainer(Object ingredient) {
        class_1799 itemStack;
        IFluidTransfer fluidHandler;
        if (ingredient instanceof FluidStack) {
            return (FluidStack)ingredient;
        }
        if (ingredient instanceof class_1799 && (fluidHandler = FluidTransferHelper.getFluidTransfer((class_1799)(itemStack = (class_1799)ingredient))) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    public static boolean canSeeSunClearly(class_1937 world, class_2338 blockPos) {
        if (!world.method_8311(blockPos.method_10084())) {
            return false;
        }
        class_1959 biome = (class_1959)world.method_23753(blockPos.method_10084()).comp_349();
        if (world.method_8419() && (biome.method_39927(blockPos.method_10084()) || biome.method_33599(blockPos.method_10084()))) {
            return false;
        }
        if (world.method_23753(blockPos.method_10084()).method_40220(class_6908.field_37394)) {
            return false;
        }
        return world.method_8530();
    }
}

