/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.base.CaseFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FormattingUtil {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ROOT);
    private static final DecimalFormat TWO_PLACES_FORMAT = new DecimalFormat("#.##");
    private static final int SMALL_DOWN_NUMBER_BASE = 8320;
    private static final int SMALL_UP_NUMBER_BASE = 8304;
    private static final int SMALL_UP_NUMBER_ONE = 185;
    private static final int SMALL_UP_NUMBER_TWO = 178;
    private static final int SMALL_UP_NUMBER_THREE = 179;
    private static final int NUMBER_BASE = 48;

    public static String toSmallUpNumbers(String string) {
        return FormattingUtil.checkNumbers(string, 8304, true);
    }

    public static String toSmallDownNumbers(String string) {
        return FormattingUtil.checkNumbers(string, 8320, false);
    }

    @NotNull
    private static String checkNumbers(String string, int smallUpNumberBase, boolean isUp) {
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            int relativeIndex = charArray[i] - 48;
            if (relativeIndex < 0 || relativeIndex > 9) continue;
            if (isUp) {
                if (relativeIndex == 1) {
                    charArray[i] = 185;
                    continue;
                }
                if (relativeIndex == 2) {
                    charArray[i] = 178;
                    continue;
                }
                if (relativeIndex == 3) {
                    charArray[i] = 179;
                    continue;
                }
            }
            int newChar = smallUpNumberBase + relativeIndex;
            charArray[i] = (char)newChar;
        }
        return new String(charArray);
    }

    public static String toLowerCaseUnderscore(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && (Character.isUpperCase(string.charAt(i)) || Character.isDigit(string.charAt(i - 1)) ^ Character.isDigit(string.charAt(i)))) {
                result.append("_");
            }
            result.append(Character.toLowerCase(string.charAt(i)));
        }
        return result.toString();
    }

    public static String toLowerCaseUnder(String string) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
    }

    public static String toEnglishName(Object internalName) {
        return Arrays.stream(internalName.toString().toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String toRomanNumeral(int number) {
        return "I".repeat(number).replace("IIIII", "V").replace("IIII", "IV").replace("VV", "X").replace("VIV", "IX").replace("XXXXX", "L").replace("XXXX", "XL").replace("LL", "C").replace("LXL", "XC").replace("CCCCC", "D").replace("CCCC", "CD").replace("DD", "M").replace("DCD", "CM");
    }

    public static String lowerUnderscoreToUpperCamel(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '_') continue;
            if (i == 0 || string.charAt(i - 1) == '_') {
                result.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    public static String formatNumbers(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    @Nonnull
    public static String formatNumber2Places(float number) {
        return TWO_PLACES_FORMAT.format(number);
    }

    public static void combineComponents(class_5250 c1, class_2561 c2) {
        if (!FormattingUtil.isEmptyComponent((class_2561)c1) && !FormattingUtil.isEmptyComponent(c2)) {
            c1.method_27693(", ").method_10852(c2);
        } else {
            c1.method_10852(c2);
        }
    }

    private static boolean isEmptyComponent(class_2561 component) {
        return component.method_10851() == class_7417.field_39004 && component.method_10855().isEmpty();
    }
}

