/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.events.KJSRecipeKeyEvent;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeCapabilities;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMapComponent;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ContentJS;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.fluid.FluidLike;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;

public class GTRecipeComponents {
    public static final RecipeComponent<class_2487> TAG = new RecipeComponent<class_2487>(){

        public String componentType() {
            return "nbt";
        }

        public Class<?> componentClass() {
            return class_2487.class;
        }

        public JsonElement write(RecipeJS recipe, class_2487 value) {
            return NBTUtils.toJson((class_2520)value);
        }

        public class_2487 read(RecipeJS recipe, Object from) {
            return NBTUtils.toTagCompound((Object)from);
        }
    };
    public static final RecipeComponent<class_2960> RESOURCE_LOCATION = new RecipeComponent<class_2960>(){

        public String componentType() {
            return "resource_location";
        }

        public Class<?> componentClass() {
            return class_2960.class;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.STRING;
        }

        public JsonElement write(RecipeJS recipe, class_2960 value) {
            return new JsonPrimitive(value.toString());
        }

        public class_2960 read(RecipeJS recipe, Object from) {
            class_2960 class_29602;
            if (from instanceof CharSequence) {
                CharSequence c = (CharSequence)from;
                class_29602 = class_2960.method_12829((String)c.toString());
            } else {
                class_29602 = class_2960.method_12829((String)String.valueOf(from));
            }
            return class_29602;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<RecipeCondition> RECIPE_CONDITION = new RecipeComponent<RecipeCondition>(){

        public String componentType() {
            return "recipe_condition";
        }

        public Class<?> componentClass() {
            return RecipeCondition.class;
        }

        public JsonElement write(RecipeJS recipe, RecipeCondition value) {
            JsonObject object = new JsonObject();
            object.addProperty("type", (String)GTRegistries.RECIPE_CONDITIONS.getKey(value.getClass()));
            object.add("data", (JsonElement)value.serialize());
            return object;
        }

        public RecipeCondition read(RecipeJS recipe, Object from) {
            String conditionKey;
            Class clazz;
            if (from instanceof CharSequence && (clazz = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey = from.toString())) != null) {
                return RecipeCondition.create(clazz);
            }
            if (from instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)from;
                String conditionKey2 = primitive.getAsString();
                Class clazz2 = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey2);
                if (clazz2 != null) {
                    return RecipeCondition.create(clazz2);
                }
            } else if (from instanceof JsonObject) {
                RecipeCondition condition;
                JsonObject jsonObject = (JsonObject)from;
                String conditionKey3 = class_3518.method_15253((JsonObject)jsonObject, (String)"type", (String)"");
                Class clazz3 = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey3);
                if (clazz3 != null && (condition = RecipeCondition.create(clazz3)) != null) {
                    return condition.deserialize(class_3518.method_15281((JsonObject)jsonObject, (String)"data", (JsonObject)new JsonObject()));
                }
            } else if (from instanceof class_2520) {
                class_2520 tag = (class_2520)from;
                return this.read(recipe, NBTUtils.toJson((class_2520)tag));
            }
            return null;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<FluidIngredientJS> FLUID_INGREDIENT = new RecipeComponent<FluidIngredientJS>(){

        public String componentType() {
            return "input_fluid";
        }

        public Class<?> componentClass() {
            return FluidIngredientJS.class;
        }

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public boolean isInput(RecipeJS recipe, FluidIngredientJS value, ReplacementMatch match) {
            FluidLike m;
            return match instanceof FluidLike && value.matches(m = (FluidLike)match);
        }

        public JsonElement write(RecipeJS recipe, FluidIngredientJS value) {
            return value.ingredient.toJson();
        }

        public FluidIngredientJS read(RecipeJS recipe, Object from) {
            return FluidIngredientJS.of(from);
        }
    };
    public static final RecipeComponent<FluidIngredientJS> FLUID_INGREDIENT_OUT = new RecipeComponent<FluidIngredientJS>(){

        public String componentType() {
            return "output_fluid";
        }

        public Class<?> componentClass() {
            return FluidIngredientJS.class;
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public boolean isOutput(RecipeJS recipe, FluidIngredientJS value, ReplacementMatch match) {
            FluidLike m;
            return match instanceof FluidLike && value.matches(m = (FluidLike)match);
        }

        public JsonElement write(RecipeJS recipe, FluidIngredientJS value) {
            return value.ingredient.toJson();
        }

        public FluidIngredientJS read(RecipeJS recipe, Object from) {
            return FluidIngredientJS.of(from);
        }
    };
    public static final ContentJS<InputItem> ITEM_IN = new ContentJS(ItemComponents.INPUT, GTRecipeCapabilities.ITEM, false);
    public static final ContentJS<OutputItem> ITEM_OUT = new ContentJS(ItemComponents.OUTPUT, GTRecipeCapabilities.ITEM, true);
    public static final ContentJS<FluidIngredientJS> FLUID_IN = new ContentJS<FluidIngredientJS>(FLUID_INGREDIENT, GTRecipeCapabilities.FLUID, false);
    public static final ContentJS<FluidIngredientJS> FLUID_OUT = new ContentJS<FluidIngredientJS>(FLUID_INGREDIENT_OUT, GTRecipeCapabilities.FLUID, true);
    public static final ContentJS<Long> EU_IN = new ContentJS(NumberComponent.ANY_LONG, GTRecipeCapabilities.EU, false);
    public static final ContentJS<Long> EU_OUT = new ContentJS(NumberComponent.ANY_LONG, GTRecipeCapabilities.EU, true);
    public static final ContentJS<Float> SU_IN = new ContentJS(NumberComponent.ANY_FLOAT, GTRecipeCapabilities.SU, false);
    public static final ContentJS<Float> SU_OUT = new ContentJS(NumberComponent.ANY_FLOAT, GTRecipeCapabilities.SU, true);
    public static final CapabilityMapComponent IN = new CapabilityMapComponent(false);
    public static final CapabilityMapComponent TICK_IN = new CapabilityMapComponent(false);
    public static final CapabilityMapComponent OUT = new CapabilityMapComponent(true);
    public static final CapabilityMapComponent TICK_OUT = new CapabilityMapComponent(true);
    public static final Map<RecipeCapability<?>, Pair<ContentJS<?>, ContentJS<?>>> VALID_CAPS = new IdentityHashMap();

    static {
        VALID_CAPS.put(GTRecipeCapabilities.ITEM, Pair.of(ITEM_IN, ITEM_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.FLUID, Pair.of(FLUID_IN, FLUID_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.EU, Pair.of(EU_IN, EU_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.SU, Pair.of(SU_IN, SU_OUT));
        KJSRecipeKeyEvent event = new KJSRecipeKeyEvent();
        AddonFinder.getAddons().forEach(addon -> addon.registerRecipeKeys(event));
        VALID_CAPS.putAll(event.getRegisteredKeys());
        Set<RecipeCapability<?>> addedCaps = event.getRegisteredKeys().keySet();
        Set registeredCaps = GTRegistries.RECIPE_CAPABILITIES.values();
        registeredCaps.removeAll(addedCaps);
    }

    public static class FluidIngredientJS
    implements InputFluid,
    OutputFluid {
        private final FluidIngredient ingredient;

        public FluidIngredientJS(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }

        public long kjs$getAmount() {
            return this.ingredient.getAmount();
        }

        public FluidIngredientJS kjs$copy(long amount) {
            FluidIngredient ingredient1 = this.ingredient.copy();
            ingredient1.setAmount(amount);
            return new FluidIngredientJS(ingredient1);
        }

        public boolean matches(FluidLike other) {
            if (other instanceof FluidStackJS) {
                FluidStackJS fluidStack = (FluidStackJS)other;
                return this.ingredient.test(FluidStack.create((class_3611)fluidStack.getFluid(), (long)fluidStack.getAmount(), (class_2487)fluidStack.getNbt()));
            }
            return other.matches((FluidLike)this);
        }

        public static FluidIngredientJS of(Object o) {
            if (o instanceof FluidIngredientJS) {
                FluidIngredientJS ingredientJS = (FluidIngredientJS)o;
                return ingredientJS;
            }
            if (o instanceof FluidIngredient) {
                FluidIngredient ingredient = (FluidIngredient)o;
                return new FluidIngredientJS(ingredient);
            }
            if (o instanceof JsonElement) {
                JsonElement json = (JsonElement)o;
                return new FluidIngredientJS(FluidIngredient.fromJson(json));
            }
            if (o instanceof FluidStackJS) {
                FluidStackJS fluidStackJS = (FluidStackJS)o;
                return new FluidIngredientJS(FluidIngredient.of(FluidStack.create((class_3611)fluidStackJS.getFluid(), (long)fluidStackJS.getAmount(), (class_2487)fluidStackJS.getNbt())));
            }
            List list = ListJS.of((Object)o);
            if (list != null && !list.isEmpty()) {
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (Object object : list) {
                    FluidStackJS stackJS = FluidStackJS.of(object);
                    stacks.add(FluidStack.create((class_3611)stackJS.getFluid(), (long)stackJS.getAmount(), (class_2487)stackJS.getNbt()));
                }
                return new FluidIngredientJS(FluidIngredient.of((FluidStack[])stacks.toArray(FluidStack[]::new)));
            }
            FluidStackJS stackJS = FluidStackJS.of((Object)o);
            return new FluidIngredientJS(FluidIngredient.of(FluidStack.create((class_3611)stackJS.getFluid(), (long)stackJS.getAmount(), (class_2487)stackJS.getNbt())));
        }
    }
}

