/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.StressRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.common.recipe.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.RPMCondition;
import com.gregtechceu.gtceu.common.recipe.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.ThunderCondition;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMap;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.GTRecipeComponents;
import com.lowdragmc.lowdraglib.LDLib;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.commons.lang3.ArrayUtils;

public interface GTRecipeSchema {
    public static final RecipeKey<class_2960> ID = GTRecipeComponents.RESOURCE_LOCATION.key("id");
    public static final RecipeKey<Long> DURATION = TimeComponent.TICKS.key("duration").optional((Object)100L);
    public static final RecipeKey<class_2487> DATA = GTRecipeComponents.TAG.key("data").optional((Object)null);
    public static final RecipeKey<RecipeCondition[]> CONDITIONS = GTRecipeComponents.RECIPE_CONDITION.asArray().key("recipeConditions").defaultOptional();
    public static final RecipeKey<Boolean> IS_FUEL = BooleanComponent.BOOLEAN.key("isFuel").optional((Object)false);
    public static final RecipeKey<CapabilityMap> ALL_INPUTS = GTRecipeComponents.IN.key("inputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_INPUTS = GTRecipeComponents.TICK_IN.key("tickInputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_OUTPUTS = GTRecipeComponents.OUT.key("outputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_OUTPUTS = GTRecipeComponents.TICK_OUT.key("tickOutputs").defaultOptional();
    public static final RecipeSchema SCHEMA = new RecipeSchema(GTRecipeJS.class, GTRecipeJS::new, new RecipeKey[]{DURATION, DATA, CONDITIONS, ALL_INPUTS, ALL_TICK_INPUTS, ALL_OUTPUTS, ALL_TICK_OUTPUTS, IS_FUEL}).constructor((recipe, schemaType, keys, from) -> recipe.id((class_2960)from.getValue(recipe, ID)), new RecipeKey[]{ID}).constructor(new RecipeKey[]{DURATION, CONDITIONS, ALL_INPUTS, ALL_OUTPUTS, ALL_TICK_INPUTS, ALL_TICK_OUTPUTS});

    public static class GTRecipeJS
    extends RecipeJS {
        public boolean perTick;
        public float chance = 1.0f;
        public float tierChanceBoost = 0.0f;

        @HideFromJS
        public GTRecipeJS id(class_2960 _id) {
            this.id = new class_2960(_id.method_12836().equals("minecraft") ? this.type.id.method_12836() : _id.method_12836(), "%s/%s".formatted(this.type.id.method_12832(), _id.method_12832()));
            return this;
        }

        public <T> GTRecipeJS input(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_INPUTS) == null) {
                    this.setValue(ALL_TICK_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_INPUTS);
            } else {
                if (this.getValue(ALL_INPUTS) == null) {
                    this.setValue(ALL_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_INPUTS);
            }
            if (map != null) {
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.tierChanceBoost, null, null));
                }
            }
            this.save();
            return this;
        }

        public <T> GTRecipeJS output(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_OUTPUTS) == null) {
                    this.setValue(ALL_TICK_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_OUTPUTS);
            } else {
                if (this.getValue(ALL_OUTPUTS) == null) {
                    this.setValue(ALL_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_OUTPUTS);
            }
            if (map != null) {
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.tierChanceBoost, null, null));
                }
            }
            this.save();
            return this;
        }

        public GTRecipeJS addCondition(RecipeCondition condition) {
            if (this.getValue(CONDITIONS) == null) {
                this.setValue(CONDITIONS, new RecipeCondition[0]);
            }
            this.setValue(CONDITIONS, (RecipeCondition[])ArrayUtils.add((Object[])((RecipeCondition[])this.getValue(CONDITIONS)), (Object)condition));
            this.save();
            return this;
        }

        public GTRecipeJS inputEU(long eu) {
            return this.input(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS EUt(long eu) {
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            if (eu > 0L) {
                this.inputEU(eu);
            } else if (eu < 0L) {
                this.outputEU(-eu);
            }
            this.perTick = lastPerTick;
            return this;
        }

        public GTRecipeJS outputEU(long eu) {
            return this.output(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS itemInputs(InputItem ... inputs) {
            return this.inputItems(inputs);
        }

        public GTRecipeJS itemInput(UnificationEntry input) {
            return this.inputItems(input);
        }

        public GTRecipeJS itemInput(UnificationEntry input, int count) {
            return this.inputItems(input, count);
        }

        public GTRecipeJS inputItems(InputItem ... inputs) {
            return this.input(ItemRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS inputItems(class_1799 ... inputs) {
            for (class_1799 itemStack : inputs) {
                if (!itemStack.method_7960()) continue;
                GTCEu.LOGGER.error("gt recipe {} input items is empty", (Object)this.id);
                throw new IllegalArgumentException(this.id + ": input items is empty");
            }
            return this.input(ItemRecipeCapability.CAP, Arrays.stream(inputs).map(stack -> InputItem.of((class_1856)SizedIngredient.create(stack.method_7985() ? NBTIngredient.createNBTIngredient(stack) : class_1856.method_8101((class_1799[])new class_1799[]{stack}), stack.method_7947()), (int)stack.method_7947())).toArray());
        }

        public GTRecipeJS inputItems(class_6862<class_1792> tag, int amount) {
            return this.inputItems(InputItem.of((Object)((Object)SizedIngredient.create(tag, amount))));
        }

        public GTRecipeJS inputItems(class_1792 input, int amount) {
            return this.inputItems(new class_1799((class_1935)input, amount));
        }

        public GTRecipeJS inputItems(class_1792 input) {
            return this.inputItems(InputItem.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{input}), (int)1));
        }

        public GTRecipeJS inputItems(Supplier<? extends class_1792> input) {
            return this.inputItems(InputItem.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)input.get()}), (int)1));
        }

        public GTRecipeJS inputItems(Supplier<? extends class_1792> input, int amount) {
            return this.inputItems(new class_1799((class_1935)input.get(), amount));
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material) {
            return this.inputItems(orePrefix, material, 1);
        }

        public GTRecipeJS inputItems(UnificationEntry input) {
            return this.inputItems(input.tagPrefix, input.material, 1);
        }

        public GTRecipeJS inputItems(UnificationEntry input, int count) {
            return this.inputItems(input.tagPrefix, input.material, count);
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material, int count) {
            return this.inputItems(ChemicalHelper.getTag(orePrefix, material), count);
        }

        public GTRecipeJS inputItems(MachineDefinition machine) {
            return this.inputItems(machine, 1);
        }

        public GTRecipeJS inputItems(MachineDefinition machine, int count) {
            return this.inputItems(machine.asStack(count));
        }

        public GTRecipeJS itemOutputs(OutputItem ... outputs) {
            return this.outputItems(outputs);
        }

        public GTRecipeJS itemOutput(UnificationEntry unificationEntry) {
            return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material);
        }

        public GTRecipeJS itemOutput(UnificationEntry unificationEntry, int count) {
            return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material, count);
        }

        public GTRecipeJS outputItems(OutputItem ... outputs) {
            for (OutputItem itemStack : outputs) {
                if (!itemStack.isEmpty()) continue;
                LDLib.LOGGER.error("gt recipe {} output items is empty", (Object)this.id);
                throw new IllegalArgumentException(this.id + ": output items is empty");
            }
            return this.output(ItemRecipeCapability.CAP, outputs);
        }

        public GTRecipeJS outputItems(class_1792 input, int amount) {
            return this.outputItems(OutputItem.of((Object)new class_1799((class_1935)input, amount)));
        }

        public GTRecipeJS outputItems(class_1792 input) {
            return this.outputItems(OutputItem.of((Object)new class_1799((class_1935)input)));
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material) {
            return this.outputItems(orePrefix, material, 1);
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material, int count) {
            return this.outputItems(OutputItem.of((Object)ChemicalHelper.get(orePrefix, material, count)));
        }

        public GTRecipeJS outputItems(MachineDefinition machine) {
            return this.outputItems(machine, 1);
        }

        public GTRecipeJS outputItems(MachineDefinition machine, int count) {
            return this.outputItems(OutputItem.of((Object)machine.asStack(count)));
        }

        public GTRecipeJS notConsumable(InputItem itemStack) {
            float lastChance = this.chance;
            this.chance = 0.0f;
            this.inputItems(itemStack);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumable(Supplier<? extends class_1792> item) {
            float lastChance = this.chance;
            this.chance = 0.0f;
            this.inputItems(item);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumable(TagPrefix orePrefix, Material material) {
            float lastChance = this.chance;
            this.chance = 0.0f;
            this.inputItems(orePrefix, material);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS circuit(int configuration) {
            return this.notConsumable(InputItem.of((class_1856)NBTIngredient.createNBTIngredient(IntCircuitBehaviour.stack(configuration)), (int)1));
        }

        public GTRecipeJS chancedInput(InputItem stack, int chance, int tierChanceBoost) {
            float lastChance = this.chance;
            float lastTierChanceBoost = this.tierChanceBoost;
            this.chance = (float)chance / 10000.0f;
            this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
            this.inputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(OutputItem stack, int chance, int tierChanceBoost) {
            float lastChance = this.chance;
            float lastTierChanceBoost = this.tierChanceBoost;
            this.chance = stack.hasChance() ? (float)(stack.getChance() > 1.0 ? stack.getChance() / 10000.0 : stack.getChance()) : (float)chance / 10000.0f;
            this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
            this.outputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidInput(GTRecipeComponents.FluidIngredientJS stack, int chance, int tierChanceBoost) {
            float lastChance = this.chance;
            float lastTierChanceBoost = this.tierChanceBoost;
            this.chance = (float)chance / 10000.0f;
            this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
            this.inputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidOutput(FluidStackJS stack, int chance, int tierChanceBoost) {
            float lastChance = this.chance;
            float lastTierChanceBoost = this.tierChanceBoost;
            this.chance = (float)chance / 10000.0f;
            this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
            this.outputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
            return this.chancedOutput(OutputItem.of((class_1799)ChemicalHelper.get(tag, mat), (double)chance), chance, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
            return this.chancedOutput(OutputItem.of((class_1799)ChemicalHelper.get(tag, mat, count), (double)chance), chance, tierChanceBoost);
        }

        public GTRecipeJS inputFluids(GTRecipeComponents.FluidIngredientJS ... inputs) {
            return this.input(FluidRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS outputFluids(FluidStackJS ... outputs) {
            return this.output(FluidRecipeCapability.CAP, outputs);
        }

        public GTRecipeJS inputStress(float stress) {
            return this.input(StressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public GTRecipeJS outputStress(float stress) {
            return this.output(StressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public GTRecipeJS addData(String key, class_2520 data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10566(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addData(String key, int data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10569(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addData(String key, long data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10544(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addData(String key, String data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10582(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addData(String key, Float data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10548(key, data.floatValue());
            this.save();
            return this;
        }

        public GTRecipeJS addData(String key, boolean data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new class_2487());
            }
            ((class_2487)this.getValue(DATA)).method_10556(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS blastFurnaceTemp(int blastTemp) {
            return this.addData("ebf_temp", blastTemp);
        }

        public GTRecipeJS explosivesAmount(int explosivesAmount) {
            return this.addData("explosives_amount", explosivesAmount);
        }

        public GTRecipeJS explosivesType(class_1799 explosivesType) {
            return this.addData("explosives_type", (class_2520)explosivesType.method_7953(new class_2487()));
        }

        public GTRecipeJS solderMultiplier(int multiplier) {
            return this.addData("solderMultiplier", multiplier);
        }

        public GTRecipeJS disableDistilleryRecipes(boolean flag) {
            return this.addData("disable_distillery", flag);
        }

        public GTRecipeJS fusionStartEU(long eu) {
            return this.addData("eu_to_start", eu);
        }

        public GTRecipeJS cleanroom(CleanroomType cleanroomType) {
            return this.addCondition(new CleanroomCondition(cleanroomType));
        }

        public GTRecipeJS dimension(class_2960 dimension, boolean reverse) {
            return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
        }

        public GTRecipeJS dimension(class_2960 dimension) {
            return this.dimension(dimension, false);
        }

        public GTRecipeJS biome(class_2960 biome, boolean reverse) {
            return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
        }

        public GTRecipeJS biome(class_2960 biome) {
            return this.biome(biome, false);
        }

        public GTRecipeJS rain(float level, boolean reverse) {
            return this.addCondition(new RainingCondition(level).setReverse(reverse));
        }

        public GTRecipeJS rain(float level) {
            return this.rain(level, false);
        }

        public GTRecipeJS thunder(float level, boolean reverse) {
            return this.addCondition(new ThunderCondition(level).setReverse(reverse));
        }

        public GTRecipeJS thunder(float level) {
            return this.thunder(level, false);
        }

        public GTRecipeJS posY(int min, int max, boolean reverse) {
            return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
        }

        public GTRecipeJS posY(int min, int max) {
            return this.posY(min, max, false);
        }

        public GTRecipeJS rpm(float rpm, boolean reverse) {
            return this.addCondition(new RPMCondition(rpm).setReverse(reverse));
        }

        public GTRecipeJS rpm(float rpm) {
            return this.rpm(rpm, false);
        }

        public InputItem readInputItem(Object from) {
            if (from instanceof SizedIngredient) {
                SizedIngredient ingr = (SizedIngredient)((Object)from);
                return InputItem.of((class_1856)ingr.getInner(), (int)ingr.getAmount());
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                if (!jsonObject.has("type") || !jsonObject.get("type").getAsString().equals(SizedIngredient.TYPE.toString())) {
                    return InputItem.of((Object)from);
                }
                SizedIngredient sizedIngredient = SizedIngredient.fromJson(jsonObject);
                return InputItem.of((class_1856)sizedIngredient.getInner(), (int)sizedIngredient.getAmount());
            }
            return InputItem.of((Object)from);
        }

        public JsonElement writeInputItem(InputItem value) {
            return SizedIngredient.create(value.ingredient, value.count).method_8089();
        }

        public OutputItem readOutputItem(Object from) {
            if (from instanceof SizedIngredient) {
                SizedIngredient ingredient = (SizedIngredient)((Object)from);
                return OutputItem.of((class_1799)ingredient.getInner().method_8105()[0], (double)Double.NaN);
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                float chance = 1.0f;
                if (jsonObject.has("chance")) {
                    chance = jsonObject.get("chance").getAsFloat();
                }
                if (jsonObject.has("content")) {
                    jsonObject = jsonObject.getAsJsonObject("content");
                }
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonObject);
                return OutputItem.of((class_1799)ingredient.method_8105()[0], (double)chance);
            }
            return OutputItem.of((Object)from);
        }

        public JsonElement writeOutputItem(OutputItem value) {
            return SizedIngredient.create(value.item).method_8089();
        }

        public JsonElement writeInputFluid(InputFluid value) {
            FluidStack fluid = ((FluidStackJS)value).getFluidStack();
            return FluidIngredient.of(fluid.getAmount(), fluid.getFluid()).toJson();
        }

        public InputFluid readInputFluid(Object from) {
            return super.readInputFluid(from);
        }

        public GTRecipeJS perTick(boolean perTick) {
            this.perTick = perTick;
            return this;
        }

        public GTRecipeJS chance(float chance) {
            this.chance = chance;
            return this;
        }

        public GTRecipeJS tierChanceBoost(float tierChanceBoost) {
            this.tierChanceBoost = tierChanceBoost;
            return this;
        }
    }
}

