/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders;

import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class FluidVeinBuilderJS {
    private final class_2960 id;
    private int weight;
    private int minimumYield;
    private int maximumYield;
    private int depletionAmount;
    private int depletionChance = 1;
    private int depletedYield;
    private Supplier<class_3611> fluid;
    private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();
    private final transient Set<class_5321<class_1937>> dimensions = new HashSet<class_5321<class_1937>>();

    public FluidVeinBuilderJS(class_2960 id) {
        this.id = id;
    }

    public FluidVeinBuilderJS yield(int min, int max) {
        return this.minimumYield(min).maximumYield(max);
    }

    public FluidVeinBuilderJS addSpawnDimension(class_2960 ... dimensions) {
        for (class_2960 dimension : dimensions) {
            this.dimensions.add((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimension));
        }
        return this;
    }

    public FluidVeinBuilderJS biomes(int weight, String biomes) {
        class_2378 registry = (class_2378)GTRegistries.builtinRegistry().method_33310(class_7924.field_41236).get();
        this.biomes.add(new BiomeWeightModifier(() -> biomes.startsWith("#") ? registry.method_40260(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biomes.substring(1)))) : class_6885.method_40246((class_6880[])new class_6880[]{registry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960(biomes)))}), weight));
        return this;
    }

    public FluidVeinBuilderJS biomes(int weight, String ... biomes) {
        class_2378 registry = (class_2378)GTRegistries.builtinRegistry().method_33310(class_7924.field_41236).get();
        LinkedList<class_6885.class_6888> biomeKeys = new LinkedList<class_6885.class_6888>();
        for (String biome : biomes) {
            biomeKeys.add((class_6885.class_6888)(biome.startsWith("#") ? registry.method_40260(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biome.substring(1)))) : class_6885.method_40246((class_6880[])new class_6880[]{registry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960(biome)))})));
        }
        this.biomes.add(new BiomeWeightModifier(() -> class_6885.method_40242(biomeKeys.stream().flatMap(class_6885::method_40239).toList()), weight));
        return this;
    }

    @HideFromJS
    public BedrockFluidDefinition build() {
        return new BedrockFluidDefinition(this.id, this.weight, this.minimumYield, this.maximumYield, this.depletionAmount, this.depletionChance, this.depletedYield, this.fluid, this.biomes, this.dimensions);
    }

    public FluidVeinBuilderJS weight(int weight) {
        this.weight = weight;
        return this;
    }

    public FluidVeinBuilderJS minimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
        return this;
    }

    public FluidVeinBuilderJS maximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
        return this;
    }

    public FluidVeinBuilderJS depletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    public FluidVeinBuilderJS depletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    public FluidVeinBuilderJS depletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    public FluidVeinBuilderJS fluid(Supplier<class_3611> fluid) {
        this.fluid = fluid;
        return this;
    }
}

