/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.util;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.util.IConfigurableSlot;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class ExportOnlyAESlot
implements IConfigurableSlot,
ITagSerializable<class_2487>,
IContentChangeAware {
    protected static final String CONFIG_TAG = "config";
    protected static final String STOCK_TAG = "stock";
    protected Runnable onContentsChanged = () -> {};
    protected GenericStack config;
    protected GenericStack stock;

    public ExportOnlyAESlot(GenericStack config, GenericStack stock) {
        this.config = config;
        this.stock = stock;
    }

    public ExportOnlyAESlot() {
        this(null, null);
    }

    @Nullable
    public GenericStack requestStack() {
        if (this.stock != null && this.stock.amount() <= 0L) {
            this.stock = null;
        }
        if (this.config == null || this.stock != null && !this.config.what().matches(this.stock)) {
            return null;
        }
        if (this.stock == null) {
            return ExportOnlyAESlot.copy(this.config);
        }
        if (this.stock.amount() < this.config.amount()) {
            return ExportOnlyAESlot.copy(this.config, this.config.amount() - this.stock.amount());
        }
        return null;
    }

    @Nullable
    public GenericStack exceedStack() {
        if (this.stock != null && this.stock.amount() <= 0L) {
            this.stock = null;
        }
        if (this.config == null && this.stock != null) {
            return ExportOnlyAESlot.copy(this.stock);
        }
        if (this.config != null && this.stock != null) {
            if (this.config.what().matches(this.stock) && this.config.amount() < this.stock.amount()) {
                return ExportOnlyAESlot.copy(this.stock, this.stock.amount() - this.config.amount());
            }
            if (!this.config.what().matches(this.stock)) {
                return ExportOnlyAESlot.copy(this.stock);
            }
        }
        return null;
    }

    protected abstract void addStack(GenericStack var1);

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.config != null) {
            class_2487 configTag = GenericStack.writeTag((GenericStack)this.config);
            tag.method_10566(CONFIG_TAG, (class_2520)configTag);
        }
        if (this.stock != null) {
            class_2487 stockTag = GenericStack.writeTag((GenericStack)this.stock);
            tag.method_10566(STOCK_TAG, (class_2520)stockTag);
        }
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545(CONFIG_TAG)) {
            this.config = GenericStack.readTag((class_2487)tag.method_10562(CONFIG_TAG));
        }
        if (tag.method_10545(STOCK_TAG)) {
            this.stock = GenericStack.readTag((class_2487)tag.method_10562(STOCK_TAG));
        }
    }

    @Override
    public GenericStack getConfig() {
        return this.config;
    }

    @Override
    public GenericStack getStock() {
        return this.stock;
    }

    @Override
    public void setConfig(GenericStack val) {
        this.config = val;
    }

    @Override
    public void setStock(GenericStack val) {
        this.stock = val;
    }

    public static GenericStack copy(GenericStack stack) {
        return new GenericStack(stack.what(), stack.amount());
    }

    public static GenericStack copy(GenericStack stack, long amount) {
        return new GenericStack(stack.what(), amount);
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

