/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.misc.ComputerRecipes;
import com.gregtechceu.gtceu.integration.ae2.GTAEMachines;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_3489;
import net.minecraft.class_6862;

public class MachineRecipeLoader {
    private static final MaterialStack[][] alloySmelterList = new MaterialStack[][]{{new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.Iron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.WroughtIron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.Iron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.WroughtIron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.Lead, 4L), new MaterialStack(GTMaterials.Antimony, 1L), new MaterialStack(GTMaterials.BatteryAlloy, 5L)}, {new MaterialStack(GTMaterials.Gold, 1L), new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrum, 2L)}, {new MaterialStack(GTMaterials.Magnesium, 1L), new MaterialStack(GTMaterials.Aluminium, 2L), new MaterialStack(GTMaterials.Magnalium, 3L)}, {new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrotine, 4L), new MaterialStack(GTMaterials.BlueAlloy, 1L)}};

    private MachineRecipeLoader() {
    }

    public static void init(Consumer<class_2444> provider) {
        ComputerRecipes.init(provider);
        MachineRecipeLoader.registerDecompositionRecipes(provider);
        MachineRecipeLoader.registerBlastFurnaceRecipes(provider);
        MachineRecipeLoader.registerAssemblerRecipes(provider);
        MachineRecipeLoader.registerAlloyRecipes(provider);
        MachineRecipeLoader.registerBendingCompressingRecipes(provider);
        MachineRecipeLoader.registerCokeOvenRecipes(provider);
        MachineRecipeLoader.registerFluidRecipes(provider);
        MachineRecipeLoader.registerMixingCrystallizationRecipes(provider);
        MachineRecipeLoader.registerPrimitiveBlastFurnaceRecipes(provider);
        MachineRecipeLoader.registerRecyclingRecipes(provider);
        MachineRecipeLoader.registerStoneBricksRecipes(provider);
        MachineRecipeLoader.registerNBTRemoval(provider);
        MachineRecipeLoader.registerHatchConversion(provider);
    }

    private static void registerBendingCompressingRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compressed_fireclay", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Fireclay).outputItems((Supplier<? extends class_1935>)GTItems.COMPRESSED_FIRECLAY).duration(80).EUt(4L).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("credit_cupronickel", new Object[0]).duration(100).EUt(16L).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_MOLD_CREDIT).inputItems(TagPrefix.plate, GTMaterials.Cupronickel, 1).outputItems((Supplier<? extends class_1935>)GTItems.CREDIT_CUPRONICKEL, 4).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("doge_coin", new Object[0]).duration(100).EUt(16L).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_MOLD_CREDIT).inputItems(TagPrefix.plate, GTMaterials.Brass, 1).outputItems((Supplier<? extends class_1935>)GTItems.COIN_DOGE, 4).save(provider);
        for (ItemEntry<class_1792> shapeMold : GTItems.SHAPE_MOLDS) {
            GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_mold_" + shapeMold.get(), new Object[0]).duration(120).EUt(22L).notConsumable((Supplier<? extends class_1792>)shapeMold).inputItems((Supplier<? extends class_1792>)GTItems.SHAPE_EMPTY).outputItems((Supplier<? extends class_1935>)shapeMold).save(provider);
        }
        for (ItemEntry<class_1792> shapeExtruder : GTItems.SHAPE_EXTRUDERS) {
            if (shapeExtruder == null) continue;
            GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_shape_" + shapeExtruder.get(), new Object[0]).duration(120).EUt(22L).notConsumable((Supplier<? extends class_1792>)shapeExtruder).inputItems((Supplier<? extends class_1792>)GTItems.SHAPE_EMPTY).outputItems((Supplier<? extends class_1935>)shapeExtruder).save(provider);
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("empty_shape", new Object[0]).circuitMeta(4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems((Supplier<? extends class_1935>)GTItems.SHAPE_EMPTY).duration(180).EUt(12L).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_tin", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Tin, 2).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL).duration(200).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_steel", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Steel).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_ptfe", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polytetrafluoroethylene).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL, 4).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_pbi", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polybenzimidazole).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL, 16).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_tin", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Tin, 2).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_steel", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Steel).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_ptfe", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Polytetrafluoroethylene).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL, 4).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_pbi", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Polybenzimidazole).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL, 16).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_vial", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_GLASS_VIAL, 4).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_quartz_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.NetherQuartz).outputItems(TagPrefix.plate, GTMaterials.NetherQuartz).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("certus_quartz_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.CertusQuartz).outputItems(TagPrefix.plate, GTMaterials.CertusQuartz).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("quartzite_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Quartzite).outputItems(TagPrefix.plate, GTMaterials.Quartzite).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("coke_bricks", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.COKE_OVEN_BRICK, 4).outputItems(GTBlocks.CASING_COKE_BRICKS.asStack()).duration(300).EUt(2L).save(provider);
    }

    private static void registerPrimitiveBlastFurnaceRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).duration(1500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).duration(1500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Coal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(16200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Charcoal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(16200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Coke).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.Ash).duration(13500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).duration(600).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).duration(600).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Coal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(7200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Charcoal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(7200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Coke).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.Ash).duration(5400).save(provider);
    }

    private static void registerCokeOvenRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("log_to_charcoal", new Object[0]).inputItems((class_6862<class_1792>)class_3489.field_15539).outputItems(TagPrefix.gem, GTMaterials.Charcoal).outputFluids(GTMaterials.Creosote.getFluid(250L)).duration(900).save(provider);
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke", new Object[0]).inputItems(TagPrefix.gem, GTMaterials.Coal).outputItems(TagPrefix.gem, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(500L)).duration(900).save(provider);
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Coal).outputItems(TagPrefix.block, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(4500L)).duration(8100).save(provider);
    }

    private static void registerStoneBricksRecipes(Consumer<class_2444> provider) {
    }

    private static void registerMixingCrystallizationRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("silicon_dioxide_to_quartzite_gem", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputFluids(GTMaterials.DistilledWater.getFluid(250L)).chancedOutput(ChemicalHelper.get(TagPrefix.gem, GTMaterials.Quartzite), 1000, 1000).duration(1200).EUt(24L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("indium_concentrate", new Object[0]).inputItems(TagPrefix.crushedPurified, GTMaterials.Sphalerite).inputItems(TagPrefix.crushedPurified, GTMaterials.Galena).inputFluids(GTMaterials.SulfuricAcid.getFluid(4000L)).outputFluids(GTMaterials.IndiumConcentrate.getFluid(1000L)).duration(60).EUt(150L).save(provider);
    }

    private static void registerAlloyRecipes(Consumer<class_2444> provider) {
        for (MaterialStack[] stack : alloySmelterList) {
            String recipeNape = stack[0].material().getName() + "_%s_and_" + stack[1].material().getName() + "_%s_into_" + stack[2].material().getName();
            if (stack[0].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "dust"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            if (stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "ingot"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            if (stack[0].material().hasProperty(PropertyKey.INGOT) && stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "ingot"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "dust"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
        }
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("carbon_mesh", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_FIBERS, 2).outputItems((Supplier<? extends class_1935>)GTItems.CARBON_MESH).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("carbon_fiber_plate", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_MESH).outputItems((Supplier<? extends class_1935>)GTItems.CARBON_FIBER_PLATE).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_sheet", new Object[0]).duration(10).EUt(GTValues.VA[0]).inputItems(TagPrefix.ingot, GTMaterials.Rubber, 2).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_MOLD_PLATE).outputItems(TagPrefix.plate, GTMaterials.Rubber).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_bar", new Object[0]).duration(100).EUt(GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Sulfur).inputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).outputItems(TagPrefix.ingot, GTMaterials.Rubber).save(provider);
    }

    private static void registerAssemblerRecipes(Consumer<class_2444> provider) {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            GTRecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_" + GTMaterials.CHEMICAL_DYES[i].getName(), new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(576L)).outputItems((Supplier<? extends class_1935>)GTItems.SPRAY_CAN_DYES[i]).EUt(GTValues.VA[0]).duration(200).save(provider);
        }
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_solvent", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.Acetone.getFluid(1000L)).outputItems((Supplier<? extends class_1935>)GTItems.SPRAY_SOLVENT).EUt(GTValues.VA[0]).duration(200).save(provider);
        Material material = GTMaterials.Iron;
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_shutter", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8594)).inputItems(TagPrefix.plate, material, 2).outputItems((Supplier<? extends class_1935>)GTItems.COVER_SHUTTER, 2).EUt(16L).duration(100).save(provider);
        FluidStack solder = GTMaterials.SolderingAlloy.getFluid(72L);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_machine_controller", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10363)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_MACHINE_CONTROLLER).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_energy_detector", new Object[0]).inputItems(TagPrefix.cableGtSingle, GTMaterials.Copper, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ENERGY_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_energy_detector", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.COVER_ENERGY_DETECTOR).inputItems((Supplier<? extends class_1792>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ENERGY_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_activity_detector", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10523)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ACTIVITY_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_activity_cover", new Object[0]).inputItems(TagPrefix.wireFine, GTMaterials.Gold, 4).inputItems(CustomTags.HV_CIRCUITS).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ACTIVITY_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_fluid_detector", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10582)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_FLUID_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_item_detector", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10224)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ITEM_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_fluid_detector", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.COVER_FLUID_DETECTOR).inputItems((Supplier<? extends class_1792>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_FLUID_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_item_detector", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.COVER_ITEM_DETECTOR).inputItems((Supplier<? extends class_1792>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ITEM_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_maintenance_detector", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.EMITTER_LV).inputItems(TagPrefix.plate, GTMaterials.Steel).inputFluids(solder).outputItems((Supplier<? extends class_1935>)GTItems.COVER_MAINTENANCE_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_screen", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Glass).inputItems(TagPrefix.foil, GTMaterials.Aluminium, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.wireFine, GTMaterials.Copper, 4).outputItems((Supplier<? extends class_1935>)GTItems.COVER_SCREEN).EUt(16L).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_infinite_water", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_HV, 2).inputItems(new class_1799((class_1935)class_1802.field_8638)).inputItems(CustomTags.HV_CIRCUITS).outputItems((Supplier<? extends class_1935>)GTItems.COVER_INFINITE_WATER).EUt(GTValues.VA[3]).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_ender_fluid_link", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.EnderPearl, 9).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel).inputItems((Supplier<? extends class_1792>)GTItems.SENSOR_HV).inputItems((Supplier<? extends class_1792>)GTItems.EMITTER_HV).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_HV).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems((Supplier<? extends class_1935>)GTItems.COVER_ENDER_FLUID_LINK).EUt(GTValues.VA[3]).duration(320).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ulv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 8).outputItems(GTBlocks.MACHINE_CASING_ULV.asStack()).circuitMeta(8).duration(25).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_lv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel, 8).outputItems(GTBlocks.MACHINE_CASING_LV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_mv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 8).outputItems(GTBlocks.MACHINE_CASING_MV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 8).outputItems(GTBlocks.MACHINE_CASING_HV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ev", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium, 8).outputItems(GTBlocks.MACHINE_CASING_EV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_iv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 8).outputItems(GTBlocks.MACHINE_CASING_IV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_luv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium, 8).outputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_zpm", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.NaquadahAlloy, 8).outputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_uv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Darmstadtium, 8).outputItems(GTBlocks.MACHINE_CASING_UV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_uhv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Neutronium, 8).outputItems(GTBlocks.MACHINE_CASING_UHV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_cupronickel", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Cupronickel, 8).inputItems(TagPrefix.foil, GTMaterials.Bronze, 8).inputFluids(GTMaterials.TinAlloy.getFluid(144L)).outputItems(GTBlocks.COIL_CUPRONICKEL.asStack()).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_kanthal", new Object[0]).EUt(GTValues.VA[2]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Kanthal, 8).inputItems(TagPrefix.foil, GTMaterials.Aluminium, 8).inputFluids(GTMaterials.Copper.getFluid(144L)).outputItems(GTBlocks.COIL_KANTHAL.asStack()).duration(300).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_nichrome", new Object[0]).EUt(GTValues.VA[3]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Nichrome, 8).inputItems(TagPrefix.foil, GTMaterials.StainlessSteel, 8).inputFluids(GTMaterials.Aluminium.getFluid(144L)).outputItems(GTBlocks.COIL_NICHROME.asStack()).duration(400).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_tungstensteel", new Object[0]).EUt(GTValues.VA[4]).inputItems(TagPrefix.wireGtDouble, GTMaterials.TungstenSteel, 8).inputItems(TagPrefix.foil, GTMaterials.VanadiumSteel, 8).inputFluids(GTMaterials.Nichrome.getFluid(144L)).outputItems(GTBlocks.COIL_TUNGSTENSTEEL.asStack()).duration(500).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_hssg", new Object[0]).EUt(GTValues.VA[5]).inputItems(TagPrefix.wireGtDouble, GTMaterials.HSSG, 8).inputItems(TagPrefix.foil, GTMaterials.TungstenCarbide, 8).inputFluids(GTMaterials.Tungsten.getFluid(144L)).outputItems(GTBlocks.COIL_HSSG.asStack()).duration(600).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_naquadah", new Object[0]).EUt(GTValues.VA[6]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Naquadah, 8).inputItems(TagPrefix.foil, GTMaterials.Osmium, 8).inputFluids(GTMaterials.TungstenSteel.getFluid(144L)).outputItems(GTBlocks.COIL_NAQUADAH.asStack()).duration(700).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_trinium", new Object[0]).EUt(GTValues.VA[7]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Trinium, 8).inputItems(TagPrefix.foil, GTMaterials.NaquadahEnriched, 8).inputFluids(GTMaterials.Naquadah.getFluid(144L)).outputItems(GTBlocks.COIL_TRINIUM.asStack()).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_tritanium", new Object[0]).EUt(GTValues.VA[8]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Tritanium, 8).inputItems(TagPrefix.foil, GTMaterials.Naquadria, 8).inputFluids(GTMaterials.Trinium.getFluid(144L)).outputItems(GTBlocks.COIL_TRITANIUM.asStack()).duration(900).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_bronze_bricks", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze, 6).inputItems(new class_1799((class_1935)class_2246.field_10104)).circuitMeta(6).outputItems(GTBlocks.CASING_BRONZE_BRICKS.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_invar_heatproof", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Invar, 6).inputItems(TagPrefix.frameGt, GTMaterials.Invar).circuitMeta(6).outputItems(GTBlocks.CASING_INVAR_HEATPROOF.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_solid", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel, 6).inputItems(TagPrefix.frameGt, GTMaterials.Steel).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_SOLID.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_aluminium_frostproof", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Aluminium).circuitMeta(6).outputItems(GTBlocks.CASING_ALUMINIUM_FROSTPROOF.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungsteensteel_robust", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_clean", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.StainlessSteel).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_CLEAN.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_stable", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_STABLE.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hsse_sturdy", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.HSSE, 6).inputItems(TagPrefix.frameGt, GTMaterials.Europium).circuitMeta(6).outputItems(GTBlocks.CASING_HSSE_STURDY.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_palladium_substation", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Palladium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Iridium).circuitMeta(6).outputItems(GTBlocks.CASING_PALLADIUM_SUBSTATION.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ptfe_inert", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_SOLID.asStack()).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(216L)).circuitMeta(6).outputItems(GTBlocks.CASING_PTFE_INERT.asStack()).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_luv", new Object[0]).EUt(GTValues.VA[6]).inputItems(TagPrefix.wireGtDouble, GTMaterials.IndiumTinBariumTitaniumCuprate, 32).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 32).inputFluids(GTMaterials.Trinium.getFluid(3456L)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_zpm", new Object[0]).EUt(GTValues.VA[7]).inputItems(TagPrefix.wireGtDouble, GTMaterials.UraniumRhodiumDinaquadide, 16).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 16).inputFluids(GTMaterials.Trinium.getFluid(2304L)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_uv", new Object[0]).EUt(GTValues.VA[8]).inputItems(TagPrefix.wireGtDouble, GTMaterials.EnrichedNaquadahTriniumEuropiumDuranide, 8).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 8).inputFluids(GTMaterials.Trinium.getFluid(1152L)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_coil", new Object[0]).EUt(GTValues.VA[7]).inputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).inputItems(GTItems.FIELD_GENERATOR_IV.asStack(2)).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_IV).inputItems(GTItems.NEUTRON_REFLECTOR.asStack(2)).inputItems(CustomTags.LuV_CIRCUITS, 4).inputItems(TagPrefix.pipeSmallFluid, GTMaterials.Naquadah, 4).inputItems(TagPrefix.plate, GTMaterials.Europium, 4).inputFluids(GTMaterials.VanadiumGallium.getFluid(576L)).outputItems(GTBlocks.FUSION_COIL.asStack()).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_glass", new Object[0]).EUt(GTValues.VA[6]).inputItems(GTBlocks.CASING_LAMINATED_GLASS.asStack()).inputItems(TagPrefix.plate, GTMaterials.Naquadah, 4).inputItems(GTItems.NEUTRON_REFLECTOR.asStack(4)).outputItems(GTBlocks.FUSION_GLASS.asStack(2)).inputFluids(GTMaterials.Polybenzimidazole.getFluid(144L)).duration(50).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing", new Object[0]).EUt(GTValues.VA[6]).inputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).inputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).inputItems((Supplier<? extends class_1792>)GTItems.NEUTRON_REFLECTOR).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_LuV).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(144L)).outputItems(GTBlocks.FUSION_CASING.asStack(2)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk2", new Object[0]).EUt(GTValues.VA[7]).inputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).inputItems(GTBlocks.FUSION_COIL.asStack()).inputItems(GTItems.VOLTAGE_COIL_ZPM.asStack(2)).inputItems((Supplier<? extends class_1792>)GTItems.FIELD_GENERATOR_LuV).inputItems(TagPrefix.plate, GTMaterials.Europium, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288L)).outputItems(GTBlocks.FUSION_CASING_MK2.asStack(2)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk3", new Object[0]).EUt(GTValues.VA[8]).inputItems(GTBlocks.MACHINE_CASING_UV.asStack()).inputItems(GTBlocks.FUSION_COIL.asStack()).inputItems(GTItems.VOLTAGE_COIL_UV.asStack(2)).inputItems((Supplier<? extends class_1792>)GTItems.FIELD_GENERATOR_ZPM).inputItems(TagPrefix.plate, GTMaterials.Americium, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(576L)).outputItems(GTBlocks.FUSION_CASING_MK3.asStack(2)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_turbine", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Magnalium, 6).inputItems(TagPrefix.frameGt, GTMaterials.BlueSteel, 1).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_TURBINE.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_steel_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_TURBINE.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_TURBINE.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungstensteel_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_TURBINE.asStack(2)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("plascrete", new Object[0]).EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Concrete.getFluid(144L)).outputItems(GTBlocks.PLASTCRETE.asStack(2)).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cleanroom_glass", new Object[0]).EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Glass.getFluid(144L)).outputItems(GTBlocks.CLEANROOM_GLASS.asStack(2)).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_ulv", new Object[0]).duration(25).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_ULV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.RedAlloy, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_lv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_LV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Tin, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_mv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_MV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Copper, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_mv_annealed", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_MV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.AnnealedCopper, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_hv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_HV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Gold, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[3]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_ev", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_EV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Aluminium, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems(GTMachines.HULL[4]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_iv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_IV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Platinum, 2).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(288L)).outputItems(GTMachines.HULL[5]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_luv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.NiobiumTitanium, 2).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(288L)).outputItems(GTMachines.HULL[6]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_zpm", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.VanadiumGallium, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288L)).outputItems(GTMachines.HULL[7]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_uv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_UV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.YttriumBariumCuprate, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288L)).outputItems(GTMachines.HULL[8]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_uhv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_UHV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Europium, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288L)).outputItems(GTMachines.HULL[9]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_iron", new Object[0]).EUt(2L).inputItems(CustomTags.TAG_WOODEN_CHESTS).inputItems(TagPrefix.plate, GTMaterials.Iron, 5).outputItems(new class_1799((class_1935)class_2246.field_10312)).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_wrought_iron", new Object[0]).EUt(2L).inputItems(CustomTags.TAG_WOODEN_CHESTS).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 5).outputItems(new class_1799((class_1935)class_2246.field_10312)).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wooden_crate", new Object[0]).EUt(16L).inputItems((class_6862<class_1792>)class_3489.field_15537, 4).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).outputItems(GTMachines.WOODEN_CRATE).duration(100).circuitMeta(5).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 4).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 4).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 4).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_CRATE).circuitMeta(1).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 4).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wood_barrel", new Object[0]).EUt(16L).inputItems((class_6862<class_1792>)class_3489.field_15537, 4).inputItems(TagPrefix.rodLong, GTMaterials.Iron, 2).outputItems(GTMachines.WOODEN_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 2).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 2).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 2).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("gold_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Gold, 2).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(GTMachines.GOLD_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 2).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 2).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polyethylene", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polyethylene, 4).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems((Supplier<? extends class_1935>)GTItems.DUCT_TAPE).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_silicone_rubber", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.SiliconeRubber, 2).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(288L)).outputItems((Supplier<? extends class_1935>)GTItems.DUCT_TAPE, 2).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polycaprolactam", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polycaprolactam, 2).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(144L)).outputItems((Supplier<? extends class_1935>)GTItems.DUCT_TAPE, 4).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polybenzimidazole", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polybenzimidazole).inputItems((Supplier<? extends class_1792>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(72L)).outputItems((Supplier<? extends class_1935>)GTItems.DUCT_TAPE, 8).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_steel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Steel, 2).inputItems(TagPrefix.ring, GTMaterials.Bronze, 2).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_LARGE_STEEL).duration(200).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_aluminium", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Aluminium, 2).inputItems(TagPrefix.ring, GTMaterials.Silver, 2).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_LARGE_ALUMINIUM).duration(200).EUt(64L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_stainless_steel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel, 3).inputItems(TagPrefix.ring, GTMaterials.Electrum, 3).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL).duration(200).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_titanium", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Titanium, 3).inputItems(TagPrefix.ring, GTMaterials.RoseGold, 3).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_LARGE_TITANIUM).duration(200).EUt(256L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_tungstensteel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.ring, GTMaterials.Platinum, 4).outputItems((Supplier<? extends class_1935>)GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL).duration(200).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_drill_mv", new Object[0]).inputItems(GTMachines.HULL[2]).inputItems(TagPrefix.frameGt, GTMaterials.Steel, 4).inputItems(CustomTags.MV_CIRCUITS, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_MOTOR_MV, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_MV, 4).inputItems(TagPrefix.gear, GTMaterials.VanadiumSteel, 4).circuitMeta(2).outputItems(GTMachines.FLUID_DRILLING_RIG[2]).duration(400).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_drill_ev", new Object[0]).inputItems(GTMachines.HULL[4]).inputItems(TagPrefix.frameGt, GTMaterials.Titanium, 4).inputItems(CustomTags.EV_CIRCUITS, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_MOTOR_EV, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_EV, 4).inputItems(TagPrefix.gear, GTMaterials.TungstenCarbide, 4).circuitMeta(2).outputItems(GTMachines.FLUID_DRILLING_RIG[3]).duration(400).EUt(GTValues.VA[4]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_drill_luv", new Object[0]).inputItems(GTMachines.HULL[6]).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel, 4).inputItems(CustomTags.LuV_CIRCUITS, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_MOTOR_LuV, 4).inputItems((Supplier<? extends class_1792>)GTItems.ELECTRIC_PUMP_LuV, 4).inputItems(TagPrefix.gear, GTMaterials.Osmiridium, 4).circuitMeta(2).outputItems(GTMachines.FLUID_DRILLING_RIG[4]).duration(400).EUt(GTValues.VA[6]).save(provider);
    }

    private static void registerBlastFurnaceRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_ruby_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.Ruby).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_ruby_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.Ruby).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_green_sapphire_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.GreenSapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_green_sapphire_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.GreenSapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_sapphire_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.Sapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_sapphire_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.Sapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("titanium_from_tetrachloride", new Object[0]).duration(800).EUt(GTValues.VA[3]).inputItems(TagPrefix.dust, GTMaterials.Magnesium, 2).inputFluids(GTMaterials.TitaniumTetrachloride.getFluid(1000L)).outputItems(TagPrefix.ingotHot, GTMaterials.Titanium).outputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 6).blastFurnaceTemp(GTMaterials.Titanium.getBlastTemperature() + 200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_iron", new Object[0]).duration(500).EUt(GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputFluids(GTMaterials.Oxygen.getFluid(200L)).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).blastFurnaceTemp(1000).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_wrought_iron", new Object[0]).duration(300).EUt(GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputFluids(GTMaterials.Oxygen.getFluid(200L)).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).blastFurnaceTemp(1000).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("rutile_from_ilmenite", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Ilmenite, 10).inputItems(TagPrefix.dust, GTMaterials.Carbon, 4).outputItems(TagPrefix.ingot, GTMaterials.WroughtIron, 2).outputItems(TagPrefix.dust, GTMaterials.Rutile, 4).outputFluids(GTMaterials.CarbonDioxide.getFluid(2000L)).blastFurnaceTemp(1700).duration(1600).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("tempered_glass_blasting", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Glass).inputFluids(GTMaterials.Oxygen.getFluid(100L)).outputItems(GTBlocks.CASING_TEMPERED_GLASS.asStack()).blastFurnaceTemp(1000).duration(200).EUt(GTValues.VA[2]).save(provider);
        MachineRecipeLoader.registerBlastFurnaceMetallurgyRecipes(provider);
    }

    private static void registerBlastFurnaceMetallurgyRecipes(Consumer<class_2444> provider) {
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Stibnite, GTMaterials.AntimonyTrioxide, 1500);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Sphalerite, GTMaterials.Zincite, 1000);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Pyrite, GTMaterials.Hematite, 2000);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Pentlandite, GTMaterials.Garnierite, 1000);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("tetrahedrite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Tetrahedrite).inputFluids(GTMaterials.Oxygen.getFluid(3000L)).outputItems(TagPrefix.dust, GTMaterials.CupricOxide).outputItems(TagPrefix.dustTiny, GTMaterials.AntimonyTrioxide, 3).outputFluids(GTMaterials.SulfurDioxide.getFluid(2000L)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("cobaltite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Cobaltite).inputFluids(GTMaterials.Oxygen.getFluid(3000L)).outputItems(TagPrefix.dust, GTMaterials.CobaltOxide).outputItems(TagPrefix.dust, GTMaterials.ArsenicTrioxide).outputFluids(GTMaterials.SulfurDioxide.getFluid(1000L)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("galena_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Galena).inputFluids(GTMaterials.Oxygen.getFluid(3000L)).outputItems(TagPrefix.dust, GTMaterials.Massicot).outputItems(TagPrefix.nugget, GTMaterials.Silver, 6).outputFluids(GTMaterials.SulfurDioxide.getFluid(1000L)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("chalcopyrite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(2273).inputItems(TagPrefix.dust, GTMaterials.Chalcopyrite).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputFluids(GTMaterials.Oxygen.getFluid(3000L)).outputItems(TagPrefix.dust, GTMaterials.CupricOxide).outputItems(TagPrefix.dust, GTMaterials.Ferrosilite).outputFluids(GTMaterials.SulfurDioxide.getFluid(2000L)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("blast_silicon_dioxide", new Object[0]).duration(240).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputItems(TagPrefix.dust, GTMaterials.Carbon, 2).outputItems(TagPrefix.ingotHot, GTMaterials.Silicon).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).outputFluids(GTMaterials.CarbonMonoxide.getFluid(2000L)).save(provider);
    }

    private static void createSulfurDioxideRecipe(Consumer<class_2444> provider, Material inputMaterial, Material outputMaterial, int sulfurDioxideAmount) {
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder(inputMaterial.getName() + "_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, inputMaterial).inputFluids(GTMaterials.Oxygen.getFluid(3000L)).outputItems(TagPrefix.dust, outputMaterial).outputItems(TagPrefix.dustTiny, GTMaterials.Ash).outputFluids(GTMaterials.SulfurDioxide.getFluid(sulfurDioxideAmount)).save(provider);
    }

    private static void registerDecompositionRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_resin", new Object[0]).inputItems((Supplier<? extends class_1792>)GTItems.STICKY_RESIN).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_leaves", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_LEAVES.asStack(16)).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_log", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_LOG.asStack()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_sapling", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_SAPLING.asStack()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_slime", new Object[0]).duration(150).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8777)).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 2).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_wheat", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8861, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_potato", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8567, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_carrot", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8179, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_cactus", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_2246.field_10029, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_sugar_cane", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_17531, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brown_mushroom", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_2246.field_10251, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_red_mushroom", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_2246.field_10559, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_beetroot", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8186, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_moss", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_28654, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_nether_wart", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8182, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_crimson_stem", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_21981, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_warped_stem", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_21982, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brain_coral", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8616, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_bubble_coral", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8538, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_fire_coral", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8546, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_tube_coral", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8847, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_horn_coral", new Object[0]).duration(300).EUt(2L).inputItems(new class_1799((class_1935)class_1802.field_8723, 8)).outputItems((Supplier<? extends class_1935>)GTItems.PLANT_BALL).save(provider);
    }

    private static void registerRecyclingRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_end_stone", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10471)).outputItems(TagPrefix.dust, GTMaterials.Endstone).chancedOutput(TagPrefix.dustTiny, GTMaterials.Tungstate, 1200, 280).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_netherrack", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10515)).outputItems(TagPrefix.dust, GTMaterials.Netherrack).chancedOutput(TagPrefix.nugget, GTMaterials.Gold, 500, 120).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_basalt", new Object[0]).inputItems(class_2246.field_22091.method_8389()).outputItems(TagPrefix.dust, GTMaterials.Basalt).chancedOutput(TagPrefix.dust, GTMaterials.Basalt, 1000, 380).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_deepslate", new Object[0]).inputItems(class_2246.field_28888.method_8389()).outputItems(TagPrefix.dust, GTMaterials.Deepslate).chancedOutput(TagPrefix.dust, GTMaterials.Thorium, 100, 40).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_andesite", new Object[0]).inputItems(class_2246.field_10115.method_8389()).outputItems(TagPrefix.dust, GTMaterials.Andesite).chancedOutput(TagPrefix.dustSmall, GTMaterials.Stone, 100, 40).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_diorite", new Object[0]).inputItems(class_2246.field_10508.method_8389()).outputItems(TagPrefix.dust, GTMaterials.Diorite).chancedOutput(TagPrefix.dustSmall, GTMaterials.Stone, 100, 40).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_granite", new Object[0]).inputItems(class_2246.field_10474.method_8389()).outputItems(TagPrefix.dust, GTMaterials.Granite).chancedOutput(TagPrefix.dustSmall, GTMaterials.Stone, 100, 40).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_pork_chop", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8389)).outputItems(TagPrefix.dustSmall, GTMaterials.Meat, 6).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_chicken", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8726)).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_steak", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8046)).outputItems(TagPrefix.dustSmall, GTMaterials.Meat, 6).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_rabbit", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8504)).outputItems(TagPrefix.dustSmall, GTMaterials.Meat, 6).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_mutton", new Object[0]).inputItems(new class_1799((class_1935)class_1802.field_8748)).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
    }

    private static void registerFluidRecipes(Consumer<class_2444> provider) {
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_ice_to_water", new Object[0]).duration(32).EUt(4L).inputFluids(GTMaterials.Ice.getFluid(144L)).circuitMeta(1).outputFluids(GTMaterials.Water.getFluid(144L)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_gelled_toluene", new Object[0]).inputFluids(GTMaterials.Toluene.getFluid(100L)).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier<? extends class_1935>)GTItems.GELLED_TOLUENE).duration(100).EUt(16L).save(provider);
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + GTMaterials.CHEMICAL_DYES[i].getName() + "_to_ball", new Object[0]).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(72L)).notConsumable((Supplier<? extends class_1792>)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier<? extends class_1935>)GTItems.DYE_ONLY_ITEMS[i]).duration(100).EUt(16L).save(provider);
        }
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_water_to_steam", new Object[0]).duration(30).EUt(GTValues.VA[1]).inputFluids(GTMaterials.Water.getFluid(6L)).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960L)).save(provider);
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_distilled_to_steam", new Object[0]).duration(30).EUt(GTValues.VA[1]).inputFluids(GTMaterials.DistilledWater.getFluid(6L)).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960L)).save(provider);
    }

    private static void registerNBTRemoval(Consumer<class_2444> provider) {
    }

    private static void registerHatchConversion(Consumer<class_2444> provider) {
        int i;
        for (i = 0; i < GTMachines.FLUID_IMPORT_HATCH.length; ++i) {
            if (GTMachines.FLUID_IMPORT_HATCH[i] == null || GTMachines.FLUID_EXPORT_HATCH[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_output_to_input_" + GTMachines.FLUID_IMPORT_HATCH[i].getTier(), GTMachines.FLUID_IMPORT_HATCH[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.FLUID_EXPORT_HATCH[i].asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_input_to_output_" + GTMachines.FLUID_EXPORT_HATCH[i].getTier(), GTMachines.FLUID_EXPORT_HATCH[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.FLUID_IMPORT_HATCH[i].asStack());
        }
        for (i = 0; i < GTMachines.ITEM_IMPORT_BUS.length; ++i) {
            if (GTMachines.ITEM_IMPORT_BUS[i] == null || GTMachines.ITEM_EXPORT_BUS[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, "item_bus_output_to_input_" + GTMachines.ITEM_IMPORT_BUS[i].getTier(), GTMachines.ITEM_IMPORT_BUS[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.ITEM_EXPORT_BUS[i].asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "item_bus_input_to_output_" + GTMachines.ITEM_EXPORT_BUS[i].getTier(), GTMachines.ITEM_EXPORT_BUS[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.ITEM_IMPORT_BUS[i].asStack());
        }
        for (int tier : GTMachines.MULTI_HATCH_TIERS) {
            String tierName = GTValues.VN[tier].toLowerCase();
            MachineDefinition importHatch4x = GTMachines.FLUID_IMPORT_HATCH_4X[tier];
            MachineDefinition exportHatch4x = GTMachines.FLUID_EXPORT_HATCH_4X[tier];
            MachineDefinition importHatch9x = GTMachines.FLUID_IMPORT_HATCH_9X[tier];
            MachineDefinition exportHatch9x = GTMachines.FLUID_EXPORT_HATCH_9X[tier];
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_4x_output_to_input_" + tierName, importHatch4x.asStack(), "d", "B", Character.valueOf('B'), exportHatch4x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_4x_input_to_output_" + tierName, exportHatch4x.asStack(), "d", "B", Character.valueOf('B'), importHatch4x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_9x_output_to_input_" + tierName, importHatch9x.asStack(), "d", "B", Character.valueOf('B'), exportHatch9x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_9x_input_to_output_" + tierName, exportHatch9x.asStack(), "d", "B", Character.valueOf('B'), importHatch9x.asStack());
        }
        VanillaRecipeHelper.addShapedRecipe(provider, "steam_bus_output_to_input", GTMachines.STEAM_EXPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTMachines.STEAM_IMPORT_BUS.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "steam_bus_input_to_output", GTMachines.STEAM_IMPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTMachines.STEAM_EXPORT_BUS.asStack());
        if (GTCEu.isAE2Loaded()) {
            VanillaRecipeHelper.addShapedRecipe(provider, "me_fluid_hatch_output_to_input", GTAEMachines.FLUID_IMPORT_HATCH.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.FLUID_EXPORT_HATCH.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_fluid_hatch_input_to_output", GTAEMachines.FLUID_EXPORT_HATCH.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.FLUID_IMPORT_HATCH.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_item_bus_output_to_input", GTAEMachines.ITEM_IMPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.ITEM_EXPORT_BUS.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_item_bus_input_to_output", GTAEMachines.ITEM_EXPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.ITEM_IMPORT_BUS.asStack());
        }
    }
}

