/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_3489;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;

public class ToolRecipeHandler {
    public static Map<Integer, ItemEntry<? extends class_1792>> motorItems = new HashMap<Integer, ItemEntry<? extends class_1792>>();
    public static Map<Integer, Material> baseMaterials = new HashMap<Integer, Material>();
    public static Map<Integer, List<ItemEntry<? extends class_1792>>> batteryItems = new HashMap<Integer, List<ItemEntry<? extends class_1792>>>();
    public static Map<Integer, ItemEntry<? extends class_1792>> powerUnitItems = new HashMap<Integer, ItemEntry<? extends class_1792>>();

    public static void init(Consumer<class_2444> provider) {
        ToolRecipeHandler.initializeGTItems();
        TagPrefix.plate.executeHandler(PropertyKey.TOOL, (tagPrefix, material, property) -> ToolRecipeHandler.processTool(tagPrefix, material, property, provider));
        TagPrefix.plate.executeHandler(PropertyKey.TOOL, (tagPrefix, material, property) -> ToolRecipeHandler.processElectricTool(tagPrefix, material, property, provider));
        ToolRecipeHandler.registerPowerUnitRecipes(provider);
        ToolRecipeHandler.registerCustomToolRecipes(provider);
    }

    public static void initializeGTItems() {
        motorItems.put(1, GTItems.ELECTRIC_MOTOR_LV);
        motorItems.put(2, GTItems.ELECTRIC_MOTOR_MV);
        motorItems.put(3, GTItems.ELECTRIC_MOTOR_HV);
        motorItems.put(4, GTItems.ELECTRIC_MOTOR_EV);
        motorItems.put(5, GTItems.ELECTRIC_MOTOR_IV);
        baseMaterials.put(1, GTMaterials.Steel);
        baseMaterials.put(2, GTMaterials.Aluminium);
        baseMaterials.put(3, GTMaterials.StainlessSteel);
        baseMaterials.put(4, GTMaterials.Titanium);
        baseMaterials.put(5, GTMaterials.TungstenSteel);
        powerUnitItems.put(1, GTItems.POWER_UNIT_LV);
        powerUnitItems.put(2, GTItems.POWER_UNIT_MV);
        powerUnitItems.put(3, GTItems.POWER_UNIT_HV);
        powerUnitItems.put(4, GTItems.POWER_UNIT_EV);
        powerUnitItems.put(5, GTItems.POWER_UNIT_IV);
        batteryItems.put(0, Collections.singletonList(GTItems.BATTERY_ULV_TANTALUM));
        batteryItems.put(1, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_LV_LITHIUM, GTItems.BATTERY_LV_CADMIUM, GTItems.BATTERY_LV_SODIUM));
        batteryItems.put(2, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_MV_LITHIUM, GTItems.BATTERY_MV_CADMIUM, GTItems.BATTERY_MV_SODIUM));
        batteryItems.put(3, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_HV_LITHIUM, GTItems.BATTERY_HV_CADMIUM, GTItems.BATTERY_HV_SODIUM, GTItems.ENERGIUM_CRYSTAL));
        batteryItems.put(4, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_EV_VANADIUM, GTItems.LAPOTRON_CRYSTAL));
        batteryItems.put(5, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_IV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB));
        batteryItems.put(6, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_LUV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
        batteryItems.put(7, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_ZPM_NAQUADRIA, GTItems.ENERGY_MODULE));
        batteryItems.put(8, (List<ItemEntry<? extends class_1792>>)ImmutableList.of(GTItems.BATTERY_UV_NAQUADRIA, GTItems.ENERGY_CLUSTER));
    }

    public static void registerPowerUnitRecipes(Consumer<class_2444> provider) {
        for (int tier : powerUnitItems.keySet()) {
            List<ItemEntry<? extends class_1792>> tieredBatteryItems = batteryItems.get(tier);
            for (ItemEntry<? extends class_1792> batteryItem : tieredBatteryItems) {
                if (powerUnitItems.get(tier) == null) continue;
                class_1799 batteryStack = batteryItem.asStack();
                long maxCharge = GTCapabilityHelper.getElectricItem(batteryStack).getMaxCharge();
                class_1799 powerUnitStack = ToolItemHelper.getMaxChargeOverrideStack((class_1792)powerUnitItems.get(tier).get(), maxCharge);
                String recipeName = String.format("%s_%s", ((class_1792)powerUnitItems.get(tier).get()).method_7866(powerUnitStack), ((class_1792)batteryItem.get()).method_7876());
                VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, recipeName, class_1856.method_8101((class_1799[])new class_1799[]{batteryStack}), powerUnitStack, "S d", "GMG", "PBP", Character.valueOf('M'), motorItems.get(tier).asStack(), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, baseMaterials.get(tier)), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, baseMaterials.get(tier)), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, baseMaterials.get(tier)), Character.valueOf('B'), batteryStack);
            }
        }
    }

    private static void processTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<class_2444> provider) {
        class_1799 stick = new class_1799((class_1935)class_1802.field_8600);
        UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
        UnificationEntry ingot = new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material);
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MINING_HAMMER, true, "PPf", "PPS", "PPh", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SPADE, false, "fPh", "PSP", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SAW, false, "PPS", "fhS", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.AXE, false, "PIh", "PS ", "fS ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HOE, false, "PIh", "fS ", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.PICKAXE, false, "PII", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCYTHE, false, "PPI", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SHOVEL, false, "fPh", " S ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SWORD, false, " P ", "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HARD_HAMMER, true, "II ", "IIS", "II ", Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.FILE, true, " P ", " P ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.KNIFE, false, "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WRENCH, false, "PhP", " P ", " P ", Character.valueOf('P'), plate);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            UnificationEntry rod = new UnificationEntry(TagPrefix.rod, material);
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.BUTCHERY_KNIFE, false, "PPf", "PP ", "Sh ", Character.valueOf('P'), plate, Character.valueOf('S'), rod);
                if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
                    ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WIRE_CUTTER, false, "PfP", "hPd", "STS", Character.valueOf('P'), plate, Character.valueOf('T'), new UnificationEntry(TagPrefix.screw, material), Character.valueOf('S'), rod);
                }
            }
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCREWDRIVER, true, " fS", " Sh", "W  ", Character.valueOf('S'), rod, Character.valueOf('W'), stick);
            ToolRecipeHandler.addDyeableToolRecipe(provider, material, GTToolType.CROWBAR, true, "hDS", "DSD", "SDf", Character.valueOf('S'), rod);
        }
    }

    private static void processElectricTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<class_2444> provider) {
        TagPrefix toolPrefix;
        int voltageMultiplier;
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
            UnificationEntry steelPlate = new UnificationEntry(TagPrefix.plate, GTMaterials.Steel);
            UnificationEntry steelRing = new UnificationEntry(TagPrefix.ring, GTMaterials.Steel);
            toolPrefix = TagPrefix.toolHeadDrill;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("drill_head_%s", material), ChemicalHelper.get(toolPrefix, material), "XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate);
            toolPrefix = TagPrefix.toolHeadChainsaw;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("chainsaw_head_%s", material), ChemicalHelper.get(toolPrefix, material), "SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing);
            toolPrefix = TagPrefix.toolHeadWrench;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("wrench_head_%s", material), ChemicalHelper.get(toolPrefix, material), "hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
            toolPrefix = TagPrefix.toolHeadBuzzSaw;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("buzzsaw_blade_%s", material), ChemicalHelper.get(toolPrefix, material), "sXh", "X X", "fXx", Character.valueOf('X'), plate);
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                GTRecipeTypes.LATHE_RECIPES.recipeBuilder("buzzsaw_gear_" + material, new Object[0]).inputItems(TagPrefix.gear, material).outputItems(toolPrefix, material).duration((int)material.getMass() * 4).EUt(8L * (long)voltageMultiplier).save(provider);
            }
        }
        if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
            toolPrefix = TagPrefix.toolHeadScrewdriver;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("screwdriver_tip_%s", material), ChemicalHelper.get(toolPrefix, material), "fR", " h", Character.valueOf('R'), new UnificationEntry(TagPrefix.rodLong, material));
        }
    }

    public static void addElectricToolRecipe(TagPrefix toolHead, Material material, IGTTool[] toolItems, Consumer<class_2444> provider) {
        for (IGTTool toolItem : toolItems) {
            int tier = toolItem.getElectricTier();
            class_1799 powerUnitStack = powerUnitItems.get(tier).asStack();
            IElectricItem powerUnit = GTCapabilityHelper.getElectricItem(powerUnitStack);
            class_1799 tool = toolItem.get(0L, powerUnit.getMaxCharge());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, true, true, String.format("%s_%s", class_7923.field_41178.method_10221((Object)toolItem.method_8389()).method_12832(), material), class_1856.method_8101((class_1799[])new class_1799[]{powerUnitStack}), tool, "wHd", " U ", Character.valueOf('H'), new UnificationEntry(toolHead, material), Character.valueOf('U'), powerUnitStack);
        }
    }

    public static void addToolRecipe(Consumer<class_2444> provider, @Nonnull Material material, @Nonnull GTToolType tool, boolean mirrored, Object ... recipe) {
        class_1799 toolStack = ToolHelper.get(tool, material);
        if (toolStack.method_7960()) {
            return;
        }
        if (mirrored) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material), toolStack, recipe);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material), toolStack, recipe);
        }
    }

    public static void addDyeableToolRecipe(Consumer<class_2444> provider, @Nonnull Material material, @Nonnull GTToolType tool, boolean mirrored, Object ... recipe) {
        class_1799 toolStack = ToolHelper.get(tool, material);
        if (toolStack.method_7960()) {
            return;
        }
        for (Map.Entry color : MarkerMaterials.Color.COLORS.entrySet()) {
            ToolHelper.getToolTag(toolStack).method_10569("TintColor", ((class_1767)color.getKey()).method_16357());
            Object[] recipeWithDye = ArrayUtils.addAll((Object[])recipe, (Object[])new Object[]{Character.valueOf('D'), new UnificationEntry(TagPrefix.dye, (Material)color.getValue())});
            if (mirrored) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material, ((class_1767)color.getKey()).method_15434()), toolStack, recipeWithDye);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s_%s", tool.name, material, ((class_1767)color.getKey()).method_15434()), toolStack, recipeWithDye);
        }
    }

    public static void registerCustomToolRecipes(Consumer<class_2444> provider) {
        ToolRecipeHandler.registerFlintToolRecipes(provider);
        ToolRecipeHandler.registerMortarRecipes(provider);
        ToolRecipeHandler.registerSoftToolRecipes(provider);
        ToolRecipeHandler.registerElectricRecipes(provider);
    }

    private static void registerFlintToolRecipes(Consumer<class_2444> provider) {
        UnificationEntry flint = new UnificationEntry(TagPrefix.gem, GTMaterials.Flint);
        class_1799 stick = new class_1799((class_1935)class_1802.field_8600);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10340));
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SWORD, false, "I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.PICKAXE, false, "III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SHOVEL, false, "I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.AXE, true, "II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.HOE, true, "II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.KNIFE, false, "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
    }

    private static void registerMortarRecipes(Consumer<class_2444> provider) {
        for (Material material : new Material[]{GTMaterials.Bronze, GTMaterials.Iron, GTMaterials.Invar, GTMaterials.Steel, GTMaterials.DamascusSteel, GTMaterials.CobaltBrass, GTMaterials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10340));
        }
    }

    private static void registerSoftToolRecipes(Consumer<class_2444> provider) {
        Material[] softMaterials = new Material[]{GTMaterials.Wood, GTMaterials.Rubber, GTMaterials.Polyethylene, GTMaterials.Polytetrafluoroethylene, GTMaterials.Polybenzimidazole};
        class_1799 stick = new class_1799((class_1935)class_1802.field_8600);
        for (int i = 0; i < softMaterials.length; ++i) {
            Material material = softMaterials[i];
            if (material.hasProperty(PropertyKey.WOOD)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), class_3489.field_15537, Character.valueOf('S'), stick);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(TagPrefix.ingot, material), Character.valueOf('S'), stick);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("plunger_%s", material), ToolHelper.getAndSetToolData(GTToolType.PLUNGER, material, 128 * (i << 1), 1, 4.0f, 0.0f), "xPP", " SP", "S f", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), TagPrefix.rod);
        }
    }

    private static void registerElectricRecipes(Consumer<class_2444> provider) {
        for (ItemEntry<? extends class_1792> batteryItem : batteryItems.get(1)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_lv_" + batteryItem.getId().method_12832(), class_1856.method_8091((class_1935[])new class_1935[]{batteryItem}), GTItems.PROSPECTOR_LV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('S'), GTItems.SENSOR_LV.asStack(), Character.valueOf('D'), new UnificationEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('C'), CustomTags.LV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry<? extends class_1792> batteryItem : batteryItems.get(3)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_hv_" + batteryItem.getId().method_12832(), class_1856.method_8091((class_1935[])new class_1935[]{batteryItem}), GTItems.PROSPECTOR_HV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_HV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('S'), GTItems.SENSOR_HV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.HV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry<? extends class_1792> batteryItem : batteryItems.get(6)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_luv_" + batteryItem.getId().method_12832(), class_1856.method_8091((class_1935[])new class_1935[]{batteryItem}), GTItems.PROSPECTOR_LUV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LuV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('S'), GTItems.SENSOR_LuV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.LuV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
    }
}

