/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2444;
import org.apache.commons.lang3.tuple.Pair;

public class OreRecipeHandler {
    public static void init(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes) {
            for (TagPrefix ore : TagPrefix.ORES.keySet()) {
                ore.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
            }
        } else {
            TagPrefix.ore.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
            TagPrefix.oreDeepslate.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
            TagPrefix.oreEndstone.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
            TagPrefix.oreNetherrack.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
        }
        TagPrefix.rawOre.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processRawOre(tagPrefix, material, property, provider));
        TagPrefix.crushed.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedOre(tagPrefix, material, property, provider));
        TagPrefix.crushedPurified.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedPurified(tagPrefix, material, property, provider));
        TagPrefix.crushedRefined.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedCentrifuged(tagPrefix, material, property, provider));
        TagPrefix.dustImpure.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processDirtyDust(tagPrefix, material, property, provider));
        TagPrefix.dustPure.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processPureDust(tagPrefix, material, property, provider));
    }

    private static void processMetalSmelting(TagPrefix crushedPrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 ingotStack;
        Material smeltingResult;
        Material material2 = smeltingResult = property.getDirectSmeltResult() != null ? property.getDirectSmeltResult() : material;
        if (smeltingResult.hasProperty(PropertyKey.INGOT) && !(ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult)).method_7960() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingResult)) {
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + crushedPrefix.name + "_" + material.getName() + "_to_ingot", ChemicalHelper.getTag(crushedPrefix, material), ingotStack, 0.5f);
        }
    }

    public static void processOre(TagPrefix orePrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        String prefixString;
        Material byproductMaterial = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        class_1799 byproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial);
        if (byproductStack.method_7960()) {
            byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        }
        Material smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
        class_1799 crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        class_1799 ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        int oreMultiplier = TagPrefix.ORES.get(orePrefix).isNether() ? 2 : 1;
        ingotStack.method_7939(ingotStack.method_7947() * oreMultiplier);
        String string = prefixString = orePrefix == TagPrefix.ore ? "" : orePrefix.name + "_";
        if (!crushedStack.method_7960()) {
            GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + prefixString + material.getName() + "_ore_to_raw_ore", new Object[0]).inputItems(orePrefix, material).duration(10).EUt(16L);
            if (material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material)) {
                builder.outputItems(GTUtil.copyAmount(oreMultiplier, ChemicalHelper.get(TagPrefix.gem, material, crushedStack.method_7947())));
            } else {
                builder.outputItems(GTUtil.copyAmount(oreMultiplier, crushedStack));
            }
            builder.save(provider);
            builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + prefixString + material.getName() + "_ore_to_raw_ore", new Object[0]).inputItems(orePrefix, material).outputItems(GTUtil.copyAmount(2 * oreMultiplier, crushedStack)).chancedOutput(byproductStack, 1400, 850).EUt(2L).duration(400);
            Material outputDustMat = (Material)GTRegistries.MATERIALS.get(FormattingUtil.toLowerCaseUnder(orePrefix.name));
            if (outputDustMat != null) {
                builder.outputItems(TagPrefix.dust, outputDustMat);
            }
            builder.save(provider);
        }
        if (!ingotStack.method_7960() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !orePrefix.isIgnored(material)) {
            float xp = (float)Math.round(((1.0f + (float)oreMultiplier * 0.5f) * 0.5f - 0.05f) * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
        }
    }

    public static void processRawOre(TagPrefix orePrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        Material smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
        int amountOfCrushedOre = property.getOreMultiplier();
        class_1799 ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        ingotStack.method_7939(ingotStack.method_7947() * property.getOreMultiplier());
        crushedStack.method_7939(crushedStack.method_7947() * property.getOreMultiplier());
        if (!crushedStack.method_7960()) {
            GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + orePrefix.name + "_" + material.getName() + "_to_crushed_ore", new Object[0]).inputItems(orePrefix, material).duration(10).EUt(16L);
            if (material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material)) {
                builder.outputItems(GTUtil.copyAmount(amountOfCrushedOre, ChemicalHelper.get(TagPrefix.gem, material, crushedStack.method_7947())));
            } else {
                builder.outputItems(GTUtil.copyAmount(amountOfCrushedOre, crushedStack));
            }
            builder.save(provider);
            GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + orePrefix.name + "_" + material.getName() + "_ore_to_crushed_ore", new Object[0]).inputItems(orePrefix, material).outputItems(crushedStack).chancedOutput(crushedStack, 5000, 750).chancedOutput(crushedStack, 2500, 500).chancedOutput(crushedStack, 1250, 250).EUt(2L).duration(400).save(provider);
        }
        if (!ingotStack.method_7960() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !orePrefix.isIgnored(material)) {
            float xp = (float)Math.round((1.0f + (float)property.getOreMultiplier() * 0.33f) / 3.0f * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + orePrefix.name + "_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_" + orePrefix.name + "_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
        }
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapedRecipe(provider, "compress_" + material.getName() + "_to_ore_block", ChemicalHelper.get(TagPrefix.rawOreBlock, material), "BBB", "BBB", "BBB", Character.valueOf('B'), ChemicalHelper.getTag(TagPrefix.rawOre, material));
            VanillaRecipeHelper.addShapelessRecipe(provider, "decompress_" + material.getName() + "_from_ore_block", ChemicalHelper.get(TagPrefix.rawOre, material, 9), ChemicalHelper.getTag(TagPrefix.rawOreBlock, material));
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "to_ore_block", new Object[0]).inputItems(TagPrefix.rawOre, material, 9).outputItems(TagPrefix.rawOreBlock, material).duration(300).EUt(2L).save(provider);
        }
    }

    public static void processCrushedOre(TagPrefix crushedPrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 impureDustStack = ChemicalHelper.get(TagPrefix.dustImpure, material);
        Material byproductMaterial = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_impure_dust", new Object[0]).inputItems(crushedPrefix, material).outputItems(impureDustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_impure_dust", new Object[0]).inputItems(crushedPrefix, material).outputItems(impureDustStack).duration(400).EUt(2L).chancedOutput(ChemicalHelper.get(TagPrefix.dust, byproductMaterial, property.getByProductMultiplier()), 1400, 850).save(provider);
        class_1799 crushedPurifiedOre = GTUtil.copy(ChemicalHelper.get(TagPrefix.crushedPurified, material), ChemicalHelper.get(TagPrefix.dust, material));
        class_1799 crushedCentrifugedOre = GTUtil.copy(ChemicalHelper.get(TagPrefix.crushedRefined, material), ChemicalHelper.get(TagPrefix.dust, material));
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_fast", new Object[0]).inputItems(crushedPrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(crushedPurifiedOre).duration(8).EUt(4L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore", new Object[0]).inputItems(crushedPrefix, material).inputFluids(GTMaterials.Water.getFluid(1000L)).circuitMeta(1).outputItems(crushedPurifiedOre, ChemicalHelper.get(TagPrefix.dustTiny, byproductMaterial, 3), ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone)).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_distilled", new Object[0]).inputItems(crushedPrefix, material).inputFluids(GTMaterials.DistilledWater.getFluid(100L)).outputItems(crushedPurifiedOre, ChemicalHelper.get(TagPrefix.dustTiny, byproductMaterial, 3), ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone)).duration(200).save(provider);
        GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_crushed_ore_to_refined_ore", new Object[0]).inputItems(crushedPrefix, material).outputItems(crushedCentrifugedOre, ChemicalHelper.get(TagPrefix.dustTiny, GTUtil.selectItemInList(1, material, property.getOreByProducts(), Material.class), property.getByProductMultiplier() * 3), ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone)).save(provider);
        if (property.getWashedIn().getKey() != null) {
            Material washingByproduct = GTUtil.selectItemInList(3, material, property.getOreByProducts(), Material.class);
            Pair<Material, Integer> washedInTuple = property.getWashedIn();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("bathe_" + material.getName() + "_crushed_ore_to_purified_ore", new Object[0]).inputItems(crushedPrefix, material).inputFluids(((Material)washedInTuple.getKey()).getFluid(((Integer)washedInTuple.getValue()).intValue())).outputItems(crushedPurifiedOre).chancedOutput(ChemicalHelper.get(TagPrefix.dust, washingByproduct, property.getByProductMultiplier()), 7000, 580).chancedOutput(ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone), 4000, 650).duration(200).EUt(GTValues.VA[1]).save(provider);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("crushed_ore_to_dust_%s", material), impureDustStack, Character.valueOf('h'), new UnificationEntry(crushedPrefix, material));
        OreRecipeHandler.processMetalSmelting(crushedPrefix, material, property, provider);
    }

    public static void processCrushedCentrifuged(TagPrefix centrifugedPrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        class_1799 byproductStack = ChemicalHelper.get(TagPrefix.dust, GTUtil.selectItemInList(2, material, property.getOreByProducts(), Material.class), 1);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_refined_ore_to_dust", new Object[0]).inputItems(centrifugedPrefix, material).outputItems(dustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_refined_ore_to_dust", new Object[0]).inputItems(centrifugedPrefix, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("centrifuged_ore_to_dust_%s", material), dustStack, Character.valueOf('h'), new UnificationEntry(centrifugedPrefix, material));
        OreRecipeHandler.processMetalSmelting(centrifugedPrefix, material, property, provider);
    }

    public static void processCrushedPurified(TagPrefix purifiedPrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 crushedCentrifugedStack = ChemicalHelper.get(TagPrefix.crushedRefined, material);
        class_1799 dustStack = ChemicalHelper.get(TagPrefix.dustPure, material);
        Material byproductMaterial = GTUtil.selectItemInList(1, material, property.getOreByProducts(), Material.class);
        class_1799 byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_dust", new Object[0]).inputItems(purifiedPrefix, material).outputItems(dustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_dust", new Object[0]).inputItems(purifiedPrefix, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("purified_ore_to_dust_%s", material), dustStack, Character.valueOf('h'), new UnificationEntry(purifiedPrefix, material));
        if (!crushedCentrifugedStack.method_7960()) {
            GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_purified_ore_to_refined_ore", new Object[0]).inputItems(purifiedPrefix, material).outputItems(crushedCentrifugedStack, ChemicalHelper.get(TagPrefix.dustTiny, byproductMaterial, 3)).save(provider);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            class_1799 exquisiteStack = ChemicalHelper.get(TagPrefix.gemExquisite, material);
            class_1799 flawlessStack = ChemicalHelper.get(TagPrefix.gemFlawless, material);
            class_1799 gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            class_1799 flawedStack = ChemicalHelper.get(TagPrefix.gemFlawed, material);
            class_1799 chippedStack = ChemicalHelper.get(TagPrefix.gemChipped, material);
            if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems", new Object[0]).inputItems(purifiedPrefix, material).chancedOutput(exquisiteStack, 500, 150).chancedOutput(flawlessStack, 1500, 200).chancedOutput(gemStack, 5000, 1000).chancedOutput(dustStack, 2500, 500).duration(400).EUt(16L);
                if (!flawedStack.method_7960()) {
                    builder.chancedOutput(flawedStack, 2000, 500);
                }
                if (!chippedStack.method_7960()) {
                    builder.chancedOutput(chippedStack, 3000, 350);
                }
                builder.save(provider);
            } else {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems", new Object[0]).inputItems(purifiedPrefix, material).chancedOutput(exquisiteStack, 300, 100).chancedOutput(flawlessStack, 1000, 150).chancedOutput(gemStack, 3500, 500).chancedOutput(dustStack, 5000, 750).duration(400).EUt(16L);
                if (!flawedStack.method_7960()) {
                    builder.chancedOutput(flawedStack, 2500, 300);
                }
                if (!chippedStack.method_7960()) {
                    builder.chancedOutput(chippedStack, 3500, 400);
                }
                builder.save(provider);
            }
        }
        OreRecipeHandler.processMetalSmelting(purifiedPrefix, material, property, provider);
    }

    public static void processDirtyDust(TagPrefix dustPrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        class_1799 dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        Material byproduct = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        GTRecipeBuilder builder = GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_dirty_dust_to_dust", new Object[0]).inputItems(dustPrefix, material).outputItems(dustStack).duration((int)(material.getMass() * 4L)).EUt(24L);
        if (byproduct.hasProperty(PropertyKey.DUST)) {
            builder.outputItems(ChemicalHelper.get(TagPrefix.dustTiny, byproduct));
        } else {
            builder.outputFluids(byproduct.getFluid(16L));
        }
        builder.save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_dirty_dust_to_dust", new Object[0]).inputItems(dustPrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(dustPrefix, material, property, provider);
    }

    public static void processPureDust(TagPrefix purePrefix, Material material, OreProperty property, Consumer<class_2444> provider) {
        Material byproductMaterial = GTUtil.selectItemInList(1, material, property.getOreByProducts(), Material.class);
        class_1799 dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        if (property.getSeparatedInto() != null && !property.getSeparatedInto().isEmpty()) {
            List<Material> separatedMaterial = property.getSeparatedInto();
            class_1799 separatedStack1 = ChemicalHelper.get(TagPrefix.dustSmall, separatedMaterial.get(0));
            TagPrefix prefix = separatedMaterial.get(separatedMaterial.size() - 1).getBlastTemperature() == 0 && separatedMaterial.get(separatedMaterial.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dustSmall;
            class_1799 separatedStack2 = ChemicalHelper.get(prefix, separatedMaterial.get(separatedMaterial.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
            GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("separate_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).outputItems(dustStack).chancedOutput(separatedStack1, 4000, 850).chancedOutput(separatedStack2, 2000, 600).duration(200).EUt(24L).save(provider);
        }
        GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).outputItems(dustStack, ChemicalHelper.get(TagPrefix.dustTiny, byproductMaterial)).duration(100).EUt(5L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(purePrefix, material, property, provider);
    }

    private static boolean doesMaterialUseNormalFurnace(Material material) {
        return !material.hasProperty(PropertyKey.BLAST);
    }
}

