/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2444;

public class DecompositionRecipeHandler {
    public static void init(Consumer<class_2444> provider) {
        for (Material material : GTRegistries.MATERIALS) {
            TagPrefix prefix = material.hasProperty(PropertyKey.DUST) ? TagPrefix.dust : null;
            DecompositionRecipeHandler.processDecomposition(prefix, material, provider);
        }
    }

    private static void processDecomposition(TagPrefix decomposePrefix, Material material, Consumer<class_2444> provider) {
        if (material.getMaterialComponents().isEmpty() || !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) && !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION) || material.getMaterialComponents().size() > 6) {
            return;
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        int totalInputAmount = 0;
        for (MaterialStack component : material.getMaterialComponents()) {
            totalInputAmount = (int)((long)totalInputAmount + component.amount());
            if (component.material().hasProperty(PropertyKey.DUST)) {
                outputs.add(ChemicalHelper.get(TagPrefix.dust, component.material(), (int)component.amount()));
                continue;
            }
            if (!component.material().hasProperty(PropertyKey.FLUID)) continue;
            fluidOutputs.add(component.material().getFluid((int)(1000L * component.amount())));
        }
        if (decomposePrefix != null) {
            ArrayList<Integer> materialAmounts = new ArrayList<Integer>();
            materialAmounts.add(totalInputAmount);
            outputs.forEach(itemStack -> materialAmounts.add(itemStack.method_7947()));
            fluidOutputs.forEach(fluidStack -> materialAmounts.add((int)(fluidStack.getAmount() / 1000L)));
            int highestDivisor = 1;
            int smallestMaterialAmount = DecompositionRecipeHandler.getSmallestMaterialAmount(materialAmounts);
            for (int i = 2; i <= smallestMaterialAmount; ++i) {
                if (!DecompositionRecipeHandler.isEveryMaterialReducible(i, materialAmounts)) continue;
                highestDivisor = i;
            }
            if (highestDivisor != 1) {
                ArrayList<class_1799> reducedOutputs = new ArrayList<class_1799>();
                for (class_1799 itemStack2 : outputs) {
                    class_1799 reducedStack = itemStack2.method_7972();
                    reducedStack.method_7939(reducedStack.method_7947() / highestDivisor);
                    reducedOutputs.add(reducedStack);
                }
                ArrayList<FluidStack> reducedFluidOutputs = new ArrayList<FluidStack>();
                for (FluidStack fluidStack2 : fluidOutputs) {
                    FluidStack reducedFluidStack = fluidStack2.copy();
                    reducedFluidStack.setAmount(reducedFluidStack.getAmount() / (long)highestDivisor);
                    reducedFluidOutputs.add(reducedFluidStack);
                }
                outputs = reducedOutputs;
                fluidOutputs = reducedFluidOutputs;
                totalInputAmount /= highestDivisor;
            }
        }
        GTRecipeBuilder builder = material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) ? GTRecipeTypes.ELECTROLYZER_RECIPES.recipeBuilder("decomposition_electrolyzing", material.getName()).duration((int)material.getProtons() * totalInputAmount * 2).EUt(material.getMaterialComponents().size() <= 2 ? (long)GTValues.VA[1] : 2L * (long)GTValues.VA[1]) : GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("decomposition_centrifuging_", material.getName()).duration((int)Math.ceil((double)(material.getMass() * (long)totalInputAmount) * 1.5)).EUt(GTValues.VA[1]);
        builder.outputItems((class_1799[])outputs.toArray(class_1799[]::new));
        builder.outputFluids((FluidStack[])fluidOutputs.toArray(FluidStack[]::new));
        if (decomposePrefix != null) {
            builder.inputItems(decomposePrefix, material, totalInputAmount);
        } else {
            builder.inputFluids(material.getFluid(1000L));
        }
        builder.save(provider);
    }

    private static boolean isEveryMaterialReducible(int divisor, List<Integer> materialAmounts) {
        for (int amount : materialAmounts) {
            if (amount % divisor == 0) continue;
            return false;
        }
        return true;
    }

    private static int getSmallestMaterialAmount(List<Integer> materialAmounts) {
        return materialAmounts.stream().min(Integer::compare).orElse(0);
    }
}

