/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.data.recipe.builder.BlastingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedEnergyTransferRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapelessRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmeltingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmokingRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.chars.Char2IntFunction;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class VanillaRecipeHelper {
    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_6862<class_1792> input, class_1799 output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, class_6862<class_1792> input, class_1799 output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_6862<class_1792> input, class_1799 output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, class_6862<class_1792> input, class_1799 output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addBlastingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_6862<class_1792> input, class_1799 output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output, experience);
    }

    public static void addBlastingRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, class_6862<class_1792> input, class_1799 output, float experience) {
        new BlastingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmokingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_6862<class_1792> input, class_1799 output, float experience) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output, experience);
    }

    public static void addSmokingRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, class_6862<class_1792> input, class_1799 output, float experience) {
        new SmokingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_1799 input, class_1799 output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull String regName, class_1799 input, class_1799 output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, class_1799 input, class_1799 output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addShapedRecipe(Consumer<class_2444> provider, @Nonnull String regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), result, recipe);
    }

    public static void addShapedRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<class_2444> provider, @Nonnull String regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addShapedRecipe(Consumer<class_2444> provider, boolean withUnificationData, boolean isStrict, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(regName).output(result);
        builder.isStrict(isStrict);
        CharOpenHashSet set = new CharOpenHashSet();
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (Character c : ToolHelper.getToolSymbols()) {
                    if (pattern.indexOf(c.charValue()) < 0) continue;
                    set.add(c.charValue());
                }
            }
            if (o instanceof String[]) {
                pattern = (String[])o;
                for (String s : pattern) {
                    builder.pattern(s);
                    for (Character c : ToolHelper.getToolSymbols()) {
                        if (s.indexOf(c.charValue()) < 0) continue;
                        set.add(c.charValue());
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object content = recipe[i + 1];
            ++i;
            if (content instanceof class_1856) {
                class_1856 ingredient = (class_1856)content;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (content instanceof class_1799) {
                class_1799 itemStack = (class_1799)content;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (content instanceof class_6862) {
                class_6862 key = (class_6862)content;
                builder.define(sign.charValue(), (class_6862<class_1792>)key);
                continue;
            }
            if (content instanceof TagPrefix) {
                TagPrefix prefix = (TagPrefix)content;
                if (prefix.getItemParentTags().length <= 0) continue;
                builder.define(sign.charValue(), prefix.getItemParentTags()[0]);
                continue;
            }
            if (content instanceof class_1935) {
                class_1935 itemLike = (class_1935)content;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                class_6862<class_1792> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (!(content instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)content;
            builder.define(sign.charValue(), entry.asStack());
        }
        for (Character c : set) {
            builder.define(c.charValue(), ToolHelper.getToolFromSymbol((Character)Character.valueOf((char)c.charValue())).itemTags.get(0));
        }
        builder.save(provider);
        if (withUnificationData) {
            ChemicalHelper.registerMaterialInfo((class_1935)result.method_7909(), VanillaRecipeHelper.getRecyclingIngredients(result.method_7947(), recipe));
        }
    }

    public static void addShapedRecipe(Consumer<class_2444> provider, boolean withUnificationData, @Nonnull String regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, GTCEu.id(regName.toLowerCase(Locale.ROOT)), result, recipe);
    }

    public static void addShapedRecipe(Consumer<class_2444> provider, boolean withUnificationData, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<class_2444> provider, boolean withUnificationData, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, true, regName, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<class_2444> provider, @Nonnull String regName, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapelessRecipe(provider, GTCEu.id(regName.toLowerCase(Locale.ROOT)), result, recipe);
    }

    public static void addShapedEnergyTransferRecipe(Consumer<class_2444> provider, boolean withUnificationData, boolean overrideCharge, boolean transferMaxCharge, @Nonnull class_2960 regName, @Nonnull class_1856 chargeIngredient, @Nonnull class_1799 result, Object ... recipe) {
        ShapedEnergyTransferRecipeBuilder builder = new ShapedEnergyTransferRecipeBuilder(regName).output(result);
        builder.chargeIngredient(chargeIngredient).overrideCharge(overrideCharge).transferMaxCharge(transferMaxCharge);
        CharOpenHashSet set = new CharOpenHashSet();
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (Character c : ToolHelper.getToolSymbols()) {
                    if (pattern.indexOf(c.charValue()) < 0) continue;
                    set.add(c.charValue());
                }
            }
            if (o instanceof String[]) {
                pattern = (String[])o;
                for (String s : pattern) {
                    builder.pattern(s);
                    for (Character c : ToolHelper.getToolSymbols()) {
                        if (s.indexOf(c.charValue()) < 0) continue;
                        set.add(c.charValue());
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object content = recipe[i + 1];
            ++i;
            if (content instanceof class_1856) {
                class_1856 ingredient = (class_1856)content;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (content instanceof class_1799) {
                class_1799 itemStack = (class_1799)content;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (content instanceof class_6862) {
                class_6862 key = (class_6862)content;
                builder.define(sign.charValue(), (class_6862<class_1792>)key);
                continue;
            }
            if (content instanceof class_1935) {
                class_1935 itemLike = (class_1935)content;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                class_6862<class_1792> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (!(content instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)content;
            builder.define(sign.charValue(), entry.asStack());
        }
        for (Character c : set) {
            builder.define(c.charValue(), ToolHelper.getToolFromSymbol((Character)Character.valueOf((char)c.charValue())).itemTags.get(0));
        }
        builder.save(provider);
        if (withUnificationData) {
            ChemicalHelper.registerMaterialInfo((class_1935)result.method_7909(), VanillaRecipeHelper.getRecyclingIngredients(result.method_7947(), recipe));
        }
    }

    public static void addShapedEnergyTransferRecipe(Consumer<class_2444> provider, boolean withUnificationData, boolean overrideCharge, boolean transferMaxCharge, @Nonnull String regName, @Nonnull class_1856 chargeIngredient, @Nonnull class_1799 result, Object ... recipe) {
        VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, withUnificationData, overrideCharge, transferMaxCharge, GTCEu.id(regName.toLowerCase(Locale.ROOT)), chargeIngredient, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<class_2444> provider, @Nonnull class_2960 regName, @Nonnull class_1799 result, Object ... recipe) {
        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder(regName).output(result);
        for (Object content : recipe) {
            if (content instanceof class_1856) {
                class_1856 ingredient = (class_1856)content;
                builder.requires(ingredient);
                continue;
            }
            if (content instanceof class_1799) {
                class_1799 itemStack = (class_1799)content;
                builder.requires(itemStack);
                continue;
            }
            if (content instanceof class_6862) {
                class_6862 key = (class_6862)content;
                builder.requires((class_6862<class_1792>)key);
                continue;
            }
            if (content instanceof class_1935) {
                class_1935 itemLike = (class_1935)content;
                builder.requires(itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                class_6862<class_1792> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.requires(tag);
                    continue;
                }
                builder.requires(ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (content instanceof ItemProviderEntry) {
                ItemProviderEntry entry = (ItemProviderEntry)content;
                builder.requires(entry.asStack());
                continue;
            }
            if (!(content instanceof Character)) continue;
            Character c = (Character)content;
            builder.requires(ToolHelper.getToolFromSymbol((Character)Character.valueOf((char)c.charValue())).itemTags.get(0));
        }
        builder.save(provider);
    }

    public static ItemMaterialInfo getRecyclingIngredients(int outputCount, Object ... recipe) {
        Object object;
        Char2IntOpenHashMap inputCountMap = new Char2IntOpenHashMap();
        Object2LongOpenHashMap materialStacksExploded = new Object2LongOpenHashMap();
        int itr = 0;
        while ((object = recipe[itr]) instanceof String) {
            String s = (String)object;
            object = s.toCharArray();
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object c = object[i];
                if (ToolHelper.getToolFromSymbol(Character.valueOf((char)c)) != null) continue;
                int count = inputCountMap.getOrDefault((char)c, 0);
                inputCountMap.put((char)c, count + 1);
            }
            ++itr;
        }
        char lastChar = ' ';
        for (int i = itr; i < recipe.length; ++i) {
            TagPrefix prefix;
            class_1792 itemLike;
            Object ingredient = recipe[i];
            if (ingredient instanceof Character) {
                lastChar = ((Character)ingredient).charValue();
                continue;
            }
            if (lastChar == ' ') {
                return null;
            }
            if (ingredient instanceof class_1856) {
                class_1799 stack;
                class_1856 ingr = (class_1856)ingredient;
                class_1799[] stacks = ingr.method_8105();
                if (stacks.length == 0 || (stack = stacks[0]) == class_1799.field_8037) continue;
                itemLike = stack.method_7909();
            } else if (ingredient instanceof class_1799) {
                class_1799 itemStack = (class_1799)ingredient;
                itemLike = itemStack.method_7909();
            } else {
                if (ingredient instanceof class_6862) {
                    class_6862 key = (class_6862)ingredient;
                    continue;
                }
                if (ingredient instanceof class_1935) {
                    itemLike = (class_1935)ingredient;
                } else if (ingredient instanceof UnificationEntry) {
                    UnificationEntry entry = (UnificationEntry)ingredient;
                    class_1799 stack = ChemicalHelper.get(entry.tagPrefix, entry.material);
                    if (stack == class_1799.field_8037) continue;
                    itemLike = stack.method_7909();
                } else {
                    if (!(ingredient instanceof ItemProviderEntry)) continue;
                    ItemProviderEntry entry = (ItemProviderEntry)ingredient;
                    itemLike = entry.method_8389();
                }
            }
            ItemMaterialInfo info = ChemicalHelper.getMaterialInfo((class_1935)itemLike);
            if (info != null) {
                for (MaterialStack ms : info.getMaterials()) {
                    if (ms.material() instanceof MarkerMaterial) continue;
                    VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, ms, lastChar);
                }
                continue;
            }
            MaterialStack materialStack = ChemicalHelper.getMaterial((class_1935)itemLike);
            if (materialStack != null && !(materialStack.material() instanceof MarkerMaterial)) {
                VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, materialStack, lastChar);
            }
            if ((prefix = ChemicalHelper.getPrefix((class_1935)itemLike)) == null || prefix.secondaryMaterials().isEmpty()) continue;
            for (MaterialStack ms : prefix.secondaryMaterials()) {
                VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, ms, lastChar);
            }
        }
        return new ItemMaterialInfo(materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue() / (long)outputCount)).sorted(Comparator.comparingLong(m -> -m.amount())).collect(Collectors.toList()));
    }

    private static void addMaterialStack(@Nonnull Object2LongMap<Material> materialStacksExploded, @Nonnull Char2IntFunction inputCountMap, @Nonnull MaterialStack ms, char c) {
        long amount = materialStacksExploded.getOrDefault((Object)ms.material(), 0L);
        materialStacksExploded.put((Object)ms.material(), ms.amount() * (long)inputCountMap.get(c) + amount);
    }
}

