/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_155;
import net.minecraft.class_2444;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class GTDynamicDataPack
implements class_3262 {
    protected static final ObjectSet<String> SERVER_DOMAINS = new ObjectOpenHashSet();
    protected static final Map<class_2960, JsonObject> DATA = new HashMap<class_2960, JsonObject>();
    private final String name;

    public GTDynamicDataPack(String name, Collection<String> domains) {
        this.name = name;
        SERVER_DOMAINS.addAll(domains);
    }

    public static void clearServer() {
        DATA.clear();
    }

    public static void addRecipe(class_2444 recipe) {
        JsonObject recipeJson = recipe.method_17799();
        Path parent = Platform.getGamePath().resolve("gtceu/dumped/data");
        class_2960 recipeId = recipe.method_10417();
        if (ConfigHolder.INSTANCE.dev.dumpRecipes) {
            GTDynamicDataPack.writeJson(recipeId, "recipes", parent, (JsonElement)recipeJson);
        }
        if (DATA.containsKey(recipeId)) {
            GTCEu.LOGGER.error("duplicated recipe: {}", (Object)recipeId);
        }
        DATA.put(GTDynamicDataPack.getRecipeLocation(recipeId), recipeJson);
        if (recipe.method_10415() != null) {
            JsonObject advancement = recipe.method_10415();
            if (ConfigHolder.INSTANCE.dev.dumpRecipes) {
                GTDynamicDataPack.writeJson(recipe.method_10418(), "advancements", parent, (JsonElement)advancement);
            }
            DATA.put(GTDynamicDataPack.getAdvancementLocation(Objects.requireNonNull(recipe.method_10418())), advancement);
        }
    }

    @ApiStatus.Internal
    public static void writeJson(class_2960 id, @Nullable String subdir, Path parent, JsonElement json) {
        try {
            Path file = subdir != null ? parent.resolve(id.method_12836()).resolve(subdir).resolve(id.method_12832() + ".json") : parent.resolve(id.method_12836()).resolve(id.method_12832());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(json.toString().getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdvancement(class_2960 loc, JsonObject obj) {
        class_2960 l = GTDynamicDataPack.getAdvancementLocation(loc);
        Map<class_2960, JsonObject> map = DATA;
        synchronized (map) {
            DATA.put(l, obj);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        return null;
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        if (type == class_3264.field_14190) {
            if (DATA.containsKey(location)) {
                return () -> new ByteArrayInputStream(DATA.get(location).toString().getBytes(StandardCharsets.UTF_8));
            }
            return null;
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        if (packType == class_3264.field_14190) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String finalPath = path;
            DATA.keySet().stream().filter(Objects::nonNull).filter(loc -> loc.method_12832().startsWith(finalPath)).forEach(id -> {
                class_7367<InputStream> resource = this.method_14405(packType, (class_2960)id);
                if (resource != null) {
                    resourceOutput.accept(id, resource);
                }
            });
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return type == class_3264.field_14190 ? SERVER_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) {
        if (metaReader == class_3272.field_14202) {
            return (T)new class_3272((class_2561)class_2561.method_43470((String)"GTCEu dynamic data"), class_155.method_16673().method_48017(class_3264.field_14190));
        }
        if (metaReader.method_14420().equals("filter")) {
            JsonObject filter = new JsonObject();
            JsonArray block = new JsonArray();
            GTRecipes.recipeRemoval(id -> {
                JsonObject entry = new JsonObject();
                entry.addProperty("namespace", "^" + id.method_12836().replaceAll("[\\W]", "\\\\$0") + "$");
                entry.addProperty("path", "^recipes/" + id.method_12832().replaceAll("[\\W]", "\\\\$0") + "\\.json$");
                block.add((JsonElement)entry);
            });
            filter.add("block", (JsonElement)block);
            return (T)metaReader.method_14421(filter);
        }
        return null;
    }

    public String method_14409() {
        return this.name;
    }

    public void close() {
    }

    public static class_2960 getRecipeLocation(class_2960 recipeId) {
        return new class_2960(recipeId.method_12836(), String.join((CharSequence)"", "recipes/", recipeId.method_12832(), ".json"));
    }

    public static class_2960 getAdvancementLocation(class_2960 advancementId) {
        return new class_2960(advancementId.method_12836(), String.join((CharSequence)"", "advancements/", advancementId.method_12832(), ".json"));
    }

    public static class_2960 getTagLocation(String identifier, class_2960 tagId) {
        return new class_2960(tagId.method_12836(), String.join((CharSequence)"", "tags/", identifier, "/", tagId.method_12832(), ".json"));
    }

    static {
        SERVER_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtceu", "minecraft", "forge", "c"}));
    }
}

