/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBedrockFluids;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.GTFluidVeinEventJS;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidVeinLoader
extends class_4309 {
    public static FluidVeinLoader INSTANCE;
    public static final Gson GSON_INSTANCE;
    private static final String FOLDER = "gtceu/fluid_veins";
    protected static final Logger LOGGER;

    public FluidVeinLoader() {
        super(GSON_INSTANCE, FOLDER);
    }

    protected void apply(Map<class_2960, JsonElement> resourceList, class_3300 resourceManager, class_3695 profiler) {
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.registry().clear();
        GTBedrockFluids.init();
        if (GTCEu.isKubeJSLoaded()) {
            RunKJSEventInSeparateClassBecauseForgeIsDumb.fireKJSEvent();
        }
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)GTRegistries.builtinRegistry());
        for (Map.Entry<class_2960, JsonElement> entry : resourceList.entrySet()) {
            class_2960 location = entry.getKey();
            try {
                BedrockFluidDefinition fluid = FluidVeinLoader.fromJson(location, class_3518.method_15295((JsonElement)entry.getValue(), (String)"top element"), (class_6903<JsonElement>)ops);
                if (fluid == null) {
                    LOGGER.info("Skipping loading fluid vein {} as it's serializer returned null", (Object)location);
                    continue;
                }
                if (GTRegistries.BEDROCK_FLUID_DEFINITIONS.containKey(location)) {
                    GTRegistries.BEDROCK_FLUID_DEFINITIONS.replace(location, fluid);
                    continue;
                }
                GTRegistries.BEDROCK_FLUID_DEFINITIONS.register(location, fluid);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading ore vein {}", (Object)location, (Object)jsonParseException);
            }
        }
    }

    public static BedrockFluidDefinition fromJson(class_2960 id, JsonObject json, class_6903<JsonElement> ops) {
        return (BedrockFluidDefinition)BedrockFluidDefinition.FULL_CODEC.decode(ops, (Object)json).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    static {
        GSON_INSTANCE = class_5270.method_27861().create();
        LOGGER = LogManager.getLogger();
    }

    public static final class RunKJSEventInSeparateClassBecauseForgeIsDumb {
        public static void fireKJSEvent() {
            GTCEuServerEvents.FLUID_VEIN_MODIFICATION.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GTFluidVeinEventJS());
        }
    }
}

