/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import javax.annotation.Nonnull;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;

public class PositionYCondition
extends RecipeCondition {
    public static final PositionYCondition INSTANCE = new PositionYCondition();
    private int min;
    private int max;

    public PositionYCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public String getType() {
        return "pos_y";
    }

    @Override
    public class_2561 getTooltips() {
        return class_2561.method_43469((String)"recipe.condition.pos_y.tooltip", (Object[])new Object[]{this.min, this.max});
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean test(@Nonnull GTRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        int y = recipeLogic.machine.self().getPos().method_10264();
        return y >= this.min && y <= this.max;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new PositionYCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("min", (Number)this.min);
        config.addProperty("max", (Number)this.max);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.min = class_3518.method_15282((JsonObject)config, (String)"min", (int)Integer.MIN_VALUE);
        this.max = class_3518.method_15282((JsonObject)config, (String)"max", (int)Integer.MAX_VALUE);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(class_2540 buf) {
        super.fromNetwork(buf);
        this.min = buf.method_10816();
        this.max = buf.method_10816();
        return this;
    }

    @Override
    public void toNetwork(class_2540 buf) {
        super.toNetwork(buf);
        buf.method_10804(this.min);
        buf.method_10804(this.max);
    }

    public PositionYCondition() {
    }
}

