/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetWalker;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class LaserPipeNet
extends PipeNet<LaserData> {
    private final Map<class_2338, LaserData> netData = new Object2ObjectOpenHashMap();

    public LaserPipeNet(LevelLaserPipeNet world) {
        super((LevelPipeNet)world);
    }

    @Nullable
    public LaserData getNetData(class_2338 pipePos, class_2350 facing) {
        LaserData data = this.netData.get(pipePos);
        if (data == null) {
            data = LaserNetWalker.createNetData(this, pipePos, facing);
            if (data == null) {
                return null;
            }
            this.netData.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(class_2338 fromPos) {
        this.netData.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.netData.clear();
    }

    protected void transferNodeData(Map<class_2338, Node<LaserData>> transferredNodes, PipeNet<LaserData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.netData.clear();
        ((LaserPipeNet)parentNet).netData.clear();
    }

    protected void writeNodeData(LaserData nodeData, class_2487 tagCompound) {
        tagCompound.method_10566("pipePos", (class_2520)class_2512.method_10692((class_2338)nodeData.getPipePos()));
        tagCompound.method_10567("faceToHandler", (byte)nodeData.faceToHandler.ordinal());
        tagCompound.method_10569("distance", nodeData.distance);
        tagCompound.method_10567("connections", nodeData.connections);
    }

    protected LaserData readNodeData(class_2487 tagCompound) {
        class_2338 pipePos = class_2512.method_10691((class_2487)tagCompound.method_10562("pipePos"));
        class_2350 direction = class_2350.values()[tagCompound.method_10571("faceToHandler")];
        int distance = tagCompound.method_10550("distance");
        return new LaserData(pipePos, direction, distance, LaserPipeProperties.INSTANCE, tagCompound.method_10571("connections"));
    }

    public static class LaserData
    implements IAttachData {
        private final class_2338 pipePos;
        private final class_2350 faceToHandler;
        private final int distance;
        private final LaserPipeProperties properties;
        byte connections;

        @Override
        public boolean canAttachTo(class_2350 side) {
            return (this.connections & 1 << side.ordinal()) != 0 && side.method_10166() == this.faceToHandler.method_10166();
        }

        @Override
        public boolean setAttached(class_2350 side, boolean attach) {
            boolean result = this.canAttachTo(side);
            if (result != attach) {
                this.connections = attach ? (byte)(this.connections | 1 << side.ordinal()) : (byte)(this.connections & ~(1 << side.ordinal()));
            }
            return result != attach;
        }

        @Nonnull
        public class_2338 getHandlerPos() {
            return this.pipePos.method_10093(this.faceToHandler);
        }

        @Nullable
        public ILaserContainer getHandler(@Nonnull class_1937 world) {
            return GTCapabilityHelper.getLaser(world, this.getHandlerPos(), this.faceToHandler.method_10153());
        }

        public LaserData(class_2338 pipePos, class_2350 faceToHandler, int distance, LaserPipeProperties properties, byte connections) {
            this.pipePos = pipePos;
            this.faceToHandler = faceToHandler;
            this.distance = distance;
            this.properties = properties;
            this.connections = connections;
        }

        public class_2338 getPipePos() {
            return this.pipePos;
        }

        public class_2350 getFaceToHandler() {
            return this.faceToHandler;
        }

        public int getDistance() {
            return this.distance;
        }

        public LaserPipeProperties getProperties() {
            return this.properties;
        }

        public byte getConnections() {
            return this.connections;
        }
    }
}

