/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.CableRoutePath;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNetWalker;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;

public class EnergyNet
extends PipeNet<CableData> {
    public static final int DEFAULT_TEMPERATURE = 293;
    public static final int MELT_TEMP = 3000;
    public static final int SMOKE_TEMP = 2000;
    private final Map<class_2338, List<CableRoutePath>> NET_DATA = new HashMap<class_2338, List<CableRoutePath>>();
    private final Long2IntMap cableHeat = new Long2IntOpenHashMap();
    private final Long2LongMap cableAmps = new Long2LongOpenHashMap();
    private long lastHeatUpdate;
    private long lastVoltageUpdate;

    protected EnergyNet(LevelPipeNet<CableData, ? extends EnergyNet> world) {
        super(world);
        this.lastVoltageUpdate = this.lastHeatUpdate = world.getWorld().method_8510();
    }

    public List<CableRoutePath> getNetData(class_2338 pipePos) {
        List<CableRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = EnergyNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(CableRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(class_2338 fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    protected void transferNodeData(Map<class_2338, Node<CableData>> transferredNodes, PipeNet<CableData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((EnergyNet)parentNet).NET_DATA.clear();
    }

    protected void writeNodeData(CableData nodeData, class_2487 tagCompound) {
        tagCompound.method_10569("voltage", nodeData.properties().getVoltage());
        tagCompound.method_10569("amperage", nodeData.properties().getAmperage());
        tagCompound.method_10569("loss", nodeData.properties().getLossPerBlock());
        tagCompound.method_10567("connections", nodeData.connections());
    }

    protected CableData readNodeData(class_2487 tagCompound) {
        int voltage = tagCompound.method_10550("voltage");
        int amperage = tagCompound.method_10550("amperage");
        int lossPerBlock = tagCompound.method_10550("loss");
        return new CableData(new WireProperties(voltage, amperage, lossPerBlock), tagCompound.method_10571("connections"));
    }

    private void updateCableHeat() {
        long latestTime = this.getWorldData().getWorld().method_8510();
        long duration = latestTime - this.lastHeatUpdate;
        this.lastHeatUpdate = latestTime;
        if (duration > 0L) {
            ObjectIterator iter = this.cableHeat.long2IntEntrySet().iterator();
            while (iter.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iter.next();
                if (this.containsNode(class_2338.method_10092((long)entry.getLongKey()))) {
                    int temp = entry.getIntValue();
                    long newTemp = (long)temp - duration * 50L;
                    if (newTemp > 293L) {
                        entry.setValue((int)newTemp);
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        } else if (duration < 0L) {
            this.cableHeat.clear();
        }
    }

    public boolean applyHeat(class_2338 cablePos, int heat) {
        this.updateCableHeat();
        int current = this.cableHeat.getOrDefault(cablePos.method_10063(), 293);
        if (current + heat > 2000) {
            class_2350 facing = class_2350.field_11036;
            float xPos = (float)facing.method_10148() * 0.76f + (float)cablePos.method_10263() + 0.25f;
            float yPos = (float)facing.method_10164() * 0.76f + (float)cablePos.method_10264() + 0.25f;
            float zPos = (float)facing.method_10165() * 0.76f + (float)cablePos.method_10260() + 0.25f;
            float ySpd = (float)facing.method_10164() * 0.1f + 0.2f + 0.1f * GTValues.RNG.method_43057();
            float temp = GTValues.RNG.method_43057() * 2.0f * (float)Math.PI;
            float xSpd = (float)Math.sin(temp) * 0.1f;
            float zSpd = (float)Math.cos(temp) * 0.1f;
            this.getLevel().method_14199((class_2394)class_2398.field_11251, (double)(xPos + GTValues.RNG.method_43057() * 0.5f), (double)(yPos + GTValues.RNG.method_43057() * 0.5f), (double)(zPos + GTValues.RNG.method_43057() * 0.5f), 10, (double)xSpd, (double)ySpd, (double)zSpd, 0.1);
        }
        if (current + heat > 3000) {
            this.cableHeat.remove(cablePos.method_10063());
            return true;
        }
        this.cableHeat.put(cablePos.method_10063(), current + heat);
        return false;
    }

    private void updateCableVoltage() {
        long latestTime = this.getWorldData().getWorld().method_8510();
        if (this.lastVoltageUpdate != latestTime) {
            this.cableAmps.clear();
        }
        this.lastVoltageUpdate = latestTime;
    }

    public boolean incrementAmperage(class_2338 cablePos, long amps, int maxAmps) {
        this.updateCableVoltage();
        long lastAmps = this.cableAmps.getOrDefault(cablePos.method_10063(), 0L);
        this.cableAmps.put(cablePos.method_10063(), lastAmps + amps);
        long dif = lastAmps + amps - (long)maxAmps;
        if (dif > 0L) {
            return this.applyHeat(cablePos, (int)(dif * 40L));
        }
        return false;
    }
}

