/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.StressRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.gregtechceu.gtceu.common.machine.kinetic.IKineticMachine;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class NotifiableStressTrait
extends NotifiableRecipeHandlerTrait<Float>
implements ICapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableStressTrait.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    private long timeStamp;
    public final IO handlerIO;
    public final IO capabilityIO;
    private float available;
    private float lastSpeed;

    public NotifiableStressTrait(MetaMachine machine, IO handlerIO, IO capabilityIO) {
        super(machine);
        this.handlerIO = handlerIO;
        this.capabilityIO = capabilityIO;
        this.lastSpeed = 0.0f;
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IKineticMachine) {
            IKineticMachine kineticMachine = (IKineticMachine)((Object)metaMachine);
            this.machine.subscribeServerTick(() -> {
                float speed = kineticMachine.getKineticHolder().getSpeed();
                if (speed != this.lastSpeed) {
                    this.lastSpeed = speed;
                    this.notifyListeners();
                }
            });
        }
    }

    @Override
    public List<Float> handleRecipeInner(IO io, GTRecipe recipe, List<Float> left, @Nullable String slotName, boolean simulate) {
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IKineticMachine) {
            IKineticMachine kineticMachine = (IKineticMachine)((Object)metaMachine);
            float sum = left.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
            KineticMachineDefinition kineticDefinition = kineticMachine.getKineticDefinition();
            if (io == IO.IN && !kineticDefinition.isSource()) {
                float capacity = class_3532.method_15379((float)kineticMachine.getKineticHolder().getSpeed()) * kineticDefinition.torque;
                if (capacity > 0.0f) {
                    sum -= capacity;
                }
            } else if (io == IO.OUT && kineticDefinition.isSource()) {
                if (simulate) {
                    this.available = kineticMachine.getKineticHolder().scheduleWorking(sum, true);
                }
                sum -= this.available;
            }
            return sum <= 0.0f ? null : Collections.singletonList(Float.valueOf(sum));
        }
        return left;
    }

    @Override
    public void preWorking(IRecipeCapabilityHolder holder, IO io, GTRecipe recipe) {
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IKineticMachine) {
            IKineticMachine kineticMachine = (IKineticMachine)((Object)metaMachine);
            KineticMachineDefinition kineticDefinition = kineticMachine.getKineticDefinition();
            if (this.available > 0.0f && kineticDefinition.isSource() && io == IO.OUT) {
                kineticMachine.getKineticHolder().scheduleWorking(this.available, false);
            }
        }
    }

    @Override
    public void postWorking(IRecipeCapabilityHolder holder, IO io, GTRecipe recipe) {
        IKineticMachine kineticMachine;
        KineticMachineDefinition kineticDefinition;
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IKineticMachine && (kineticDefinition = (kineticMachine = (IKineticMachine)((Object)metaMachine)).getKineticDefinition()).isSource() && io == IO.OUT) {
            kineticMachine.getKineticHolder().stopWorking();
        }
    }

    @Override
    public RecipeCapability<Float> getCapability() {
        return StressRecipeCapability.CAP;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }
}

