/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_6179;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6179
public class DrumMachine
extends MetaMachine
implements IAutoOutputFluid,
IDropSaveMachine,
IInteractedMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DrumMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    private final int maxStoredFluids;
    @Persisted
    protected final NotifiableFluidTank cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Persisted(key="Fluid")
    @DescSynced
    @DropSaved
    protected FluidStack stored = FluidStack.empty();
    protected final Material material;

    public DrumMachine(IMachineBlockEntity holder, Material material, int maxStoredFluids, Object ... args) {
        super(holder);
        this.material = material;
        this.maxStoredFluids = maxStoredFluids;
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, this.maxStoredFluids, IO.BOTH).setFilter(this.material.getProperty(PropertyKey.FLUID_PIPE));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateStoredFluidFromCache();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
        }
        this.exportFluidSubs = this.cache.addChangedListener(this::onFluidChanged);
    }

    private void onFluidChanged() {
        if (!this.isRemote()) {
            this.updateStoredFluidFromCache();
            this.updateAutoOutputSubscription();
        }
    }

    private void updateStoredFluidFromCache() {
        FluidStack cachedFluid = this.cache.getFluidInTank(0);
        this.stored = cachedFluid.isEmpty() ? FluidStack.empty() : cachedFluid;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
    }

    @Override
    public void loadFromItem(class_2487 tag) {
        IDropSaveMachine.super.loadFromItem(tag);
        if (!tag.method_10545("Fluid")) {
            this.stored = FluidStack.empty();
        }
        this.cache.storages[0].setFluid(this.stored.copy());
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allow) {
    }

    @Override
    public void setOutputFacingFluids(@Nullable class_2350 outputFacing) {
        this.updateAutoOutputSubscription();
    }

    @Override
    @Nullable
    public class_2350 getOutputFacingFluids() {
        return class_2350.field_11033;
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacing), (class_2350)outputFacing.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 currentStack = player.method_6047();
        if (!currentStack.method_7960()) {
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer((class_1657)player, (class_1268)class_1268.field_5808);
            FluidStorage fluidTank = this.cache.storages[0];
            if (handler != null && !this.isRemote()) {
                FluidActionResult result;
                if (this.cache.storages[0].getFluidAmount() > 0L) {
                    FluidStack initialFluid = fluidTank.getFluid();
                    FluidActionResult result2 = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false);
                    if (result2.isSuccess()) {
                        class_1799 remainingStack = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                        currentStack.method_7934(1);
                        class_3414 soundevent = FluidHelper.getFillSound((FluidStack)initialFluid);
                        if (soundevent != null) {
                            player.method_37908().method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                        }
                        if (!remainingStack.method_7960() && !player.method_7270(remainingStack)) {
                            class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                        }
                        return class_1269.field_5812;
                    }
                }
                if ((result = FluidTransferHelper.tryEmptyContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
                    class_1799 remainingStack = FluidTransferHelper.tryEmptyContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                    currentStack.method_7934(1);
                    class_3414 soundevent = FluidHelper.getEmptySound((FluidStack)fluidTank.getFluid());
                    if (soundevent != null) {
                        player.method_37908().method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    if (!remainingStack.method_7960() && !player.method_31548().method_7394(remainingStack)) {
                        class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return world.field_9236 ? class_1269.field_5812 : class_1269.field_5811;
    }

    @Override
    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!this.isRemote() && !playerIn.method_18276()) {
            this.setAutoOutputFluids(!this.isAutoOutputFluids());
            playerIn.method_43496((class_2561)class_2561.method_43471((String)("gtceu.machine.drum." + (this.autoOutputFluids ? "enable" : "disable") + "_output")));
            return class_1269.field_5812;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingFluids()) {
            return this.isAutoOutputFluids() ? GuiTextures.TOOL_DISABLE_AUTO_OUTPUT : GuiTextures.TOOL_AUTO_OUTPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    public int getMaxStoredFluids() {
        return this.maxStoredFluids;
    }

    public FluidStack getStored() {
        return this.stored;
    }

    public Material getMaterial() {
        return this.material;
    }
}

